/*
 * This file is part of the ESO UVES Pipeline
 * Copyright (C) 2004,2005 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA
 */

/*
 * $Author: amodigli $
 * $Date: 2012-10-08 11:35:40 $
 * $Revision: 1.20 $
 * $Name: not supported by cvs2svn $
 * $Log: not supported by cvs2svn $
 * Revision 1.19  2011/12/08 13:52:55  amodigli
 * include uves_cpl_size.h
 *
 * Revision 1.18  2010/09/24 09:31:30  amodigli
 * put back QFITS dependency to fix problem spot by NRI on FIBER mode (with MIDAS calibs) data
 *
 * Revision 1.16  2009/04/14 07:10:49  amodigli
 * removed flames_reduce_vcorrel declaration
 *
 * Revision 1.15  2009/02/27 17:00:43  amodigli
 * changes to make zero point update directly in function
 *
 * Revision 1.14  2008/06/27 05:57:42  amodigli
 * change flames_reduce_vcorrel API
 *
 * Revision 1.13  2008/06/26 08:24:33  amodigli
 * changed interface corvel computation
 *
 * Revision 1.12  2008/04/04 14:02:26  amodigli
 * added flames_my_cubify2
 *
 * Revision 1.11  2008/01/17 17:29:59  amodigli
 * fix bug flames_spectra_to_image
 *
 * Revision 1.10  2007/12/15 09:56:14  amodigli
 * changed interface flames_reset_desc_set2
 *
 * Revision 1.9  2007/12/10 07:34:27  amodigli
 * added flames_reduce_add_wstart flames_reduce_vcorrel
 *
 * Revision 1.8  2007/11/19 08:08:35  amodigli
 * changed interface flames_spectra_to_image()
 *
 * Revision 1.7  2007/10/01 17:23:37  amodigli
 * fixed several bugs in cubify/decubify and called function to set proper FITS header and make work properly science reduction
 *
 * Revision 1.6  2007/09/19 11:50:54  amodigli
 * added flames_drs_merge
 *
 * Revision 1.5  2007/09/13 16:02:28  amodigli
 * moved some functions here to allow unit tests
 *
 * Revision 1.4  2007/09/11 06:41:20  amodigli
 * added flames_replicate_frame & changed interface of flames_my_decubify
 *
 * Revision 1.3  2007/08/31 14:20:02  amodigli
 * added flames_cubes_to_supercube
 *
 * Revision 1.2  2007/08/31 06:40:05  amodigli
 * added flames_reduce_reset_descriptors flames_my_decubify flames_my_cubify flames_spectra_to_image flames_images_to_cube from flames_obs_scired.c
 *
 * Revision 1.1  2007/08/13 12:13:37  amodigli
 * added to repository
 *
 *
 */
#ifndef FLAMES_UTILS_SCIENCE_H
#define FLAMES_UTILS_SCIENCE_H

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <uves_cpl_size.h>
/*-----------------------------------------------------------------------------
                    Includes
 ----------------------------------------------------------------------------*/
#include <cpl.h>
#include <uves_chip.h>
#include <uves_propertylist.h>
#include <flames_uves.h>
#include <flames_midas_def.h>
#include <flames_reduce_vcorrel.h>

/*-----------------------------------------------------------------------------
                             Defines
 ----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
                                   Prototypes
 ----------------------------------------------------------------------------*/
flames_err
flames_add_desc_data(const char* file_ref,
		     const char* file_out, 
		     const int ndat,
                     const int in_frm_id);



flames_err
flames_add_desc_bpmap(const char* file_ref,
		      const char* file_out, 
		      const int ndat,
                      const int in_frm_id);

flames_err
flames_add_desc_sigma(const char* file_ref,
		      const char* file_out, 
		      const int ndat,
                      const int in_frm_id);

flames_err
flames_add_desc_bound(const char* file_ref,
		      const char* file_out, 
		      const int ndat,
                      const int in_frm_id);


int
flames_extract_ima_from_cube(cpl_frameset* frames,
			     const char* tag,
                             enum uves_chip chip,
			     const char* cub_name,
			     cpl_frameset** set_out);

int
flames_drs_merge(const char* inp_ima, 
                 const char* out_base_reb, 
                 const char* out_base_mer,
                 const int fibre_id,
                 const int raw_switch,
                 const double delta1,
                 const double delta2);

flames_err
flames_reset_desc_data(const char* name_inp,
                       const int nflats,
                       const char* base_out,
                       const int in_frm_id,
		       enum uves_chip chip);


flames_err
flames_reset_desc_set4(const int out_id,
                       const int dat_id, 
                       const int it,
                       const int in_frm_id);

flames_err
flames_reset_desc_set2(const int dat_id, 
                       const int it,
                       const int in_frm_id);

flames_err
flames_reset_desc_set0(const int out_id,
                       const int dat_id, 
                       const int it,
                       const int in_frm_id);


flames_err
flames_reset_desc_set3(const int out_id,
                       const int dat_id, 
                       const int it,
                       const int in_frm_id);

int
flames_fix_start_and_npix(const char* name, const int format);

int
flames_reset_start_and_npix(const char* name, const char* tag);


int
flames_reduce_reset_descriptors(uves_propertylist* head_ref,
                                uves_propertylist** file_out,
                                const int i);


int
flames_my_decubify(cpl_frameset* set,
                   enum uves_chip chip,
		   const int frm_type,
                   cpl_frameset** set_out);

int
flames_my_cubify(enum uves_chip chip,
		 const int frm_type,
		 cpl_frameset** set_out);

int
flames_my_cubify2(enum uves_chip chip,
		 const int frm_type,
		 cpl_frameset** set_out,
                      cpl_frameset *frames,
                      const uves_propertylist *raw_header,
                      const cpl_parameterlist *parameters,
                      const char *recipe_id,
                  const char *starttime);

int
flames_spectra_to_image(
			const char* inp_basename,
			const char* inp_filename_qual,
			const char* out_filename,
			const int min,
			const int max,
                        const cpl_table* xtab,
                        const int pno);
int
flames_spectra_to_image_check(
			const char* inp_basename,
			const char* inp_filename_qual,
			const char* out_filename,
			const int min,
			const int max,
                        const cpl_table* xtab,
                        const int pno);
int
flames_images_to_cube(
                   const char* inp_basename,
                   const char* out_filename,
                   const char* inp_format_digit,
                   const int min,
                   const int max);
int
flames_images_to_cube_check(
		      const char* inp_basename,
		      const char* out_filename,
		      const char* inp_format_digit,
		      int* fibre_mask_frm,
		      const int min, 
		      const int max);
int
flames_cubes_to_supercube(
                   const char* inp_basename,
                   const char* out_filename,
                   const char* inp_format_digit,
                   const int min,
                   const int max);

int
flames_replicate_frame(cpl_frameset* frames,
                       const char* tag,
                       const char* name,
                       cpl_frameset** set);



int
flames_reduce_add_wstart(uves_propertylist* head_ref,
                         uves_propertylist** head_out,
                         const int nord);


#endif
