; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main-none-none-eabi -mattr=+mve.fp,+fp64 -verify-machineinstrs %s -o - | FileCheck %s

; i32

define void @vst3_v2i32(<2 x i32> *%src, <6 x i32> *%dst) {
; CHECK-LABEL: vst3_v2i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, lr}
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    ldrd r12, r3, [r0]
; CHECK-NEXT:    ldrd lr, r2, [r0, #8]
; CHECK-NEXT:    ldrd r4, r0, [r0, #16]
; CHECK-NEXT:    vmov.32 q1[1], r3
; CHECK-NEXT:    vmov q1[2], q1[0], r12, lr
; CHECK-NEXT:    strd r2, r0, [r1, #16]
; CHECK-NEXT:    vmov q0[2], q0[0], r4, r0
; CHECK-NEXT:    vmov.f32 s8, s4
; CHECK-NEXT:    vmov.f32 s9, s6
; CHECK-NEXT:    vmov.f32 s10, s0
; CHECK-NEXT:    vmov.f32 s11, s5
; CHECK-NEXT:    vstrw.32 q2, [r1]
; CHECK-NEXT:    pop {r4, pc}
entry:
  %s1 = getelementptr <2 x i32>, <2 x i32>* %src, i32 0
  %l1 = load <2 x i32>, <2 x i32>* %s1, align 4
  %s2 = getelementptr <2 x i32>, <2 x i32>* %src, i32 1
  %l2 = load <2 x i32>, <2 x i32>* %s2, align 4
  %s3 = getelementptr <2 x i32>, <2 x i32>* %src, i32 2
  %l3 = load <2 x i32>, <2 x i32>* %s3, align 4
  %t1 = shufflevector <2 x i32> %l1, <2 x i32> %l2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %t2 = shufflevector <2 x i32> %l3, <2 x i32> undef, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %s = shufflevector <4 x i32> %t1, <4 x i32> %t2, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
  store <6 x i32> %s, <6 x i32> *%dst
  ret void
}

define void @vst3_v4i32(<4 x i32> *%src, <12 x i32> *%dst) {
; CHECK-LABEL: vst3_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    vldrw.u32 q2, [r0]
; CHECK-NEXT:    vldrw.u32 q3, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q0, [r0, #32]
; CHECK-NEXT:    vmov.f32 s4, s8
; CHECK-NEXT:    vmov r0, r2, d0
; CHECK-NEXT:    vmov.f32 s5, s12
; CHECK-NEXT:    vmov.f32 s7, s9
; CHECK-NEXT:    vmov.f32 s16, s13
; CHECK-NEXT:    vmov.32 q1[2], r0
; CHECK-NEXT:    vmov.f32 s18, s10
; CHECK-NEXT:    vstrw.32 q1, [r1]
; CHECK-NEXT:    vmov.f32 s19, s14
; CHECK-NEXT:    vmov.f32 s0, s2
; CHECK-NEXT:    vmov.32 q4[1], r2
; CHECK-NEXT:    vmov.f32 s1, s11
; CHECK-NEXT:    vstrw.32 q4, [r1, #16]
; CHECK-NEXT:    vmov.f32 s2, s15
; CHECK-NEXT:    vstrw.32 q0, [r1, #32]
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <4 x i32>, <4 x i32>* %src, i32 0
  %l1 = load <4 x i32>, <4 x i32>* %s1, align 4
  %s2 = getelementptr <4 x i32>, <4 x i32>* %src, i32 1
  %l2 = load <4 x i32>, <4 x i32>* %s2, align 4
  %s3 = getelementptr <4 x i32>, <4 x i32>* %src, i32 2
  %l3 = load <4 x i32>, <4 x i32>* %s3, align 4
  %t1 = shufflevector <4 x i32> %l1, <4 x i32> %l2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %t2 = shufflevector <4 x i32> %l3, <4 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <8 x i32> %t1, <8 x i32> %t2, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  store <12 x i32> %s, <12 x i32> *%dst
  ret void
}

define void @vst3_v8i32(<8 x i32> *%src, <24 x i32> *%dst) {
; CHECK-LABEL: vst3_v8i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vldrw.u32 q3, [r0]
; CHECK-NEXT:    vldrw.u32 q7, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q0, [r0, #80]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #64]
; CHECK-NEXT:    vmov.f32 s4, s12
; CHECK-NEXT:    vldrw.u32 q4, [r0, #32]
; CHECK-NEXT:    vmov.f32 s12, s28
; CHECK-NEXT:    vldrw.u32 q6, [r0, #16]
; CHECK-NEXT:    vmov r2, lr, d0
; CHECK-NEXT:    vmov r12, r3, d4
; CHECK-NEXT:    vmov.f32 s0, s2
; CHECK-NEXT:    vmov.f32 s2, s31
; CHECK-NEXT:    vmov.f32 s20, s29
; CHECK-NEXT:    vmov.f32 s9, s15
; CHECK-NEXT:    vmov.f32 s29, s12
; CHECK-NEXT:    vmov.f32 s5, s16
; CHECK-NEXT:    vmov.f32 s7, s13
; CHECK-NEXT:    vmov.f32 s22, s26
; CHECK-NEXT:    vmov.32 q1[2], r12
; CHECK-NEXT:    vmov.f32 s23, s30
; CHECK-NEXT:    vstrw.32 q1, [r1]
; CHECK-NEXT:    vmov.f32 s28, s24
; CHECK-NEXT:    vmov.32 q5[1], lr
; CHECK-NEXT:    vmov.f32 s31, s25
; CHECK-NEXT:    vstrw.32 q5, [r1, #64]
; CHECK-NEXT:    vmov.f32 s12, s17
; CHECK-NEXT:    vmov.32 q7[2], r2
; CHECK-NEXT:    vmov.f32 s15, s18
; CHECK-NEXT:    vstrw.32 q7, [r1, #48]
; CHECK-NEXT:    vmov.f32 s1, s27
; CHECK-NEXT:    vmov.32 q3[1], r3
; CHECK-NEXT:    vmov.f32 s8, s10
; CHECK-NEXT:    vstrw.32 q3, [r1, #16]
; CHECK-NEXT:    vmov.f32 s10, s19
; CHECK-NEXT:    vstrw.32 q0, [r1, #80]
; CHECK-NEXT:    vstrw.32 q2, [r1, #32]
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    pop {r7, pc}
entry:
  %s1 = getelementptr <8 x i32>, <8 x i32>* %src, i32 0
  %l1 = load <8 x i32>, <8 x i32>* %s1, align 4
  %s2 = getelementptr <8 x i32>, <8 x i32>* %src, i32 1
  %l2 = load <8 x i32>, <8 x i32>* %s2, align 4
  %s3 = getelementptr <8 x i32>, <8 x i32>* %src, i32 2
  %l3 = load <8 x i32>, <8 x i32>* %s3, align 4
  %t1 = shufflevector <8 x i32> %l1, <8 x i32> %l2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %t2 = shufflevector <8 x i32> %l3, <8 x i32> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <16 x i32> %t1, <16 x i32> %t2, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
  store <24 x i32> %s, <24 x i32> *%dst
  ret void
}

define void @vst3_v16i32(<16 x i32> *%src, <48 x i32> *%dst) {
; CHECK-LABEL: vst3_v16i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, lr}
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    .pad #160
; CHECK-NEXT:    sub sp, #160
; CHECK-NEXT:    vldrw.u32 q3, [r0, #160]
; CHECK-NEXT:    vldrw.u32 q0, [r0, #64]
; CHECK-NEXT:    vldrw.u32 q5, [r0, #128]
; CHECK-NEXT:    vldrw.u32 q1, [r0]
; CHECK-NEXT:    vstrw.32 q3, [sp, #144] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q3, [r0, #144]
; CHECK-NEXT:    vmov r12, r3, d10
; CHECK-NEXT:    vldrw.u32 q7, [r0, #176]
; CHECK-NEXT:    vstrw.32 q3, [sp, #80] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q3, [r0, #96]
; CHECK-NEXT:    vldrw.u32 q6, [r0, #32]
; CHECK-NEXT:    vmov.f32 s8, s1
; CHECK-NEXT:    vstrw.32 q3, [sp, #16] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q3, [r0, #80]
; CHECK-NEXT:    vmov.f32 s10, s6
; CHECK-NEXT:    vldrw.u32 q4, [r0, #112]
; CHECK-NEXT:    vmov.f32 s11, s2
; CHECK-NEXT:    vstrw.32 q3, [sp, #64] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q3, [r0, #48]
; CHECK-NEXT:    vmov.32 q2[1], r3
; CHECK-NEXT:    vstrw.32 q6, [sp] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q6, [r0, #16]
; CHECK-NEXT:    vstrw.32 q2, [r1, #16]
; CHECK-NEXT:    vmov.f32 s20, s22
; CHECK-NEXT:    vmov.f32 s22, s3
; CHECK-NEXT:    vstrw.32 q7, [sp, #48] @ 16-byte Spill
; CHECK-NEXT:    vmov.f32 s9, s0
; CHECK-NEXT:    vmov.f32 s8, s4
; CHECK-NEXT:    vmov.f32 s11, s5
; CHECK-NEXT:    vmov.f32 s0, s30
; CHECK-NEXT:    vstrw.32 q2, [sp, #128] @ 16-byte Spill
; CHECK-NEXT:    vmov.f32 s1, s15
; CHECK-NEXT:    vldrw.u32 q2, [sp, #16] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s2, s19
; CHECK-NEXT:    vmov.f32 s3, s31
; CHECK-NEXT:    vstrw.32 q0, [sp, #112] @ 16-byte Spill
; CHECK-NEXT:    vmov.f32 s0, s17
; CHECK-NEXT:    vmov.f32 s2, s14
; CHECK-NEXT:    vmov.f32 s3, s18
; CHECK-NEXT:    vmov.f32 s21, s7
; CHECK-NEXT:    vstrw.32 q0, [sp, #96] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q0, [sp, #144] @ 16-byte Reload
; CHECK-NEXT:    vstrw.32 q5, [r1, #32]
; CHECK-NEXT:    vmov.f32 s22, s11
; CHECK-NEXT:    vldrw.u32 q1, [sp] @ 16-byte Reload
; CHECK-NEXT:    vmov.f64 d0, d4
; CHECK-NEXT:    vmov.f32 s19, s10
; CHECK-NEXT:    vldrw.u32 q2, [sp, #80] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s21, s7
; CHECK-NEXT:    vmov.f64 d14, d4
; CHECK-NEXT:    vmov.f32 s20, s2
; CHECK-NEXT:    vmov.f32 s23, s3
; CHECK-NEXT:    vstrw.32 q5, [sp, #32] @ 16-byte Spill
; CHECK-NEXT:    vmov.f32 s21, s16
; CHECK-NEXT:    vmov.f32 s23, s13
; CHECK-NEXT:    vmov.f32 s16, s1
; CHECK-NEXT:    vmov.f32 s13, s0
; CHECK-NEXT:    vldrw.u32 q0, [sp, #64] @ 16-byte Reload
; CHECK-NEXT:    vmov r0, r3, d14
; CHECK-NEXT:    vldrw.u32 q7, [sp, #48] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s7, s11
; CHECK-NEXT:    vmov.f32 s8, s24
; CHECK-NEXT:    vmov.f32 s9, s0
; CHECK-NEXT:    vmov.f32 s11, s25
; CHECK-NEXT:    vmov.f32 s20, s12
; CHECK-NEXT:    vmov.f32 s12, s4
; CHECK-NEXT:    vmov.f32 s4, s10
; CHECK-NEXT:    vmov.32 q2[2], r0
; CHECK-NEXT:    vmov r0, lr, d14
; CHECK-NEXT:    vldrw.u32 q7, [sp, #144] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s18, s6
; CHECK-NEXT:    vmov.32 q5[2], r0
; CHECK-NEXT:    vmov.f64 d12, d14
; CHECK-NEXT:    vstrw.32 q2, [r1, #48]
; CHECK-NEXT:    vstrw.32 q5, [r1, #144]
; CHECK-NEXT:    vmov.f32 s15, s5
; CHECK-NEXT:    vmov.f32 s5, s27
; CHECK-NEXT:    vmov.f32 s6, s3
; CHECK-NEXT:    vmov.f32 s24, s1
; CHECK-NEXT:    vstrw.32 q1, [r1, #80]
; CHECK-NEXT:    vmov.f32 s27, s2
; CHECK-NEXT:    vldrw.u32 q0, [sp, #32] @ 16-byte Reload
; CHECK-NEXT:    vmov r2, r4, d14
; CHECK-NEXT:    vmov.32 q6[1], r3
; CHECK-NEXT:    vstrw.32 q0, [r1, #128]
; CHECK-NEXT:    vldrw.u32 q0, [sp, #96] @ 16-byte Reload
; CHECK-NEXT:    vmov.32 q3[2], r2
; CHECK-NEXT:    vmov.32 q4[1], r4
; CHECK-NEXT:    vmov.32 q0[1], lr
; CHECK-NEXT:    vstrw.32 q6, [r1, #64]
; CHECK-NEXT:    vstrw.32 q0, [r1, #160]
; CHECK-NEXT:    vldrw.u32 q0, [sp, #112] @ 16-byte Reload
; CHECK-NEXT:    vstrw.32 q3, [r1, #96]
; CHECK-NEXT:    vstrw.32 q4, [r1, #112]
; CHECK-NEXT:    vstrw.32 q0, [r1, #176]
; CHECK-NEXT:    vldrw.u32 q0, [sp, #128] @ 16-byte Reload
; CHECK-NEXT:    vmov.32 q0[2], r12
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    add sp, #160
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    pop {r4, pc}
entry:
  %s1 = getelementptr <16 x i32>, <16 x i32>* %src, i32 0
  %l1 = load <16 x i32>, <16 x i32>* %s1, align 4
  %s2 = getelementptr <16 x i32>, <16 x i32>* %src, i32 1
  %l2 = load <16 x i32>, <16 x i32>* %s2, align 4
  %s3 = getelementptr <16 x i32>, <16 x i32>* %src, i32 2
  %l3 = load <16 x i32>, <16 x i32>* %s3, align 4
  %t1 = shufflevector <16 x i32> %l1, <16 x i32> %l2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %t2 = shufflevector <16 x i32> %l3, <16 x i32> undef, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <32 x i32> %t1, <32 x i32> %t2, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
  store <48 x i32> %s, <48 x i32> *%dst
  ret void
}

; i16

define void @vst3_v2i16(<2 x i16> *%src, <6 x i16> *%dst) {
; CHECK-LABEL: vst3_v2i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, lr}
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    ldrh r2, [r0, #10]
; CHECK-NEXT:    ldrh r4, [r0, #8]
; CHECK-NEXT:    ldrh.w r12, [r0, #2]
; CHECK-NEXT:    ldrh.w lr, [r0]
; CHECK-NEXT:    vmov q0[2], q0[0], r4, r2
; CHECK-NEXT:    ldrh r3, [r0, #6]
; CHECK-NEXT:    ldrh r0, [r0, #4]
; CHECK-NEXT:    vmov q1[2], q1[0], r0, r3
; CHECK-NEXT:    vmov q2, q1
; CHECK-NEXT:    vmovnt.i32 q2, q0
; CHECK-NEXT:    vmov q0[2], q0[0], lr, r12
; CHECK-NEXT:    vmov r0, s10
; CHECK-NEXT:    vmov.f32 s1, s4
; CHECK-NEXT:    vmov.f32 s3, s2
; CHECK-NEXT:    vmov.32 q0[2], r4
; CHECK-NEXT:    vstrh.32 q0, [r1]
; CHECK-NEXT:    str r0, [r1, #8]
; CHECK-NEXT:    pop {r4, pc}
entry:
  %s1 = getelementptr <2 x i16>, <2 x i16>* %src, i32 0
  %l1 = load <2 x i16>, <2 x i16>* %s1, align 4
  %s2 = getelementptr <2 x i16>, <2 x i16>* %src, i32 1
  %l2 = load <2 x i16>, <2 x i16>* %s2, align 4
  %s3 = getelementptr <2 x i16>, <2 x i16>* %src, i32 2
  %l3 = load <2 x i16>, <2 x i16>* %s3, align 4
  %t1 = shufflevector <2 x i16> %l1, <2 x i16> %l2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %t2 = shufflevector <2 x i16> %l3, <2 x i16> undef, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %s = shufflevector <4 x i16> %t1, <4 x i16> %t2, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
  store <6 x i16> %s, <6 x i16> *%dst
  ret void
}

define void @vst3_v4i16(<4 x i16> *%src, <12 x i16> *%dst) {
; CHECK-LABEL: vst3_v4i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r7, lr}
; CHECK-NEXT:    push {r4, r5, r7, lr}
; CHECK-NEXT:    vldrh.u32 q1, [r0]
; CHECK-NEXT:    vldrh.u32 q0, [r0, #8]
; CHECK-NEXT:    vldrh.u32 q2, [r0, #16]
; CHECK-NEXT:    vmov r0, r5, d2
; CHECK-NEXT:    vmov.f32 s5, s7
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    vmov lr, r4, d1
; CHECK-NEXT:    vmov.16 q0[0], r0
; CHECK-NEXT:    vmov.f32 s4, s10
; CHECK-NEXT:    vmov.16 q0[1], r2
; CHECK-NEXT:    vmov.f32 s7, s11
; CHECK-NEXT:    vmov r12, s6
; CHECK-NEXT:    vmov.32 q1[2], r4
; CHECK-NEXT:    vmov r0, r4, d4
; CHECK-NEXT:    vstrh.32 q1, [r1, #16]
; CHECK-NEXT:    vmov.16 q0[2], r0
; CHECK-NEXT:    vmov.16 q0[3], r5
; CHECK-NEXT:    vmov.16 q0[4], r3
; CHECK-NEXT:    vmov.16 q0[5], r4
; CHECK-NEXT:    vmov.16 q0[6], r12
; CHECK-NEXT:    vmov.16 q0[7], lr
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    pop {r4, r5, r7, pc}
entry:
  %s1 = getelementptr <4 x i16>, <4 x i16>* %src, i32 0
  %l1 = load <4 x i16>, <4 x i16>* %s1, align 4
  %s2 = getelementptr <4 x i16>, <4 x i16>* %src, i32 1
  %l2 = load <4 x i16>, <4 x i16>* %s2, align 4
  %s3 = getelementptr <4 x i16>, <4 x i16>* %src, i32 2
  %l3 = load <4 x i16>, <4 x i16>* %s3, align 4
  %t1 = shufflevector <4 x i16> %l1, <4 x i16> %l2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %t2 = shufflevector <4 x i16> %l3, <4 x i16> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <8 x i16> %t1, <8 x i16> %t2, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  store <12 x i16> %s, <12 x i16> *%dst
  ret void
}

define void @vst3_v8i16(<8 x i16> *%src, <24 x i16> *%dst) {
; CHECK-LABEL: vst3_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-NEXT:    vldrw.u32 q1, [r0]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #16]
; CHECK-NEXT:    vmov.f32 s12, s7
; CHECK-NEXT:    vmov.u16 r2, q2[5]
; CHECK-NEXT:    vmov.16 q0[0], r2
; CHECK-NEXT:    vins.f16 s12, s11
; CHECK-NEXT:    vmov.f32 s1, s12
; CHECK-NEXT:    vmov.u16 r2, q2[7]
; CHECK-NEXT:    vldrw.u32 q3, [r0, #32]
; CHECK-NEXT:    vmov.16 q0[6], r2
; CHECK-NEXT:    vmov.f32 s2, s7
; CHECK-NEXT:    vmov.u16 r0, q2[3]
; CHECK-NEXT:    vmovx.f16 s7, s14
; CHECK-NEXT:    vmov.16 q4[2], r0
; CHECK-NEXT:    vins.f16 s0, s7
; CHECK-NEXT:    vmovx.f16 s7, s15
; CHECK-NEXT:    vins.f16 s3, s7
; CHECK-NEXT:    vmov.f32 s7, s6
; CHECK-NEXT:    vmovx.f16 s2, s2
; CHECK-NEXT:    vins.f16 s7, s10
; CHECK-NEXT:    vmov.f32 s20, s4
; CHECK-NEXT:    vins.f16 s15, s2
; CHECK-NEXT:    vmov.f32 s18, s7
; CHECK-NEXT:    vins.f16 s20, s8
; CHECK-NEXT:    vmov.f32 s7, s6
; CHECK-NEXT:    vmovx.f16 s6, s5
; CHECK-NEXT:    vmov.f32 s2, s15
; CHECK-NEXT:    vmovx.f16 s15, s13
; CHECK-NEXT:    vins.f16 s13, s6
; CHECK-NEXT:    vmovx.f16 s6, s7
; CHECK-NEXT:    vmov.u16 r0, q2[1]
; CHECK-NEXT:    vmovx.f16 s4, s4
; CHECK-NEXT:    vins.f16 s14, s6
; CHECK-NEXT:    vmovx.f16 s6, s12
; CHECK-NEXT:    vmov.16 q5[4], r0
; CHECK-NEXT:    vins.f16 s5, s9
; CHECK-NEXT:    vins.f16 s12, s4
; CHECK-NEXT:    vins.f16 s17, s15
; CHECK-NEXT:    vmov.f32 s16, s13
; CHECK-NEXT:    vins.f16 s22, s6
; CHECK-NEXT:    vmov.f32 s19, s14
; CHECK-NEXT:    vstrw.32 q0, [r1, #32]
; CHECK-NEXT:    vmov.f32 s23, s5
; CHECK-NEXT:    vstrw.32 q4, [r1, #16]
; CHECK-NEXT:    vmov.f32 s21, s12
; CHECK-NEXT:    vstrw.32 q5, [r1]
; CHECK-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <8 x i16>, <8 x i16>* %src, i32 0
  %l1 = load <8 x i16>, <8 x i16>* %s1, align 4
  %s2 = getelementptr <8 x i16>, <8 x i16>* %src, i32 1
  %l2 = load <8 x i16>, <8 x i16>* %s2, align 4
  %s3 = getelementptr <8 x i16>, <8 x i16>* %src, i32 2
  %l3 = load <8 x i16>, <8 x i16>* %s3, align 4
  %t1 = shufflevector <8 x i16> %l1, <8 x i16> %l2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %t2 = shufflevector <8 x i16> %l3, <8 x i16> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <16 x i16> %t1, <16 x i16> %t2, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
  store <24 x i16> %s, <24 x i16> *%dst
  ret void
}

define void @vst3_v16i16(<16 x i16> *%src, <48 x i16> *%dst) {
; CHECK-LABEL: vst3_v16i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    .pad #48
; CHECK-NEXT:    sub sp, #48
; CHECK-NEXT:    vldrw.u32 q2, [r0]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q7, [r0, #80]
; CHECK-NEXT:    vmov.f32 s0, s11
; CHECK-NEXT:    vmov.u16 r2, q1[5]
; CHECK-NEXT:    vmov.16 q3[0], r2
; CHECK-NEXT:    vins.f16 s0, s7
; CHECK-NEXT:    vmov.f32 s2, s11
; CHECK-NEXT:    vmov.u16 r2, q1[7]
; CHECK-NEXT:    vmov.f64 d12, d4
; CHECK-NEXT:    vstrw.32 q1, [sp, #32] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q1, [r0, #16]
; CHECK-NEXT:    vmov.f32 s26, s10
; CHECK-NEXT:    vldrw.u32 q2, [r0, #64]
; CHECK-NEXT:    vmov.f32 s13, s0
; CHECK-NEXT:    vstrw.32 q6, [sp] @ 16-byte Spill
; CHECK-NEXT:    vmov.16 q3[6], r2
; CHECK-NEXT:    vmovx.f16 s0, s10
; CHECK-NEXT:    vins.f16 s12, s0
; CHECK-NEXT:    vmovx.f16 s0, s2
; CHECK-NEXT:    vmov.f32 s14, s11
; CHECK-NEXT:    vins.f16 s14, s0
; CHECK-NEXT:    vmov.f32 s20, s7
; CHECK-NEXT:    vmov q0, q3
; CHECK-NEXT:    vldrw.u32 q3, [r0, #48]
; CHECK-NEXT:    vmov.u16 r2, q3[5]
; CHECK-NEXT:    vins.f16 s20, s15
; CHECK-NEXT:    vmov.16 q4[0], r2
; CHECK-NEXT:    vmov.u16 r2, q3[7]
; CHECK-NEXT:    vmov.f32 s17, s20
; CHECK-NEXT:    vmovx.f16 s20, s31
; CHECK-NEXT:    vmov.16 q4[6], r2
; CHECK-NEXT:    vmov.f32 s18, s7
; CHECK-NEXT:    vmovx.f16 s7, s30
; CHECK-NEXT:    vins.f16 s16, s7
; CHECK-NEXT:    vmovx.f16 s7, s18
; CHECK-NEXT:    vins.f16 s31, s7
; CHECK-NEXT:    vmovx.f16 s7, s11
; CHECK-NEXT:    vins.f16 s3, s7
; CHECK-NEXT:    vins.f16 s19, s20
; CHECK-NEXT:    vstrw.32 q0, [sp, #16] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q0, [sp, #32] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s20, s24
; CHECK-NEXT:    vmovx.f16 s11, s8
; CHECK-NEXT:    vmov.f32 s7, s25
; CHECK-NEXT:    vins.f16 s20, s0
; CHECK-NEXT:    vmov.u16 r0, q0[1]
; CHECK-NEXT:    vins.f16 s7, s1
; CHECK-NEXT:    vmov.16 q5[4], r0
; CHECK-NEXT:    vmov.u16 r0, q3[1]
; CHECK-NEXT:    vmov.f32 s23, s7
; CHECK-NEXT:    vmovx.f16 s7, s24
; CHECK-NEXT:    vmov.f32 s24, s4
; CHECK-NEXT:    vins.f16 s8, s7
; CHECK-NEXT:    vins.f16 s24, s12
; CHECK-NEXT:    vmov.f32 s21, s8
; CHECK-NEXT:    vmov.f32 s8, s5
; CHECK-NEXT:    vmov.16 q6[4], r0
; CHECK-NEXT:    vins.f16 s8, s13
; CHECK-NEXT:    vmovx.f16 s4, s4
; CHECK-NEXT:    vmov.f32 s27, s8
; CHECK-NEXT:    vmovx.f16 s8, s28
; CHECK-NEXT:    vins.f16 s28, s4
; CHECK-NEXT:    vmov.f32 s4, s6
; CHECK-NEXT:    vmov.u16 r0, q3[3]
; CHECK-NEXT:    vins.f16 s4, s14
; CHECK-NEXT:    vmov.16 q0[2], r0
; CHECK-NEXT:    vmov.f32 s18, s31
; CHECK-NEXT:    vmov.f32 s2, s4
; CHECK-NEXT:    vmovx.f16 s4, s29
; CHECK-NEXT:    vmovx.f16 s0, s5
; CHECK-NEXT:    vins.f16 s1, s4
; CHECK-NEXT:    vmovx.f16 s4, s6
; CHECK-NEXT:    vins.f16 s29, s0
; CHECK-NEXT:    vins.f16 s30, s4
; CHECK-NEXT:    vldrw.u32 q1, [sp, #32] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s25, s28
; CHECK-NEXT:    vins.f16 s26, s8
; CHECK-NEXT:    vmov.f32 s0, s29
; CHECK-NEXT:    vmov.u16 r0, q1[3]
; CHECK-NEXT:    vmov.f32 s3, s30
; CHECK-NEXT:    vldrw.u32 q7, [sp] @ 16-byte Reload
; CHECK-NEXT:    vins.f16 s22, s11
; CHECK-NEXT:    vstrw.32 q6, [r1, #48]
; CHECK-NEXT:    vmov.f32 s8, s30
; CHECK-NEXT:    vstrw.32 q0, [r1, #64]
; CHECK-NEXT:    vins.f16 s8, s6
; CHECK-NEXT:    vmov.16 q1[2], r0
; CHECK-NEXT:    vmov.f32 s6, s8
; CHECK-NEXT:    vmovx.f16 s8, s9
; CHECK-NEXT:    vmovx.f16 s4, s29
; CHECK-NEXT:    vins.f16 s5, s8
; CHECK-NEXT:    vmovx.f16 s8, s30
; CHECK-NEXT:    vins.f16 s9, s4
; CHECK-NEXT:    vins.f16 s10, s8
; CHECK-NEXT:    vmov.f32 s4, s9
; CHECK-NEXT:    vmov.f32 s7, s10
; CHECK-NEXT:    vstrw.32 q4, [r1, #80]
; CHECK-NEXT:    vstrw.32 q1, [r1, #16]
; CHECK-NEXT:    vldrw.u32 q1, [sp, #16] @ 16-byte Reload
; CHECK-NEXT:    vstrw.32 q5, [r1]
; CHECK-NEXT:    vstrw.32 q1, [r1, #32]
; CHECK-NEXT:    add sp, #48
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <16 x i16>, <16 x i16>* %src, i32 0
  %l1 = load <16 x i16>, <16 x i16>* %s1, align 4
  %s2 = getelementptr <16 x i16>, <16 x i16>* %src, i32 1
  %l2 = load <16 x i16>, <16 x i16>* %s2, align 4
  %s3 = getelementptr <16 x i16>, <16 x i16>* %src, i32 2
  %l3 = load <16 x i16>, <16 x i16>* %s3, align 4
  %t1 = shufflevector <16 x i16> %l1, <16 x i16> %l2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %t2 = shufflevector <16 x i16> %l3, <16 x i16> undef, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <32 x i16> %t1, <32 x i16> %t2, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
  store <48 x i16> %s, <48 x i16> *%dst
  ret void
}

; i8

define void @vst3_v2i8(<2 x i8> *%src, <6 x i8> *%dst) {
; CHECK-LABEL: vst3_v2i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r7, lr}
; CHECK-NEXT:    push {r4, r5, r7, lr}
; CHECK-NEXT:    .pad #16
; CHECK-NEXT:    sub sp, #16
; CHECK-NEXT:    ldrb r2, [r0]
; CHECK-NEXT:    mov r4, sp
; CHECK-NEXT:    ldrb r3, [r0, #1]
; CHECK-NEXT:    ldrb.w r12, [r0, #2]
; CHECK-NEXT:    vmov q0[2], q0[0], r2, r3
; CHECK-NEXT:    ldrb.w lr, [r0, #3]
; CHECK-NEXT:    vmov r2, s0
; CHECK-NEXT:    ldrb r5, [r0, #5]
; CHECK-NEXT:    vmov.16 q0[0], r2
; CHECK-NEXT:    ldrb r0, [r0, #4]
; CHECK-NEXT:    vmov.16 q0[1], r12
; CHECK-NEXT:    vmov.16 q0[2], r0
; CHECK-NEXT:    add r0, sp, #8
; CHECK-NEXT:    vmov.16 q0[3], r3
; CHECK-NEXT:    vmov.16 q0[4], lr
; CHECK-NEXT:    vmov.16 q0[5], r5
; CHECK-NEXT:    vstrb.16 q0, [r4]
; CHECK-NEXT:    vstrb.16 q0, [r0]
; CHECK-NEXT:    vldrh.u32 q0, [r0]
; CHECK-NEXT:    ldr r2, [sp]
; CHECK-NEXT:    str r2, [r1]
; CHECK-NEXT:    vmov r0, s2
; CHECK-NEXT:    strh r0, [r1, #4]
; CHECK-NEXT:    add sp, #16
; CHECK-NEXT:    pop {r4, r5, r7, pc}
entry:
  %s1 = getelementptr <2 x i8>, <2 x i8>* %src, i32 0
  %l1 = load <2 x i8>, <2 x i8>* %s1, align 4
  %s2 = getelementptr <2 x i8>, <2 x i8>* %src, i32 1
  %l2 = load <2 x i8>, <2 x i8>* %s2, align 4
  %s3 = getelementptr <2 x i8>, <2 x i8>* %src, i32 2
  %l3 = load <2 x i8>, <2 x i8>* %s3, align 4
  %t1 = shufflevector <2 x i8> %l1, <2 x i8> %l2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %t2 = shufflevector <2 x i8> %l3, <2 x i8> undef, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %s = shufflevector <4 x i8> %t1, <4 x i8> %t2, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
  store <6 x i8> %s, <6 x i8> *%dst
  ret void
}

define void @vst3_v4i8(<4 x i8> *%src, <12 x i8> *%dst) {
; CHECK-LABEL: vst3_v4i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r6, lr}
; CHECK-NEXT:    push {r4, r5, r6, lr}
; CHECK-NEXT:    vldrb.u32 q0, [r0, #4]
; CHECK-NEXT:    vldrb.u32 q1, [r0]
; CHECK-NEXT:    vmov r2, lr, d0
; CHECK-NEXT:    vmov r12, r3, d1
; CHECK-NEXT:    vldrb.u32 q0, [r0, #8]
; CHECK-NEXT:    vmov r0, r6, d3
; CHECK-NEXT:    vmov r4, r5, d1
; CHECK-NEXT:    vmov.8 q2[8], r4
; CHECK-NEXT:    vmov.8 q2[9], r6
; CHECK-NEXT:    vmov.8 q2[10], r3
; CHECK-NEXT:    vmov.8 q2[11], r5
; CHECK-NEXT:    vmov r3, s10
; CHECK-NEXT:    str r3, [r1, #8]
; CHECK-NEXT:    vmov r3, r4, d2
; CHECK-NEXT:    vmov.16 q1[0], r3
; CHECK-NEXT:    vmov r3, r5, d0
; CHECK-NEXT:    vmov.16 q1[1], r2
; CHECK-NEXT:    vmov.16 q1[2], r3
; CHECK-NEXT:    vmov.16 q1[3], r4
; CHECK-NEXT:    vmov.16 q1[4], lr
; CHECK-NEXT:    vmov.16 q1[5], r5
; CHECK-NEXT:    vmov.16 q1[6], r0
; CHECK-NEXT:    vmov.16 q1[7], r12
; CHECK-NEXT:    vstrb.16 q1, [r1]
; CHECK-NEXT:    pop {r4, r5, r6, pc}
entry:
  %s1 = getelementptr <4 x i8>, <4 x i8>* %src, i32 0
  %l1 = load <4 x i8>, <4 x i8>* %s1, align 4
  %s2 = getelementptr <4 x i8>, <4 x i8>* %src, i32 1
  %l2 = load <4 x i8>, <4 x i8>* %s2, align 4
  %s3 = getelementptr <4 x i8>, <4 x i8>* %src, i32 2
  %l3 = load <4 x i8>, <4 x i8>* %s3, align 4
  %t1 = shufflevector <4 x i8> %l1, <4 x i8> %l2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %t2 = shufflevector <4 x i8> %l3, <4 x i8> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <8 x i8> %t1, <8 x i8> %t2, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  store <12 x i8> %s, <12 x i8> *%dst
  ret void
}

define void @vst3_v8i8(<8 x i8> *%src, <24 x i8> *%dst) {
; CHECK-LABEL: vst3_v8i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    vldrb.u16 q2, [r0, #8]
; CHECK-NEXT:    vldrb.u16 q1, [r0, #16]
; CHECK-NEXT:    vldrb.u16 q3, [r0]
; CHECK-NEXT:    vmovx.f16 s2, s6
; CHECK-NEXT:    vmovx.f16 s0, s10
; CHECK-NEXT:    vins.f16 s0, s2
; CHECK-NEXT:    vins.f16 s1, s11
; CHECK-NEXT:    vmovx.f16 s2, s7
; CHECK-NEXT:    vmovx.f16 s3, s11
; CHECK-NEXT:    vins.f16 s3, s2
; CHECK-NEXT:    vmovx.f16 s16, s1
; CHECK-NEXT:    vmov.f32 s1, s15
; CHECK-NEXT:    vmovx.f16 s18, s15
; CHECK-NEXT:    vmov.f32 s2, s7
; CHECK-NEXT:    vmov.u16 r0, q3[0]
; CHECK-NEXT:    vins.f16 s1, s16
; CHECK-NEXT:    vins.f16 s2, s18
; CHECK-NEXT:    vmov.8 q4[0], r0
; CHECK-NEXT:    vmov.u16 r0, q2[0]
; CHECK-NEXT:    vmov.8 q4[1], r0
; CHECK-NEXT:    vmov.u16 r0, q1[0]
; CHECK-NEXT:    vmov.8 q4[2], r0
; CHECK-NEXT:    vmov.u16 r0, q3[1]
; CHECK-NEXT:    vmov.8 q4[3], r0
; CHECK-NEXT:    vmov.u16 r0, q2[1]
; CHECK-NEXT:    vmov.8 q4[4], r0
; CHECK-NEXT:    vmov.u16 r0, q1[1]
; CHECK-NEXT:    vmov.8 q4[5], r0
; CHECK-NEXT:    vmov.u16 r0, q3[2]
; CHECK-NEXT:    vmov.8 q4[6], r0
; CHECK-NEXT:    vmov.u16 r0, q2[2]
; CHECK-NEXT:    vmov.8 q4[7], r0
; CHECK-NEXT:    vmov.u16 r0, q1[2]
; CHECK-NEXT:    vmov.8 q4[8], r0
; CHECK-NEXT:    vmov.u16 r0, q3[3]
; CHECK-NEXT:    vmov.8 q4[9], r0
; CHECK-NEXT:    vmov.u16 r0, q2[3]
; CHECK-NEXT:    vmov.8 q4[10], r0
; CHECK-NEXT:    vmov.u16 r0, q1[3]
; CHECK-NEXT:    vmov.8 q4[11], r0
; CHECK-NEXT:    vmov.u16 r0, q3[4]
; CHECK-NEXT:    vmov.8 q4[12], r0
; CHECK-NEXT:    vmov.u16 r0, q2[4]
; CHECK-NEXT:    vmov.8 q4[13], r0
; CHECK-NEXT:    vmov.u16 r0, q1[4]
; CHECK-NEXT:    vmov.8 q4[14], r0
; CHECK-NEXT:    vmov.u16 r0, q3[5]
; CHECK-NEXT:    vmov.8 q4[15], r0
; CHECK-NEXT:    vstrb.16 q0, [r1, #16]
; CHECK-NEXT:    vstrw.32 q4, [r1]
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <8 x i8>, <8 x i8>* %src, i32 0
  %l1 = load <8 x i8>, <8 x i8>* %s1, align 4
  %s2 = getelementptr <8 x i8>, <8 x i8>* %src, i32 1
  %l2 = load <8 x i8>, <8 x i8>* %s2, align 4
  %s3 = getelementptr <8 x i8>, <8 x i8>* %src, i32 2
  %l3 = load <8 x i8>, <8 x i8>* %s3, align 4
  %t1 = shufflevector <8 x i8> %l1, <8 x i8> %l2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %t2 = shufflevector <8 x i8> %l3, <8 x i8> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <16 x i8> %t1, <16 x i8> %t2, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
  store <24 x i8> %s, <24 x i8> *%dst
  ret void
}

define void @vst3_v16i8(<16 x i8> *%src, <48 x i8> *%dst) {
; CHECK-LABEL: vst3_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vldrw.u32 q2, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q3, [r0]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #32]
; CHECK-NEXT:    vmov.u8 r2, q2[5]
; CHECK-NEXT:    vmov.8 q4[0], r2
; CHECK-NEXT:    vmov.u8 r2, q3[6]
; CHECK-NEXT:    vmov.8 q4[2], r2
; CHECK-NEXT:    vmov.u8 r2, q2[6]
; CHECK-NEXT:    vmov.8 q4[3], r2
; CHECK-NEXT:    vmov.u8 r2, q3[7]
; CHECK-NEXT:    vmov.8 q4[5], r2
; CHECK-NEXT:    vmov.u8 r2, q2[7]
; CHECK-NEXT:    vmov.8 q4[6], r2
; CHECK-NEXT:    vmov.u8 r2, q3[8]
; CHECK-NEXT:    vmov.8 q4[8], r2
; CHECK-NEXT:    vmov.u8 r2, q2[8]
; CHECK-NEXT:    vmov.8 q4[9], r2
; CHECK-NEXT:    vmov.u8 r2, q3[9]
; CHECK-NEXT:    vmov.8 q4[11], r2
; CHECK-NEXT:    vmov.u8 r2, q2[9]
; CHECK-NEXT:    vmov.8 q4[12], r2
; CHECK-NEXT:    vmov.u8 r2, q3[10]
; CHECK-NEXT:    vmov.8 q4[14], r2
; CHECK-NEXT:    vmov.u8 r2, q2[10]
; CHECK-NEXT:    vmov.8 q4[15], r2
; CHECK-NEXT:    vmov.u8 r0, q1[5]
; CHECK-NEXT:    vmov.u8 r2, q4[0]
; CHECK-NEXT:    vmov.8 q0[0], r2
; CHECK-NEXT:    vmov.8 q0[1], r0
; CHECK-NEXT:    vmov.u8 r0, q4[2]
; CHECK-NEXT:    vmov.8 q0[2], r0
; CHECK-NEXT:    vmov.u8 r0, q4[3]
; CHECK-NEXT:    vmov.8 q0[3], r0
; CHECK-NEXT:    vmov.u8 r0, q1[6]
; CHECK-NEXT:    vmov.8 q0[4], r0
; CHECK-NEXT:    vmov.u8 r0, q4[5]
; CHECK-NEXT:    vmov.8 q0[5], r0
; CHECK-NEXT:    vmov.u8 r0, q4[6]
; CHECK-NEXT:    vmov.8 q0[6], r0
; CHECK-NEXT:    vmov.u8 r0, q1[7]
; CHECK-NEXT:    vmov.8 q0[7], r0
; CHECK-NEXT:    vmov.u8 r0, q4[8]
; CHECK-NEXT:    vmov.8 q0[8], r0
; CHECK-NEXT:    vmov.u8 r0, q4[9]
; CHECK-NEXT:    vmov.8 q0[9], r0
; CHECK-NEXT:    vmov.u8 r0, q1[8]
; CHECK-NEXT:    vmov.8 q0[10], r0
; CHECK-NEXT:    vmov.u8 r0, q4[11]
; CHECK-NEXT:    vmov.8 q0[11], r0
; CHECK-NEXT:    vmov.u8 r0, q4[12]
; CHECK-NEXT:    vmov.8 q0[12], r0
; CHECK-NEXT:    vmov.u8 r0, q1[9]
; CHECK-NEXT:    vmov.8 q0[13], r0
; CHECK-NEXT:    vmov.u8 r0, q4[14]
; CHECK-NEXT:    vmov.8 q0[14], r0
; CHECK-NEXT:    vmov.u8 r0, q4[15]
; CHECK-NEXT:    vmov.8 q0[15], r0
; CHECK-NEXT:    vmov.u8 r0, q3[0]
; CHECK-NEXT:    vmov.8 q5[0], r0
; CHECK-NEXT:    vmov.u8 r0, q2[0]
; CHECK-NEXT:    vmov.8 q5[1], r0
; CHECK-NEXT:    vmov.u8 r0, q3[1]
; CHECK-NEXT:    vmov.8 q5[3], r0
; CHECK-NEXT:    vmov.u8 r0, q2[1]
; CHECK-NEXT:    vmov.8 q5[4], r0
; CHECK-NEXT:    vmov.u8 r0, q3[2]
; CHECK-NEXT:    vmov.8 q5[6], r0
; CHECK-NEXT:    vmov.u8 r0, q2[2]
; CHECK-NEXT:    vmov.8 q5[7], r0
; CHECK-NEXT:    vmov.u8 r0, q3[3]
; CHECK-NEXT:    vmov.8 q5[9], r0
; CHECK-NEXT:    vmov.u8 r0, q2[3]
; CHECK-NEXT:    vmov.8 q5[10], r0
; CHECK-NEXT:    vmov.u8 r0, q3[4]
; CHECK-NEXT:    vmov.8 q5[12], r0
; CHECK-NEXT:    vmov.u8 r0, q2[4]
; CHECK-NEXT:    vmov.8 q5[13], r0
; CHECK-NEXT:    vmov.u8 r0, q3[5]
; CHECK-NEXT:    vmov.8 q5[15], r0
; CHECK-NEXT:    vstrw.32 q0, [r1, #16]
; CHECK-NEXT:    vmov.u8 r0, q5[0]
; CHECK-NEXT:    vmov.8 q4[0], r0
; CHECK-NEXT:    vmov.u8 r0, q5[1]
; CHECK-NEXT:    vmov.8 q4[1], r0
; CHECK-NEXT:    vmov.u8 r0, q1[0]
; CHECK-NEXT:    vmov.8 q4[2], r0
; CHECK-NEXT:    vmov.u8 r0, q5[3]
; CHECK-NEXT:    vmov.8 q4[3], r0
; CHECK-NEXT:    vmov.u8 r0, q5[4]
; CHECK-NEXT:    vmov.8 q4[4], r0
; CHECK-NEXT:    vmov.u8 r0, q1[1]
; CHECK-NEXT:    vmov.8 q4[5], r0
; CHECK-NEXT:    vmov.u8 r0, q5[6]
; CHECK-NEXT:    vmov.8 q4[6], r0
; CHECK-NEXT:    vmov.u8 r0, q5[7]
; CHECK-NEXT:    vmov.8 q4[7], r0
; CHECK-NEXT:    vmov.u8 r0, q1[2]
; CHECK-NEXT:    vmov.8 q4[8], r0
; CHECK-NEXT:    vmov.u8 r0, q5[9]
; CHECK-NEXT:    vmov.8 q4[9], r0
; CHECK-NEXT:    vmov.u8 r0, q5[10]
; CHECK-NEXT:    vmov.8 q4[10], r0
; CHECK-NEXT:    vmov.u8 r0, q1[3]
; CHECK-NEXT:    vmov.8 q4[11], r0
; CHECK-NEXT:    vmov.u8 r0, q5[12]
; CHECK-NEXT:    vmov.8 q4[12], r0
; CHECK-NEXT:    vmov.u8 r0, q5[13]
; CHECK-NEXT:    vmov.8 q4[13], r0
; CHECK-NEXT:    vmov.u8 r0, q1[4]
; CHECK-NEXT:    vmov.8 q4[14], r0
; CHECK-NEXT:    vmov.u8 r0, q5[15]
; CHECK-NEXT:    vmov.8 q4[15], r0
; CHECK-NEXT:    vmov.u8 r0, q1[10]
; CHECK-NEXT:    vmov.8 q5[0], r0
; CHECK-NEXT:    vmov.u8 r0, q3[11]
; CHECK-NEXT:    vmov.8 q6[1], r0
; CHECK-NEXT:    vmov.u8 r0, q2[11]
; CHECK-NEXT:    vmov.8 q6[2], r0
; CHECK-NEXT:    vmov.u8 r0, q3[12]
; CHECK-NEXT:    vmov.8 q6[4], r0
; CHECK-NEXT:    vmov.u8 r0, q2[12]
; CHECK-NEXT:    vmov.8 q6[5], r0
; CHECK-NEXT:    vmov.u8 r0, q3[13]
; CHECK-NEXT:    vmov.8 q6[7], r0
; CHECK-NEXT:    vmov.u8 r0, q2[13]
; CHECK-NEXT:    vmov.8 q6[8], r0
; CHECK-NEXT:    vmov.u8 r0, q3[14]
; CHECK-NEXT:    vmov.8 q6[10], r0
; CHECK-NEXT:    vmov.u8 r0, q2[14]
; CHECK-NEXT:    vmov.8 q6[11], r0
; CHECK-NEXT:    vmov.u8 r0, q3[15]
; CHECK-NEXT:    vmov.8 q6[13], r0
; CHECK-NEXT:    vmov.u8 r0, q2[15]
; CHECK-NEXT:    vmov.8 q6[14], r0
; CHECK-NEXT:    vstrw.32 q4, [r1]
; CHECK-NEXT:    vmov.u8 r0, q6[1]
; CHECK-NEXT:    vmov.8 q5[1], r0
; CHECK-NEXT:    vmov.u8 r0, q6[2]
; CHECK-NEXT:    vmov.8 q5[2], r0
; CHECK-NEXT:    vmov.u8 r0, q1[11]
; CHECK-NEXT:    vmov.8 q5[3], r0
; CHECK-NEXT:    vmov.u8 r0, q6[4]
; CHECK-NEXT:    vmov.8 q5[4], r0
; CHECK-NEXT:    vmov.u8 r0, q6[5]
; CHECK-NEXT:    vmov.8 q5[5], r0
; CHECK-NEXT:    vmov.u8 r0, q1[12]
; CHECK-NEXT:    vmov.8 q5[6], r0
; CHECK-NEXT:    vmov.u8 r0, q6[7]
; CHECK-NEXT:    vmov.8 q5[7], r0
; CHECK-NEXT:    vmov.u8 r0, q6[8]
; CHECK-NEXT:    vmov.8 q5[8], r0
; CHECK-NEXT:    vmov.u8 r0, q1[13]
; CHECK-NEXT:    vmov.8 q5[9], r0
; CHECK-NEXT:    vmov.u8 r0, q6[10]
; CHECK-NEXT:    vmov.8 q5[10], r0
; CHECK-NEXT:    vmov.u8 r0, q6[11]
; CHECK-NEXT:    vmov.8 q5[11], r0
; CHECK-NEXT:    vmov.u8 r0, q1[14]
; CHECK-NEXT:    vmov.8 q5[12], r0
; CHECK-NEXT:    vmov.u8 r0, q6[13]
; CHECK-NEXT:    vmov.8 q5[13], r0
; CHECK-NEXT:    vmov.u8 r0, q6[14]
; CHECK-NEXT:    vmov.8 q5[14], r0
; CHECK-NEXT:    vmov.u8 r0, q1[15]
; CHECK-NEXT:    vmov.8 q5[15], r0
; CHECK-NEXT:    vstrw.32 q5, [r1, #32]
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <16 x i8>, <16 x i8>* %src, i32 0
  %l1 = load <16 x i8>, <16 x i8>* %s1, align 4
  %s2 = getelementptr <16 x i8>, <16 x i8>* %src, i32 1
  %l2 = load <16 x i8>, <16 x i8>* %s2, align 4
  %s3 = getelementptr <16 x i8>, <16 x i8>* %src, i32 2
  %l3 = load <16 x i8>, <16 x i8>* %s3, align 4
  %t1 = shufflevector <16 x i8> %l1, <16 x i8> %l2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %t2 = shufflevector <16 x i8> %l3, <16 x i8> undef, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <32 x i8> %t1, <32 x i8> %t2, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
  store <48 x i8> %s, <48 x i8> *%dst
  ret void
}

; i64

define void @vst3_v2i64(<2 x i64> *%src, <6 x i64> *%dst) {
; CHECK-LABEL: vst3_v2i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #16]
; CHECK-NEXT:    vmov.f64 d6, d2
; CHECK-NEXT:    vmov.f64 d7, d1
; CHECK-NEXT:    vmov.f64 d1, d4
; CHECK-NEXT:    vstrw.32 q3, [r1, #16]
; CHECK-NEXT:    vmov.f64 d2, d5
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    vstrw.32 q1, [r1, #32]
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <2 x i64>, <2 x i64>* %src, i32 0
  %l1 = load <2 x i64>, <2 x i64>* %s1, align 4
  %s2 = getelementptr <2 x i64>, <2 x i64>* %src, i32 1
  %l2 = load <2 x i64>, <2 x i64>* %s2, align 4
  %s3 = getelementptr <2 x i64>, <2 x i64>* %src, i32 2
  %l3 = load <2 x i64>, <2 x i64>* %s3, align 4
  %t1 = shufflevector <2 x i64> %l1, <2 x i64> %l2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %t2 = shufflevector <2 x i64> %l3, <2 x i64> undef, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %s = shufflevector <4 x i64> %t1, <4 x i64> %t2, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
  store <6 x i64> %s, <6 x i64> *%dst
  ret void
}

define void @vst3_v4i64(<4 x i64> *%src, <12 x i64> *%dst) {
; CHECK-LABEL: vst3_v4i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vldrw.u32 q7, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q6, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q0, [r0, #80]
; CHECK-NEXT:    vldrw.u32 q1, [r0]
; CHECK-NEXT:    vmov.f64 d6, d15
; CHECK-NEXT:    vldrw.u32 q2, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q4, [r0, #64]
; CHECK-NEXT:    vmov.f64 d15, d13
; CHECK-NEXT:    vmov.f64 d7, d1
; CHECK-NEXT:    vmov.f64 d10, d2
; CHECK-NEXT:    vstrw.32 q3, [r1, #80]
; CHECK-NEXT:    vmov.f64 d11, d12
; CHECK-NEXT:    vmov.f64 d2, d8
; CHECK-NEXT:    vstrw.32 q5, [r1]
; CHECK-NEXT:    vmov.f64 d1, d5
; CHECK-NEXT:    vstrw.32 q1, [r1, #16]
; CHECK-NEXT:    vmov.f64 d8, d15
; CHECK-NEXT:    vstrw.32 q0, [r1, #64]
; CHECK-NEXT:    vmov.f64 d12, d4
; CHECK-NEXT:    vstrw.32 q4, [r1, #32]
; CHECK-NEXT:    vmov.f64 d13, d14
; CHECK-NEXT:    vstrw.32 q6, [r1, #48]
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <4 x i64>, <4 x i64>* %src, i32 0
  %l1 = load <4 x i64>, <4 x i64>* %s1, align 4
  %s2 = getelementptr <4 x i64>, <4 x i64>* %src, i32 1
  %l2 = load <4 x i64>, <4 x i64>* %s2, align 4
  %s3 = getelementptr <4 x i64>, <4 x i64>* %src, i32 2
  %l3 = load <4 x i64>, <4 x i64>* %s3, align 4
  %t1 = shufflevector <4 x i64> %l1, <4 x i64> %l2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %t2 = shufflevector <4 x i64> %l3, <4 x i64> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <8 x i64> %t1, <8 x i64> %t2, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  store <12 x i64> %s, <12 x i64> *%dst
  ret void
}

; f32

define void @vst3_v2f32(<2 x float> *%src, <6 x float> *%dst) {
; CHECK-LABEL: vst3_v2f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    ldr r2, [r0, #20]
; CHECK-NEXT:    vldr s0, [r0]
; CHECK-NEXT:    vldr s3, [r0, #4]
; CHECK-NEXT:    vldr s1, [r0, #8]
; CHECK-NEXT:    vldr s2, [r0, #16]
; CHECK-NEXT:    ldr r0, [r0, #12]
; CHECK-NEXT:    strd r0, r2, [r1, #16]
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <2 x float>, <2 x float>* %src, i32 0
  %l1 = load <2 x float>, <2 x float>* %s1, align 4
  %s2 = getelementptr <2 x float>, <2 x float>* %src, i32 1
  %l2 = load <2 x float>, <2 x float>* %s2, align 4
  %s3 = getelementptr <2 x float>, <2 x float>* %src, i32 2
  %l3 = load <2 x float>, <2 x float>* %s3, align 4
  %t1 = shufflevector <2 x float> %l1, <2 x float> %l2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %t2 = shufflevector <2 x float> %l3, <2 x float> undef, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %s = shufflevector <4 x float> %t1, <4 x float> %t2, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
  store <6 x float> %s, <6 x float> *%dst
  ret void
}

define void @vst3_v4f32(<4 x float> *%src, <12 x float> *%dst) {
; CHECK-LABEL: vst3_v4f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    vldrw.u32 q0, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q2, [r0]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #32]
; CHECK-NEXT:    vmov.f32 s12, s1
; CHECK-NEXT:    vmov.f32 s13, s5
; CHECK-NEXT:    vmov.f32 s18, s4
; CHECK-NEXT:    vmov.f32 s4, s6
; CHECK-NEXT:    vmov.f32 s14, s10
; CHECK-NEXT:    vmov.f32 s15, s2
; CHECK-NEXT:    vmov.f32 s16, s8
; CHECK-NEXT:    vstrw.32 q3, [r1, #16]
; CHECK-NEXT:    vmov.f32 s17, s0
; CHECK-NEXT:    vmov.f32 s19, s9
; CHECK-NEXT:    vmov.f32 s5, s11
; CHECK-NEXT:    vstrw.32 q4, [r1]
; CHECK-NEXT:    vmov.f32 s6, s3
; CHECK-NEXT:    vstrw.32 q1, [r1, #32]
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <4 x float>, <4 x float>* %src, i32 0
  %l1 = load <4 x float>, <4 x float>* %s1, align 4
  %s2 = getelementptr <4 x float>, <4 x float>* %src, i32 1
  %l2 = load <4 x float>, <4 x float>* %s2, align 4
  %s3 = getelementptr <4 x float>, <4 x float>* %src, i32 2
  %l3 = load <4 x float>, <4 x float>* %s3, align 4
  %t1 = shufflevector <4 x float> %l1, <4 x float> %l2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %t2 = shufflevector <4 x float> %l3, <4 x float> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <8 x float> %t1, <8 x float> %t2, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  store <12 x float> %s, <12 x float> *%dst
  ret void
}

define void @vst3_v8f32(<8 x float> *%src, <24 x float> *%dst) {
; CHECK-LABEL: vst3_v8f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    .pad #32
; CHECK-NEXT:    sub sp, #32
; CHECK-NEXT:    vldrw.u32 q0, [r0, #80]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q3, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q1, [r0]
; CHECK-NEXT:    vstrw.32 q0, [sp, #16] @ 16-byte Spill
; CHECK-NEXT:    vmov.f32 s23, s3
; CHECK-NEXT:    vldrw.u32 q6, [sp, #16] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s20, s2
; CHECK-NEXT:    vmov.f32 s21, s15
; CHECK-NEXT:    vldrw.u32 q4, [r0, #32]
; CHECK-NEXT:    vmov.f32 s22, s11
; CHECK-NEXT:    vldrw.u32 q7, [r0, #64]
; CHECK-NEXT:    vstrw.32 q5, [sp] @ 16-byte Spill
; CHECK-NEXT:    vmov.f32 s0, s12
; CHECK-NEXT:    vmov.f32 s1, s8
; CHECK-NEXT:    vmov.f32 s3, s13
; CHECK-NEXT:    vmov.f32 s2, s24
; CHECK-NEXT:    vstrw.32 q0, [r1, #48]
; CHECK-NEXT:    vldrw.u32 q0, [sp] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s20, s4
; CHECK-NEXT:    vmov.f32 s23, s5
; CHECK-NEXT:    vstrw.32 q0, [r1, #80]
; CHECK-NEXT:    vmov.f32 s12, s9
; CHECK-NEXT:    vmov.f32 s15, s10
; CHECK-NEXT:    vmov.f32 s13, s25
; CHECK-NEXT:    vmov.f32 s9, s7
; CHECK-NEXT:    vstrw.32 q3, [r1, #64]
; CHECK-NEXT:    vmov.f32 s21, s16
; CHECK-NEXT:    vmov.f32 s22, s28
; CHECK-NEXT:    vmov.f32 s8, s30
; CHECK-NEXT:    vstrw.32 q5, [r1]
; CHECK-NEXT:    vmov.f32 s10, s19
; CHECK-NEXT:    vmov.f32 s11, s31
; CHECK-NEXT:    vmov.f32 s5, s29
; CHECK-NEXT:    vstrw.32 q2, [r1, #32]
; CHECK-NEXT:    vmov.f32 s4, s17
; CHECK-NEXT:    vmov.f32 s7, s18
; CHECK-NEXT:    vstrw.32 q1, [r1, #16]
; CHECK-NEXT:    add sp, #32
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <8 x float>, <8 x float>* %src, i32 0
  %l1 = load <8 x float>, <8 x float>* %s1, align 4
  %s2 = getelementptr <8 x float>, <8 x float>* %src, i32 1
  %l2 = load <8 x float>, <8 x float>* %s2, align 4
  %s3 = getelementptr <8 x float>, <8 x float>* %src, i32 2
  %l3 = load <8 x float>, <8 x float>* %s3, align 4
  %t1 = shufflevector <8 x float> %l1, <8 x float> %l2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %t2 = shufflevector <8 x float> %l3, <8 x float> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <16 x float> %t1, <16 x float> %t2, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
  store <24 x float> %s, <24 x float> *%dst
  ret void
}

define void @vst3_v16f32(<16 x float> *%src, <48 x float> *%dst) {
; CHECK-LABEL: vst3_v16f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    .pad #128
; CHECK-NEXT:    sub sp, #128
; CHECK-NEXT:    vldrw.u32 q3, [r0, #176]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #64]
; CHECK-NEXT:    vldrw.u32 q1, [r0]
; CHECK-NEXT:    vldrw.u32 q0, [r0, #128]
; CHECK-NEXT:    vstrw.32 q3, [sp, #112] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q3, [r0, #160]
; CHECK-NEXT:    vmov.f32 s24, s9
; CHECK-NEXT:    vldrw.u32 q5, [r0, #144]
; CHECK-NEXT:    vstrw.32 q3, [sp, #96] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q3, [r0, #96]
; CHECK-NEXT:    vmov.f32 s26, s6
; CHECK-NEXT:    vldrw.u32 q7, [r0, #112]
; CHECK-NEXT:    vstrw.32 q3, [sp, #32] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q3, [r0, #80]
; CHECK-NEXT:    vmov.f32 s27, s10
; CHECK-NEXT:    vldrw.u32 q4, [r0, #48]
; CHECK-NEXT:    vstrw.32 q3, [sp, #48] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q3, [r0, #32]
; CHECK-NEXT:    vmov.f32 s25, s1
; CHECK-NEXT:    vstrw.32 q3, [sp, #16] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q3, [r0, #16]
; CHECK-NEXT:    vstrw.32 q6, [r1, #16]
; CHECK-NEXT:    vmov.f32 s24, s2
; CHECK-NEXT:    vstrw.32 q3, [sp, #80] @ 16-byte Spill
; CHECK-NEXT:    vmov.f32 s27, s3
; CHECK-NEXT:    vmov.f32 s14, s0
; CHECK-NEXT:    vldrw.u32 q0, [sp, #112] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s12, s4
; CHECK-NEXT:    vmov.f32 s15, s5
; CHECK-NEXT:    vmov.f32 s13, s8
; CHECK-NEXT:    vstrw.32 q3, [sp, #64] @ 16-byte Spill
; CHECK-NEXT:    vmov.f32 s25, s7
; CHECK-NEXT:    vmov.f32 s6, s0
; CHECK-NEXT:    vmov.f32 s13, s1
; CHECK-NEXT:    vmov.f32 s0, s2
; CHECK-NEXT:    vmov.f32 s4, s16
; CHECK-NEXT:    vmov.f32 s5, s28
; CHECK-NEXT:    vmov.f32 s7, s17
; CHECK-NEXT:    vmov.f32 s1, s19
; CHECK-NEXT:    vstrw.32 q1, [sp] @ 16-byte Spill
; CHECK-NEXT:    vmov.f32 s2, s31
; CHECK-NEXT:    vldrw.u32 q1, [sp, #32] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s26, s11
; CHECK-NEXT:    vldrw.u32 q2, [sp, #16] @ 16-byte Reload
; CHECK-NEXT:    vstrw.32 q0, [sp, #112] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q0, [sp, #96] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s15, s30
; CHECK-NEXT:    vstrw.32 q6, [r1, #32]
; CHECK-NEXT:    vmov.f32 s17, s1
; CHECK-NEXT:    vldrw.u32 q6, [sp, #80] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s30, s0
; CHECK-NEXT:    vmov.f32 s0, s2
; CHECK-NEXT:    vmov.f32 s1, s11
; CHECK-NEXT:    vmov.f32 s2, s7
; CHECK-NEXT:    vmov.f32 s14, s18
; CHECK-NEXT:    vstrw.32 q0, [sp, #96] @ 16-byte Spill
; CHECK-NEXT:    vmov.f32 s18, s10
; CHECK-NEXT:    vldrw.u32 q0, [sp, #48] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s28, s8
; CHECK-NEXT:    vmov.f32 s31, s9
; CHECK-NEXT:    vldrw.u32 q2, [sp, #80] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s12, s29
; CHECK-NEXT:    vmov.f32 s29, s4
; CHECK-NEXT:    vstrw.32 q3, [r1, #160]
; CHECK-NEXT:    vmov.f32 s16, s5
; CHECK-NEXT:    vstrw.32 q7, [r1, #96]
; CHECK-NEXT:    vmov.f32 s19, s6
; CHECK-NEXT:    vmov.f32 s4, s8
; CHECK-NEXT:    vstrw.32 q4, [r1, #112]
; CHECK-NEXT:    vmov.f32 s6, s20
; CHECK-NEXT:    vmov.f32 s20, s22
; CHECK-NEXT:    vmov.f32 s5, s0
; CHECK-NEXT:    vmov.f32 s8, s1
; CHECK-NEXT:    vmov.f32 s11, s2
; CHECK-NEXT:    vmov.f32 s22, s3
; CHECK-NEXT:    vldrw.u32 q0, [sp, #96] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s7, s9
; CHECK-NEXT:    vstrw.32 q0, [r1, #128]
; CHECK-NEXT:    vldrw.u32 q0, [sp] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s9, s21
; CHECK-NEXT:    vstrw.32 q1, [r1, #48]
; CHECK-NEXT:    vstrw.32 q0, [r1, #144]
; CHECK-NEXT:    vldrw.u32 q0, [sp, #112] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s21, s27
; CHECK-NEXT:    vstrw.32 q2, [r1, #64]
; CHECK-NEXT:    vstrw.32 q0, [r1, #176]
; CHECK-NEXT:    vldrw.u32 q0, [sp, #64] @ 16-byte Reload
; CHECK-NEXT:    vstrw.32 q5, [r1, #80]
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    add sp, #128
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <16 x float>, <16 x float>* %src, i32 0
  %l1 = load <16 x float>, <16 x float>* %s1, align 4
  %s2 = getelementptr <16 x float>, <16 x float>* %src, i32 1
  %l2 = load <16 x float>, <16 x float>* %s2, align 4
  %s3 = getelementptr <16 x float>, <16 x float>* %src, i32 2
  %l3 = load <16 x float>, <16 x float>* %s3, align 4
  %t1 = shufflevector <16 x float> %l1, <16 x float> %l2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %t2 = shufflevector <16 x float> %l3, <16 x float> undef, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <32 x float> %t1, <32 x float> %t2, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
  store <48 x float> %s, <48 x float> *%dst
  ret void
}

; f16

define void @vst3_v2f16(<2 x half> *%src, <6 x half> *%dst) {
; CHECK-LABEL: vst3_v2f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    ldrd r2, r3, [r0]
; CHECK-NEXT:    ldr r0, [r0, #8]
; CHECK-NEXT:    vmov.32 q0[0], r2
; CHECK-NEXT:    vmov.32 q0[1], r3
; CHECK-NEXT:    vmov.32 q1[0], r0
; CHECK-NEXT:    vmovx.f16 s2, s0
; CHECK-NEXT:    vmovx.f16 s6, s4
; CHECK-NEXT:    vins.f16 s4, s2
; CHECK-NEXT:    vmovx.f16 s2, s1
; CHECK-NEXT:    vins.f16 s0, s1
; CHECK-NEXT:    vmov.f32 s1, s4
; CHECK-NEXT:    vins.f16 s2, s6
; CHECK-NEXT:    vmov r3, s2
; CHECK-NEXT:    vmov r0, r2, d0
; CHECK-NEXT:    stm r1!, {r0, r2, r3}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <2 x half>, <2 x half>* %src, i32 0
  %l1 = load <2 x half>, <2 x half>* %s1, align 4
  %s2 = getelementptr <2 x half>, <2 x half>* %src, i32 1
  %l2 = load <2 x half>, <2 x half>* %s2, align 4
  %s3 = getelementptr <2 x half>, <2 x half>* %src, i32 2
  %l3 = load <2 x half>, <2 x half>* %s3, align 4
  %t1 = shufflevector <2 x half> %l1, <2 x half> %l2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %t2 = shufflevector <2 x half> %l3, <2 x half> undef, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %s = shufflevector <4 x half> %t1, <4 x half> %t2, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
  store <6 x half> %s, <6 x half> *%dst
  ret void
}

define void @vst3_v4f16(<4 x half> *%src, <12 x half> *%dst) {
; CHECK-LABEL: vst3_v4f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, lr}
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    ldrd lr, r12, [r0]
; CHECK-NEXT:    ldrd r3, r2, [r0, #8]
; CHECK-NEXT:    ldrd r4, r0, [r0, #16]
; CHECK-NEXT:    vmov q0[2], q0[0], lr, r3
; CHECK-NEXT:    vmov.32 q1[0], r4
; CHECK-NEXT:    vmov q0[3], q0[1], r12, r2
; CHECK-NEXT:    vmov.32 q1[1], r0
; CHECK-NEXT:    vmovx.f16 s9, s3
; CHECK-NEXT:    vmovx.f16 s6, s0
; CHECK-NEXT:    vins.f16 s0, s2
; CHECK-NEXT:    vmovx.f16 s8, s4
; CHECK-NEXT:    vmovx.f16 s2, s2
; CHECK-NEXT:    vins.f16 s4, s6
; CHECK-NEXT:    vmovx.f16 s6, s1
; CHECK-NEXT:    vins.f16 s2, s8
; CHECK-NEXT:    vmovx.f16 s8, s5
; CHECK-NEXT:    vins.f16 s5, s6
; CHECK-NEXT:    vins.f16 s9, s8
; CHECK-NEXT:    vmov.f32 s8, s5
; CHECK-NEXT:    vins.f16 s1, s3
; CHECK-NEXT:    vmov r0, r2, d4
; CHECK-NEXT:    vmov q2, q0
; CHECK-NEXT:    vmov.f32 s9, s4
; CHECK-NEXT:    vmov.f32 s10, s2
; CHECK-NEXT:    vmov.f32 s11, s1
; CHECK-NEXT:    vstrw.32 q2, [r1]
; CHECK-NEXT:    strd r0, r2, [r1, #16]
; CHECK-NEXT:    pop {r4, pc}
entry:
  %s1 = getelementptr <4 x half>, <4 x half>* %src, i32 0
  %l1 = load <4 x half>, <4 x half>* %s1, align 4
  %s2 = getelementptr <4 x half>, <4 x half>* %src, i32 1
  %l2 = load <4 x half>, <4 x half>* %s2, align 4
  %s3 = getelementptr <4 x half>, <4 x half>* %src, i32 2
  %l3 = load <4 x half>, <4 x half>* %s3, align 4
  %t1 = shufflevector <4 x half> %l1, <4 x half> %l2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %t2 = shufflevector <4 x half> %l3, <4 x half> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <8 x half> %t1, <8 x half> %t2, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  store <12 x half> %s, <12 x half> *%dst
  ret void
}

define void @vst3_v8f16(<8 x half> *%src, <24 x half> *%dst) {
; CHECK-LABEL: vst3_v8f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    vldrw.u32 q4, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q3, [r0]
; CHECK-NEXT:    vmovx.f16 s0, s18
; CHECK-NEXT:    vmov.f32 s4, s15
; CHECK-NEXT:    vmov r2, s0
; CHECK-NEXT:    vins.f16 s4, s19
; CHECK-NEXT:    vmov.16 q0[0], r2
; CHECK-NEXT:    vmovx.f16 s10, s16
; CHECK-NEXT:    vmov.f32 s1, s4
; CHECK-NEXT:    vmovx.f16 s4, s19
; CHECK-NEXT:    vmov r2, s4
; CHECK-NEXT:    vldrw.u32 q1, [r0, #32]
; CHECK-NEXT:    vmov.16 q0[6], r2
; CHECK-NEXT:    vmov r0, s10
; CHECK-NEXT:    vmovx.f16 s8, s6
; CHECK-NEXT:    vmovx.f16 s2, s15
; CHECK-NEXT:    vins.f16 s0, s8
; CHECK-NEXT:    vmovx.f16 s8, s7
; CHECK-NEXT:    vins.f16 s3, s8
; CHECK-NEXT:    vmov.f32 s8, s12
; CHECK-NEXT:    vins.f16 s8, s16
; CHECK-NEXT:    vins.f16 s7, s2
; CHECK-NEXT:    vmov.f32 s2, s13
; CHECK-NEXT:    vmov.16 q2[4], r0
; CHECK-NEXT:    vins.f16 s2, s17
; CHECK-NEXT:    vmov.f32 s11, s2
; CHECK-NEXT:    vmovx.f16 s2, s12
; CHECK-NEXT:    vmovx.f16 s12, s4
; CHECK-NEXT:    vins.f16 s4, s2
; CHECK-NEXT:    vins.f16 s10, s12
; CHECK-NEXT:    vmovx.f16 s12, s17
; CHECK-NEXT:    vmov.f32 s2, s14
; CHECK-NEXT:    vmov r0, s12
; CHECK-NEXT:    vins.f16 s2, s18
; CHECK-NEXT:    vmov.16 q4[2], r0
; CHECK-NEXT:    vmovx.f16 s12, s5
; CHECK-NEXT:    vmov.f32 s18, s2
; CHECK-NEXT:    vmovx.f16 s2, s13
; CHECK-NEXT:    vins.f16 s5, s2
; CHECK-NEXT:    vmovx.f16 s2, s14
; CHECK-NEXT:    vins.f16 s6, s2
; CHECK-NEXT:    vmov.f32 s2, s7
; CHECK-NEXT:    vmov.f32 s9, s4
; CHECK-NEXT:    vins.f16 s17, s12
; CHECK-NEXT:    vmov.f32 s16, s5
; CHECK-NEXT:    vstrw.32 q0, [r1, #32]
; CHECK-NEXT:    vmov.f32 s19, s6
; CHECK-NEXT:    vstrw.32 q2, [r1]
; CHECK-NEXT:    vstrw.32 q4, [r1, #16]
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <8 x half>, <8 x half>* %src, i32 0
  %l1 = load <8 x half>, <8 x half>* %s1, align 4
  %s2 = getelementptr <8 x half>, <8 x half>* %src, i32 1
  %l2 = load <8 x half>, <8 x half>* %s2, align 4
  %s3 = getelementptr <8 x half>, <8 x half>* %src, i32 2
  %l3 = load <8 x half>, <8 x half>* %s3, align 4
  %t1 = shufflevector <8 x half> %l1, <8 x half> %l2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %t2 = shufflevector <8 x half> %l3, <8 x half> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <16 x half> %t1, <16 x half> %t2, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
  store <24 x half> %s, <24 x half> *%dst
  ret void
}

define void @vst3_v16f16(<16 x half> *%src, <48 x half> *%dst) {
; CHECK-LABEL: vst3_v16f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    .pad #48
; CHECK-NEXT:    sub sp, #48
; CHECK-NEXT:    vldrw.u32 q3, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q6, [r0, #32]
; CHECK-NEXT:    vmov.f32 s8, s12
; CHECK-NEXT:    vmovx.f16 s2, s4
; CHECK-NEXT:    vmov.f32 s0, s13
; CHECK-NEXT:    vins.f16 s8, s4
; CHECK-NEXT:    vmov r2, s2
; CHECK-NEXT:    vins.f16 s0, s5
; CHECK-NEXT:    vmov.16 q2[4], r2
; CHECK-NEXT:    vmov q4, q3
; CHECK-NEXT:    vmov.f32 s11, s0
; CHECK-NEXT:    vmovx.f16 s0, s16
; CHECK-NEXT:    vmov.f32 s12, s8
; CHECK-NEXT:    vmov.f64 d11, d9
; CHECK-NEXT:    vmov.f32 s21, s17
; CHECK-NEXT:    vmov.f64 d7, d5
; CHECK-NEXT:    vldrw.u32 q2, [r0, #80]
; CHECK-NEXT:    vmovx.f16 s2, s8
; CHECK-NEXT:    vins.f16 s8, s0
; CHECK-NEXT:    vins.f16 s14, s2
; CHECK-NEXT:    vmovx.f16 s2, s24
; CHECK-NEXT:    vstrw.32 q3, [sp, #16] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q3, [r0]
; CHECK-NEXT:    vmov r2, s2
; CHECK-NEXT:    vmov.f32 s16, s12
; CHECK-NEXT:    vins.f16 s16, s24
; CHECK-NEXT:    vmov.f32 s0, s13
; CHECK-NEXT:    vmov.16 q4[4], r2
; CHECK-NEXT:    vins.f16 s0, s25
; CHECK-NEXT:    vmov.f32 s19, s0
; CHECK-NEXT:    vmovx.f16 s0, s12
; CHECK-NEXT:    vmov.f64 d15, d13
; CHECK-NEXT:    vmov.f32 s17, s13
; CHECK-NEXT:    vmov.f32 s24, s16
; CHECK-NEXT:    vmov.f64 d13, d9
; CHECK-NEXT:    vmov.f64 d9, d7
; CHECK-NEXT:    vldrw.u32 q3, [r0, #64]
; CHECK-NEXT:    vmovx.f16 s2, s12
; CHECK-NEXT:    vins.f16 s12, s0
; CHECK-NEXT:    vins.f16 s26, s2
; CHECK-NEXT:    vmovx.f16 s2, s30
; CHECK-NEXT:    vmov.f32 s0, s19
; CHECK-NEXT:    vstrw.32 q6, [sp, #32] @ 16-byte Spill
; CHECK-NEXT:    vmov r0, s2
; CHECK-NEXT:    vins.f16 s0, s31
; CHECK-NEXT:    vmov.f32 s29, s25
; CHECK-NEXT:    vmov.16 q6[0], r0
; CHECK-NEXT:    vmov.f32 s25, s0
; CHECK-NEXT:    vmovx.f16 s0, s31
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmovx.f16 s0, s14
; CHECK-NEXT:    vmov.16 q6[6], r0
; CHECK-NEXT:    vmovx.f16 s2, s15
; CHECK-NEXT:    vins.f16 s24, s0
; CHECK-NEXT:    vmovx.f16 s0, s19
; CHECK-NEXT:    vins.f16 s15, s0
; CHECK-NEXT:    vmovx.f16 s0, s6
; CHECK-NEXT:    vmov.f32 s4, s23
; CHECK-NEXT:    vins.f16 s27, s2
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vins.f16 s4, s7
; CHECK-NEXT:    vmov.16 q0[0], r0
; CHECK-NEXT:    vstrw.32 q7, [sp] @ 16-byte Spill
; CHECK-NEXT:    vmov.f32 s1, s4
; CHECK-NEXT:    vmovx.f16 s4, s7
; CHECK-NEXT:    vmov r0, s4
; CHECK-NEXT:    vmovx.f16 s4, s10
; CHECK-NEXT:    vmov.16 q0[6], r0
; CHECK-NEXT:    vldrw.u32 q7, [sp, #32] @ 16-byte Reload
; CHECK-NEXT:    vins.f16 s0, s4
; CHECK-NEXT:    vmovx.f16 s4, s11
; CHECK-NEXT:    vmovx.f16 s2, s23
; CHECK-NEXT:    vins.f16 s3, s4
; CHECK-NEXT:    vmovx.f16 s4, s5
; CHECK-NEXT:    vins.f16 s11, s2
; CHECK-NEXT:    vmov.f32 s2, s22
; CHECK-NEXT:    vmov r0, s4
; CHECK-NEXT:    vins.f16 s2, s6
; CHECK-NEXT:    vmov.16 q1[2], r0
; CHECK-NEXT:    vmov.f32 s29, s12
; CHECK-NEXT:    vmovx.f16 s4, s21
; CHECK-NEXT:    vmovx.f16 s12, s9
; CHECK-NEXT:    vins.f16 s9, s4
; CHECK-NEXT:    vmovx.f16 s4, s22
; CHECK-NEXT:    vins.f16 s10, s4
; CHECK-NEXT:    vmov.f32 s21, s17
; CHECK-NEXT:    vmov.f32 s22, s18
; CHECK-NEXT:    vins.f16 s5, s12
; CHECK-NEXT:    vmov.f32 s4, s18
; CHECK-NEXT:    vldrw.u32 q4, [sp] @ 16-byte Reload
; CHECK-NEXT:    vstrw.32 q7, [sp, #32] @ 16-byte Spill
; CHECK-NEXT:    vmov.f32 s6, s2
; CHECK-NEXT:    vmovx.f16 s12, s17
; CHECK-NEXT:    vins.f16 s4, s18
; CHECK-NEXT:    vmov r0, s12
; CHECK-NEXT:    vmovx.f16 s12, s13
; CHECK-NEXT:    vmov.16 q7[2], r0
; CHECK-NEXT:    vmov.f32 s2, s11
; CHECK-NEXT:    vmov.f32 s30, s4
; CHECK-NEXT:    vmovx.f16 s4, s21
; CHECK-NEXT:    vins.f16 s13, s4
; CHECK-NEXT:    vmovx.f16 s4, s22
; CHECK-NEXT:    vins.f16 s14, s4
; CHECK-NEXT:    vldrw.u32 q5, [sp, #16] @ 16-byte Reload
; CHECK-NEXT:    vstrw.32 q0, [r1, #80]
; CHECK-NEXT:    vldrw.u32 q0, [sp, #32] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s26, s15
; CHECK-NEXT:    vins.f16 s29, s12
; CHECK-NEXT:    vmov.f32 s21, s8
; CHECK-NEXT:    vstrw.32 q6, [r1, #32]
; CHECK-NEXT:    vmov.f32 s4, s9
; CHECK-NEXT:    vstrw.32 q5, [r1, #48]
; CHECK-NEXT:    vmov.f32 s7, s10
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    vmov.f32 s28, s13
; CHECK-NEXT:    vstrw.32 q1, [r1, #64]
; CHECK-NEXT:    vmov.f32 s31, s14
; CHECK-NEXT:    vstrw.32 q7, [r1, #16]
; CHECK-NEXT:    add sp, #48
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <16 x half>, <16 x half>* %src, i32 0
  %l1 = load <16 x half>, <16 x half>* %s1, align 4
  %s2 = getelementptr <16 x half>, <16 x half>* %src, i32 1
  %l2 = load <16 x half>, <16 x half>* %s2, align 4
  %s3 = getelementptr <16 x half>, <16 x half>* %src, i32 2
  %l3 = load <16 x half>, <16 x half>* %s3, align 4
  %t1 = shufflevector <16 x half> %l1, <16 x half> %l2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %t2 = shufflevector <16 x half> %l3, <16 x half> undef, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <32 x half> %t1, <32 x half> %t2, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
  store <48 x half> %s, <48 x half> *%dst
  ret void
}

; f64

define void @vst3_v2f64(<2 x double> *%src, <6 x double> *%dst) {
; CHECK-LABEL: vst3_v2f64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #16]
; CHECK-NEXT:    vmov.f64 d6, d2
; CHECK-NEXT:    vmov.f64 d7, d1
; CHECK-NEXT:    vmov.f64 d1, d4
; CHECK-NEXT:    vstrw.32 q3, [r1, #16]
; CHECK-NEXT:    vmov.f64 d2, d5
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    vstrw.32 q1, [r1, #32]
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <2 x double>, <2 x double>* %src, i32 0
  %l1 = load <2 x double>, <2 x double>* %s1, align 4
  %s2 = getelementptr <2 x double>, <2 x double>* %src, i32 1
  %l2 = load <2 x double>, <2 x double>* %s2, align 4
  %s3 = getelementptr <2 x double>, <2 x double>* %src, i32 2
  %l3 = load <2 x double>, <2 x double>* %s3, align 4
  %t1 = shufflevector <2 x double> %l1, <2 x double> %l2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %t2 = shufflevector <2 x double> %l3, <2 x double> undef, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %s = shufflevector <4 x double> %t1, <4 x double> %t2, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
  store <6 x double> %s, <6 x double> *%dst
  ret void
}

define void @vst3_v4f64(<4 x double> *%src, <12 x double> *%dst) {
; CHECK-LABEL: vst3_v4f64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vldrw.u32 q7, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q6, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q0, [r0, #80]
; CHECK-NEXT:    vldrw.u32 q1, [r0]
; CHECK-NEXT:    vmov.f64 d6, d15
; CHECK-NEXT:    vldrw.u32 q2, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q4, [r0, #64]
; CHECK-NEXT:    vmov.f64 d15, d13
; CHECK-NEXT:    vmov.f64 d7, d1
; CHECK-NEXT:    vmov.f64 d10, d2
; CHECK-NEXT:    vstrw.32 q3, [r1, #80]
; CHECK-NEXT:    vmov.f64 d11, d12
; CHECK-NEXT:    vmov.f64 d2, d8
; CHECK-NEXT:    vstrw.32 q5, [r1]
; CHECK-NEXT:    vmov.f64 d1, d5
; CHECK-NEXT:    vstrw.32 q1, [r1, #16]
; CHECK-NEXT:    vmov.f64 d8, d15
; CHECK-NEXT:    vstrw.32 q0, [r1, #64]
; CHECK-NEXT:    vmov.f64 d12, d4
; CHECK-NEXT:    vstrw.32 q4, [r1, #32]
; CHECK-NEXT:    vmov.f64 d13, d14
; CHECK-NEXT:    vstrw.32 q6, [r1, #48]
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <4 x double>, <4 x double>* %src, i32 0
  %l1 = load <4 x double>, <4 x double>* %s1, align 4
  %s2 = getelementptr <4 x double>, <4 x double>* %src, i32 1
  %l2 = load <4 x double>, <4 x double>* %s2, align 4
  %s3 = getelementptr <4 x double>, <4 x double>* %src, i32 2
  %l3 = load <4 x double>, <4 x double>* %s3, align 4
  %t1 = shufflevector <4 x double> %l1, <4 x double> %l2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %t2 = shufflevector <4 x double> %l3, <4 x double> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <8 x double> %t1, <8 x double> %t2, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  store <12 x double> %s, <12 x double> *%dst
  ret void
}
