/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontology.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.ontology.AllDifferent;
import org.apache.jena.ontology.AllValuesFromRestriction;
import org.apache.jena.ontology.AnnotationProperty;
import org.apache.jena.ontology.CardinalityRestriction;
import org.apache.jena.ontology.DatatypeProperty;
import org.apache.jena.ontology.FunctionalProperty;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.InverseFunctionalProperty;
import org.apache.jena.ontology.MaxCardinalityRestriction;
import org.apache.jena.ontology.MinCardinalityRestriction;
import org.apache.jena.ontology.ObjectProperty;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntProperty;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.ontology.Restriction;
import org.apache.jena.ontology.SomeValuesFromRestriction;
import org.apache.jena.ontology.SymmetricProperty;
import org.apache.jena.ontology.TransitiveProperty;
import org.apache.jena.ontology.impl.AbstractProfile;
import org.apache.jena.ontology.impl.OWLProfile;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class OWLLiteProfile
extends OWLProfile {
    protected static Object[][] s_supportsCheckData = new Object[][]{{AllDifferent.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.AllDifferent.asNode());
        }
    }}, {AnnotationProperty.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            Iterator<Resource> i = ((OntModel)((Object)g)).getProfile().getAnnotationProperties();
            while (i.hasNext()) {
                if (!i.next().asNode().equals(n)) continue;
                return true;
            }
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.AnnotationProperty.asNode());
        }
    }}, {OntClass.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph eg) {
            Graph g = eg.asGraph();
            return this.hasType(n, eg, new Resource[]{OWL.Class, OWL.Restriction, RDFS.Class, RDFS.Datatype}) || n.equals(OWL.Thing.asNode()) || g.contains(Node.ANY, RDFS.domain.asNode(), n) || g.contains(Node.ANY, RDFS.range.asNode(), n) || g.contains(n, OWL.intersectionOf.asNode(), Node.ANY);
        }
    }}, {DatatypeProperty.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.DatatypeProperty.asNode());
        }
    }}, {ObjectProperty.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return this.hasType(n, g, new Resource[]{OWL.ObjectProperty, OWL.TransitiveProperty, OWL.SymmetricProperty, OWL.InverseFunctionalProperty});
        }
    }}, {FunctionalProperty.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.FunctionalProperty.asNode());
        }
    }}, {InverseFunctionalProperty.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.InverseFunctionalProperty.asNode()) && !g.asGraph().contains(n, RDF.type.asNode(), OWL.DatatypeProperty.asNode());
        }
    }}, {RDFList.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return n.equals(RDF.nil.asNode()) || g.asGraph().contains(n, RDF.type.asNode(), RDF.List.asNode());
        }
    }}, {OntProperty.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return this.hasType(n, g, new Resource[]{RDF.Property, OWL.ObjectProperty, OWL.DatatypeProperty, OWL.AnnotationProperty, OWL.TransitiveProperty, OWL.SymmetricProperty, OWL.InverseFunctionalProperty, OWL.FunctionalProperty});
        }
    }}, {Ontology.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.Ontology.asNode());
        }
    }}, {Restriction.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.Restriction.asNode());
        }
    }}, {AllValuesFromRestriction.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLLiteProfile.containsSome(g, n, OWL.allValuesFrom) && OWLLiteProfile.containsSome(g, n, OWL.onProperty);
        }
    }}, {SomeValuesFromRestriction.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLLiteProfile.containsSome(g, n, OWL.someValuesFrom) && OWLLiteProfile.containsSome(g, n, OWL.onProperty);
        }
    }}, {CardinalityRestriction.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLLiteProfile.containsSome(g, n, OWL.cardinality) && OWLLiteProfile.containsSome(g, n, OWL.onProperty);
        }
    }}, {MinCardinalityRestriction.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLLiteProfile.containsSome(g, n, OWL.minCardinality) && OWLLiteProfile.containsSome(g, n, OWL.onProperty);
        }
    }}, {MaxCardinalityRestriction.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLLiteProfile.containsSome(g, n, OWL.maxCardinality) && OWLLiteProfile.containsSome(g, n, OWL.onProperty);
        }
    }}, {SymmetricProperty.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.SymmetricProperty.asNode()) && !g.asGraph().contains(n, RDF.type.asNode(), OWL.DatatypeProperty.asNode());
        }
    }}, {TransitiveProperty.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), OWL.TransitiveProperty.asNode()) && !g.asGraph().contains(n, RDF.type.asNode(), OWL.DatatypeProperty.asNode());
        }
    }}, {Individual.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g) {
            if (n.isURI() || n.isBlank()) {
                return !this.hasType(n, g, new Resource[]{RDFS.Class, RDF.Property, OWL.Class, OWL.ObjectProperty, OWL.DatatypeProperty, OWL.TransitiveProperty, OWL.FunctionalProperty, OWL.InverseFunctionalProperty});
            }
            return false;
        }
    }}};
    private static Map<Class<?>, OWLProfile.SupportsCheck> s_supportsChecks = new HashMap();

    @Override
    public Resource DATARANGE() {
        return null;
    }

    @Override
    public Resource NOTHING() {
        return null;
    }

    @Override
    public Property COMPLEMENT_OF() {
        return null;
    }

    @Override
    public Property DISJOINT_WITH() {
        return null;
    }

    @Override
    public Property HAS_VALUE() {
        return null;
    }

    @Override
    public Property ONE_OF() {
        return null;
    }

    @Override
    public Property UNION_OF() {
        return null;
    }

    @Override
    public Property SAME_AS() {
        return null;
    }

    @Override
    public Property SAME_INDIVIDUAL_AS() {
        return null;
    }

    @Override
    public String getLabel() {
        return "OWL Lite";
    }

    public static boolean containsSome(EnhGraph g, Node n, Property p) {
        return AbstractProfile.containsSome(g, n, p);
    }

    @Override
    protected Map<Class<?>, OWLProfile.SupportsCheck> getCheckTable() {
        return s_supportsChecks;
    }

    static {
        for (Object[] aS_supportsCheckData : s_supportsCheckData) {
            s_supportsChecks.put((Class)aS_supportsCheckData[0], (OWLProfile.SupportsCheck)aS_supportsCheckData[1]);
        }
    }
}

