.TH CONREC 3NCARG "March 1993" UNIX "NCAR GRAPHICS"
.na
.nh
.SH NAME
CONREC - draws a two dimensional contour map from data stored in a
rectangular array.  The contour lines are labeled.
.SH UTILITY
This routine is part of the conrec utility in NCAR Graphics. To see
the overview man page for this utility, type "man conrec_family".
.SH STATUS
CONREC is obsolete.  It has been superseded by the contouring package,
Conpack.  See the Conpack entry CPCNRC for a simple CONREC replacement.
For more complex examples refer to the conpack and
conpack_params man pages as well as the NCAR Graphics
Contouring and Mapping Tutorial.
.sp
CONREC continues to be provided for compatibility of early NCAR Graphics
codes.  If you are writing new code, we suggest that you use the more
general and rigorous Conpack contouring package.  All CONREC options
can be duplicated by the proper selection of Conpack parameters.
.SH SYNOPSIS
CALL CONREC(Z,L,M,N,FLO,HI,FINC,NSET,NHI,NDOT) - draws a contour map
using options specified as input arguments.
.SH DESCRIPTION 
.IP Z 12
(an input array of type REAL) defining a two-dimensional field to be
contoured.  A subset of Z of extent M by N can be contoured.
.IP L 12
(an input parameter of type INTEGER) which is the first dimension of
the Z array.
.IP M 12
(an input parameter of type INTEGER) which is the extent of the
first dimension of array Z to be contoured.  This allows for a sub-array
of Z to be contoured.  M must be less than or equal to L.
.IP N 12
(an input parameter of type INTEGER) which is the extent of the
second dimension of array Z to be contoured.  This allows for a sub-array
of Z to be contoured.  N must be less than or equal to the second dimension
of Z.
.IP FLO 12
(an input parameter of type REAL) defining a lowest level for contouring.
If FLO = HI = 0., a value rounded up from the minimum value of Z will be
generated by CONREC.
.IP HI 12
(an input parameter of type REAL) defining a highest level for contouring.
If HI = FLO = 0., a value rounded down from the maximum value of Z will be
generated by CONREC.
.IP FINC 12
(an input parameter of type REAL) which defines how the contour levels are
to be selected.
.sp
> 0., use this value for the increment between contour levels.
There will be (HI-FLO)/FINC contour lines generated.
.sp
= 0., causes CONREC to generate a value which will result in
between 10 and 30 contours.
.sp
< 0., the number of contour levels is the integer absolute
value of this number (FINC.)
.IP NSET 12
(an input parameter of type INTEGER) which controls plot scaling according to:
.sp
= 0, CONREC automatically sets the window and viewport sizes.
The viewport becomes by default .05 to .95 in the larger
dimension (M or N), and .05 to a proportionately smaller
number in the smaller dimension.  The window becomes
1. to FLOAT(M) in X, and 1. to FLOAT(N) in Y.
The PERIM entry of the Gridall utility is called to generate
a plot boundary with tick marks placed at the data grid points.
.sp
> 0, CONREC assumes the window and viewport have been set by the user.
No plot boundary is drawn.
.sp
< 0, CONREC uses the existing viewport and sets the window to
1. to FLOAT(M) in X, and 1. to FLOAT(N) in Y.
No plot boundary is drawn.
.IP NHI 12
(an input parameter of type INTEGER) which controls the printing of
extra information on the plot.
.sp
= 0, Symbols H and L are written where highs and lows occur and
the value of the high or low is written under the symbol.
.sp
> 0, The Z data values are printed, centered at each grid point.
.sp
< 0, Neither of the above is done.
.IP NDOT 12
(an input parameter of type INTEGER) which specifies the line patterns
to be used in drawing the contours.  Only the last 10 binary bits of
NDOT are used in creating a binary pattern is which 0's are no-line
and 1's are line segments. If the absolute value of NDOT is
0, 1, or 1023 a solid line is drawn.  1023 in decimal converts to
1777 octal, or 1111111111 in binary.
.sp
> 0, The NDOT pattern is used to draw all contours.
.sp
< 0, The absolute value of NDOT is used for negative-valued
contours and solid lines are drawn for positive contours.
.SH EXAMPLES
Use the ncargex command to see the relevant examples tconre,
tcnqck, tcnsmt, and tcnsup.
.SH ACCESS 
CONREC can be invoked in four different ways to create
contour plots which vary considerably in appearance.  The four variations
include quick, normal, smooth, and super contour lines.  This progression
represents a tradeoff between speed of computation and the appearance of the
contour plots.  These variations are specified through selected command line
options of the ncargf77 command.
.sp
To use CONREC, load the NCAR Graphics libraries ncarg, ncarg_gks,
and ncarg_c, preferably in that order.  Other optional libraries
to create the quick, smooth, and super contours will
automatically be linked by the ncargf77 command.
To run a code called mycode.f which has one or more calls to
entry CONREC, issue one of the commands:
.sp
.IP NORMAL 10
Command:  "ncargf77 mycode.f"
.sp
The contours will be drawn as unsmoothed
dashed or solid lines that can include characters along the lines.
.sp 2
.IP QUICK 10
Command:  "ncargf77 -quick mycode.f"
.sp
The contours will be drawn as unsmoothed
dashed or solid lines without characters along the lines.
The QUICK drawing algorithm is faster and cruder than that used for
NORMAL contour lines.  QUICK uses a cell-by-cell analysis rather than
following each contour line to completion in sequence as is done in
the NORMAL algorithm.
.sp 2
.IP SMOOTH 10
Command:  "ncargf77 -smooth mycode.f"
.sp
The contours will be drawn as smoothed
dashed or solid lines using splines under tension.  There may be
characters along the lines.
.sp 2
.IP SUPER 10
Command:  "ncargf77 -super mycode.f"
.sp
The contours will be drawn as smoothed
dashed or solid lines using splines under tension.  There may be
characters along the lines.  Crowded lines can be thinned.
.SH MESSAGES
When error conditions are detected, the support routine SETER 
is called in such a way that it writes a message to the standard
error file (as defined by I1MACH(4)) and then terminates 
execution. The possible error messages are as follows:
.sp
CONREC  - DIMENSION ERROR - M*N .GT. (2**IARTH)
.br
The array to be contoured is dimensioned M by N.  This is larger
than the address space on this computer (2**IARTH) where IARTH is
the size of an address integer.  Check your dimension sizes.
.SH SEE ALSO
Online:
ezcntr, conrec_family_params, conrec_family,
conpack, conpack_params, cpcnrc, gridall,
dashline_family, ncargf77
.sp
Hardcopy:  
NCAR Graphics Contouring and Mapping Tutorial;
NCAR Graphics Fundamentals, UNIX Version;
User's Guide for NCAR GKS-0A Graphics
.SH COPYRIGHT
Copyright (C) 1987-2009
.br
University Corporation for Atmospheric Research
.br
The use of this Software is governed by a License Agreement.
