## TFSA-2021-180: Deadlock in mutually recursive `tf.function` objects

### CVE Number
CVE-2021-41213

### Impact
The [code behind `tf.function` API](https://github.com/tensorflow/tensorflow/blob/8d72537c6abf5a44103b57b9c2e22c14f5f49698/tensorflow/python/eager/def_function.py#L542) can be made to deadlock when two `tf.function` decorated Python functions are mutually recursive:

```python
import tensorflow as tf

@tf.function()
def fun1(num):
    if num == 1:
        return
    print(num)
    fun2(num-1)

@tf.function()
def fun2(num):
    if num == 0:
        return
    print(num)
    fun1(num-1)

fun1(9)
```

This occurs due to using a non-reentrant `Lock` Python object.

Loading any model which contains mutually recursive functions is vulnerable. An attacker can cause denial of service by causing users to load such models and calling a recursive `tf.function`, although this is not a frequent scenario.

### Patches
We have patched the issue in GitHub commit [afac8158d43691661ad083f6dd9e56f327c1dcb7](https://github.com/tensorflow/tensorflow/commit/afac8158d43691661ad083f6dd9e56f327c1dcb7).

The fix will be included in TensorFlow 2.7.0. We will also cherrypick this commit on TensorFlow 2.6.1, TensorFlow 2.5.2, and TensorFlow 2.4.4, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo 360.
