/** \file
 * Tables telling us how to do integer division
 * via fixed-point multiplication for various small
 * constants. This file is automatically generated
 * by find_inverse.cpp. There are two sets of tables.
 * The first set is for compile-time-constant divisors
 * from 2 to 256. The second is for runtime divisors
 * from 1 to 255. The second set always uses the most
 * expensive method, while the compile-time set uses
 * the cheapest method for the given divisor.
 */

#include "IntegerDivisionTable.h"

namespace Halide {
namespace Internal {
namespace IntegerDivision {

const int64_t table_u8[256][4] = {
    {256, 0, 0, 8},
    {1, 0, 0, 0},
    {2, 0, 0, 1},
    {3, 1, 171ULL, 1},
    {4, 0, 0, 2},
    {5, 1, 205ULL, 2},
    {6, 1, 171ULL, 2},
    {7, 3, 36ULL, 2},
    {8, 0, 0, 3},
    {9, 1, 57ULL, 1},
    {10, 1, 205ULL, 3},
    {11, 3, 116ULL, 3},
    {12, 1, 171ULL, 3},
    {13, 1, 79ULL, 2},
    {14, 3, 36ULL, 3},
    {15, 1, 137ULL, 3},
    {16, 0, 0, 4},
    {17, 1, 241ULL, 4},
    {18, 1, 57ULL, 2},
    {19, 1, 27ULL, 1},
    {20, 1, 205ULL, 4},
    {21, 3, 134ULL, 4},
    {22, 3, 116ULL, 4},
    {23, 3, 100ULL, 4},
    {24, 1, 171ULL, 4},
    {25, 1, 41ULL, 2},
    {26, 1, 79ULL, 3},
    {27, 1, 19ULL, 1},
    {28, 3, 36ULL, 4},
    {29, 3, 26ULL, 4},
    {30, 1, 137ULL, 4},
    {31, 3, 8ULL, 4},
    {32, 0, 0, 5},
    {33, 1, 249ULL, 5},
    {34, 1, 241ULL, 5},
    {35, 1, 235ULL, 5},
    {36, 1, 57ULL, 3},
    {37, 1, 111ULL, 4},
    {38, 1, 27ULL, 2},
    {39, 3, 164ULL, 5},
    {40, 1, 205ULL, 5},
    {41, 1, 25ULL, 2},
    {42, 3, 134ULL, 5},
    {43, 1, 191ULL, 5},
    {44, 1, 187ULL, 5},
    {45, 3, 108ULL, 5},
    {46, 3, 100ULL, 5},
    {47, 1, 175ULL, 5},
    {48, 1, 171ULL, 5},
    {49, 3, 78ULL, 5},
    {50, 1, 41ULL, 3},
    {51, 1, 161ULL, 5},
    {52, 1, 79ULL, 4},
    {53, 1, 155ULL, 5},
    {54, 1, 19ULL, 2},
    {55, 1, 149ULL, 5},
    {56, 3, 36ULL, 5},
    {57, 1, 9ULL, 1},
    {58, 3, 26ULL, 5},
    {59, 1, 139ULL, 5},
    {60, 1, 137ULL, 5},
    {61, 3, 12ULL, 5},
    {62, 3, 8ULL, 5},
    {63, 3, 4ULL, 5},
    {64, 0, 0, 6},
    {65, 1, 253ULL, 6},
    {66, 1, 249ULL, 6},
    {67, 1, 245ULL, 6},
    {68, 1, 121ULL, 5},
    {69, 1, 119ULL, 5},
    {70, 1, 235ULL, 6},
    {71, 1, 231ULL, 6},
    {72, 1, 57ULL, 4},
    {73, 1, 225ULL, 6},
    {74, 1, 111ULL, 5},
    {75, 1, 219ULL, 6},
    {76, 1, 27ULL, 3},
    {77, 1, 213ULL, 6},
    {78, 3, 164ULL, 6},
    {79, 1, 13ULL, 2},
    {80, 1, 205ULL, 6},
    {81, 1, 203ULL, 6},
    {82, 1, 25ULL, 3},
    {83, 1, 99ULL, 5},
    {84, 3, 134ULL, 6},
    {85, 1, 193ULL, 6},
    {86, 1, 191ULL, 6},
    {87, 1, 189ULL, 6},
    {88, 1, 187ULL, 6},
    {89, 1, 185ULL, 6},
    {90, 1, 183ULL, 6},
    {91, 1, 181ULL, 6},
    {92, 1, 179ULL, 6},
    {93, 1, 177ULL, 6},
    {94, 1, 175ULL, 6},
    {95, 1, 173ULL, 6},
    {96, 1, 171ULL, 6},
    {97, 1, 169ULL, 6},
    {98, 1, 21ULL, 3},
    {99, 1, 83ULL, 5},
    {100, 1, 41ULL, 4},
    {101, 1, 163ULL, 6},
    {102, 1, 161ULL, 6},
    {103, 3, 62ULL, 6},
    {104, 1, 79ULL, 5},
    {105, 3, 56ULL, 6},
    {106, 1, 155ULL, 6},
    {107, 3, 50ULL, 6},
    {108, 1, 19ULL, 3},
    {109, 1, 151ULL, 6},
    {110, 1, 149ULL, 6},
    {111, 1, 37ULL, 4},
    {112, 3, 36ULL, 6},
    {113, 1, 145ULL, 6},
    {114, 1, 9ULL, 2},
    {115, 1, 143ULL, 6},
    {116, 3, 26ULL, 6},
    {117, 3, 24ULL, 6},
    {118, 1, 139ULL, 6},
    {119, 1, 69ULL, 5},
    {120, 1, 137ULL, 6},
    {121, 3, 14ULL, 6},
    {122, 3, 12ULL, 6},
    {123, 3, 10ULL, 6},
    {124, 3, 8ULL, 6},
    {125, 3, 6ULL, 6},
    {126, 3, 4ULL, 6},
    {127, 3, 2ULL, 6},
    {128, 0, 0, 7},
    {129, 1, 255ULL, 7},
    {130, 1, 127ULL, 6},
    {131, 1, 63ULL, 5},
    {132, 1, 125ULL, 6},
    {133, 1, 31ULL, 4},
    {134, 1, 123ULL, 6},
    {135, 1, 61ULL, 5},
    {136, 1, 121ULL, 6},
    {137, 1, 15ULL, 3},
    {138, 1, 119ULL, 6},
    {139, 1, 59ULL, 5},
    {140, 1, 235ULL, 7},
    {141, 1, 117ULL, 6},
    {142, 1, 29ULL, 4},
    {143, 1, 115ULL, 6},
    {144, 1, 57ULL, 5},
    {145, 1, 113ULL, 6},
    {146, 1, 225ULL, 7},
    {147, 1, 7ULL, 2},
    {148, 1, 111ULL, 6},
    {149, 1, 55ULL, 5},
    {150, 1, 219ULL, 7},
    {151, 1, 109ULL, 6},
    {152, 1, 27ULL, 4},
    {153, 1, 215ULL, 7},
    {154, 1, 107ULL, 6},
    {155, 1, 53ULL, 5},
    {156, 1, 211ULL, 7},
    {157, 1, 105ULL, 6},
    {158, 1, 13ULL, 3},
    {159, 1, 207ULL, 7},
    {160, 1, 103ULL, 6},
    {161, 1, 51ULL, 5},
    {162, 1, 203ULL, 7},
    {163, 1, 101ULL, 6},
    {164, 1, 25ULL, 4},
    {165, 1, 199ULL, 7},
    {166, 1, 99ULL, 6},
    {167, 1, 197ULL, 7},
    {168, 1, 49ULL, 5},
    {169, 1, 97ULL, 6},
    {170, 1, 193ULL, 7},
    {171, 1, 3ULL, 1},
    {172, 1, 191ULL, 7},
    {173, 1, 95ULL, 6},
    {174, 1, 189ULL, 7},
    {175, 1, 47ULL, 5},
    {176, 1, 187ULL, 7},
    {177, 1, 93ULL, 6},
    {178, 1, 185ULL, 7},
    {179, 1, 23ULL, 4},
    {180, 1, 183ULL, 7},
    {181, 1, 91ULL, 6},
    {182, 1, 181ULL, 7},
    {183, 1, 45ULL, 5},
    {184, 1, 179ULL, 7},
    {185, 1, 89ULL, 6},
    {186, 1, 177ULL, 7},
    {187, 1, 11ULL, 3},
    {188, 1, 175ULL, 7},
    {189, 1, 87ULL, 6},
    {190, 1, 173ULL, 7},
    {191, 1, 43ULL, 5},
    {192, 1, 171ULL, 7},
    {193, 1, 85ULL, 6},
    {194, 1, 169ULL, 7},
    {195, 3, 80ULL, 7},
    {196, 1, 21ULL, 4},
    {197, 1, 167ULL, 7},
    {198, 1, 83ULL, 6},
    {199, 1, 165ULL, 7},
    {200, 1, 41ULL, 5},
    {201, 3, 70ULL, 7},
    {202, 1, 163ULL, 7},
    {203, 1, 81ULL, 6},
    {204, 1, 161ULL, 7},
    {205, 1, 5ULL, 2},
    {206, 3, 62ULL, 7},
    {207, 1, 159ULL, 7},
    {208, 1, 79ULL, 6},
    {209, 1, 157ULL, 7},
    {210, 3, 56ULL, 7},
    {211, 1, 39ULL, 5},
    {212, 1, 155ULL, 7},
    {213, 1, 77ULL, 6},
    {214, 3, 50ULL, 7},
    {215, 1, 153ULL, 7},
    {216, 1, 19ULL, 4},
    {217, 3, 46ULL, 7},
    {218, 1, 151ULL, 7},
    {219, 1, 75ULL, 6},
    {220, 1, 149ULL, 7},
    {221, 3, 40ULL, 7},
    {222, 1, 37ULL, 5},
    {223, 1, 147ULL, 7},
    {224, 3, 36ULL, 7},
    {225, 1, 73ULL, 6},
    {226, 1, 145ULL, 7},
    {227, 3, 32ULL, 7},
    {228, 1, 9ULL, 3},
    {229, 3, 30ULL, 7},
    {230, 1, 143ULL, 7},
    {231, 1, 71ULL, 6},
    {232, 3, 26ULL, 7},
    {233, 1, 141ULL, 7},
    {234, 3, 24ULL, 7},
    {235, 1, 35ULL, 5},
    {236, 1, 139ULL, 7},
    {237, 3, 20ULL, 7},
    {238, 1, 69ULL, 6},
    {239, 3, 18ULL, 7},
    {240, 1, 137ULL, 7},
    {241, 1, 17ULL, 4},
    {242, 3, 14ULL, 7},
    {243, 1, 135ULL, 7},
    {244, 3, 12ULL, 7},
    {245, 1, 67ULL, 6},
    {246, 3, 10ULL, 7},
    {247, 1, 133ULL, 7},
    {248, 3, 8ULL, 7},
    {249, 1, 33ULL, 5},
    {250, 3, 6ULL, 7},
    {251, 1, 131ULL, 7},
    {252, 3, 4ULL, 7},
    {253, 1, 65ULL, 6},
    {254, 3, 2ULL, 7},
    {255, 1, 129ULL, 7},
};
const int64_t table_s8[256][4] = {
    {256, 0, 0, 7},
    {1, 0, 0, 0},
    {2, 0, 0, 1},
    {3, 1, 171LL, 1},
    {4, 0, 0, 2},
    {5, 1, 205LL, 2},
    {6, 1, 171LL, 2},
    {7, 1, 147LL, 2},
    {8, 0, 0, 3},
    {9, 1, 228LL, 3},
    {10, 1, 205LL, 3},
    {11, 1, 187LL, 3},
    {12, 1, 171LL, 3},
    {13, 1, 158LL, 3},
    {14, 1, 147LL, 3},
    {15, 1, 137LL, 3},
    {16, 0, 0, 4},
    {17, 1, 241LL, 4},
    {18, 1, 228LL, 4},
    {19, 1, 216LL, 4},
    {20, 1, 205LL, 4},
    {21, 1, 196LL, 4},
    {22, 1, 187LL, 4},
    {23, 1, 179LL, 4},
    {24, 1, 171LL, 4},
    {25, 1, 164LL, 4},
    {26, 1, 158LL, 4},
    {27, 1, 152LL, 4},
    {28, 1, 147LL, 4},
    {29, 1, 142LL, 4},
    {30, 1, 137LL, 4},
    {31, 1, 133LL, 4},
    {32, 0, 0, 5},
    {33, 1, 249LL, 5},
    {34, 1, 241LL, 5},
    {35, 1, 235LL, 5},
    {36, 1, 228LL, 5},
    {37, 1, 222LL, 5},
    {38, 1, 216LL, 5},
    {39, 1, 211LL, 5},
    {40, 1, 205LL, 5},
    {41, 1, 200LL, 5},
    {42, 1, 196LL, 5},
    {43, 1, 191LL, 5},
    {44, 1, 187LL, 5},
    {45, 1, 183LL, 5},
    {46, 1, 179LL, 5},
    {47, 1, 175LL, 5},
    {48, 1, 171LL, 5},
    {49, 1, 168LL, 5},
    {50, 1, 164LL, 5},
    {51, 1, 161LL, 5},
    {52, 1, 158LL, 5},
    {53, 1, 155LL, 5},
    {54, 1, 152LL, 5},
    {55, 1, 149LL, 5},
    {56, 1, 147LL, 5},
    {57, 1, 144LL, 5},
    {58, 1, 142LL, 5},
    {59, 1, 139LL, 5},
    {60, 1, 137LL, 5},
    {61, 1, 135LL, 5},
    {62, 1, 133LL, 5},
    {63, 1, 131LL, 5},
    {64, 0, 0, 6},
    {65, 1, 253LL, 6},
    {66, 1, 249LL, 6},
    {67, 1, 245LL, 6},
    {68, 1, 241LL, 6},
    {69, 1, 238LL, 6},
    {70, 1, 235LL, 6},
    {71, 1, 231LL, 6},
    {72, 1, 228LL, 6},
    {73, 1, 225LL, 6},
    {74, 1, 222LL, 6},
    {75, 1, 219LL, 6},
    {76, 1, 216LL, 6},
    {77, 1, 213LL, 6},
    {78, 1, 211LL, 6},
    {79, 1, 208LL, 6},
    {80, 1, 205LL, 6},
    {81, 1, 203LL, 6},
    {82, 1, 200LL, 6},
    {83, 1, 198LL, 6},
    {84, 1, 196LL, 6},
    {85, 1, 193LL, 6},
    {86, 1, 191LL, 6},
    {87, 1, 189LL, 6},
    {88, 1, 187LL, 6},
    {89, 1, 185LL, 6},
    {90, 1, 183LL, 6},
    {91, 1, 181LL, 6},
    {92, 1, 179LL, 6},
    {93, 1, 177LL, 6},
    {94, 1, 175LL, 6},
    {95, 1, 173LL, 6},
    {96, 1, 171LL, 6},
    {97, 1, 169LL, 6},
    {98, 1, 168LL, 6},
    {99, 1, 166LL, 6},
    {100, 1, 164LL, 6},
    {101, 1, 163LL, 6},
    {102, 1, 161LL, 6},
    {103, 1, 160LL, 6},
    {104, 1, 158LL, 6},
    {105, 1, 157LL, 6},
    {106, 1, 155LL, 6},
    {107, 1, 154LL, 6},
    {108, 1, 152LL, 6},
    {109, 1, 151LL, 6},
    {110, 1, 149LL, 6},
    {111, 1, 148LL, 6},
    {112, 1, 147LL, 6},
    {113, 1, 145LL, 6},
    {114, 1, 144LL, 6},
    {115, 1, 143LL, 6},
    {116, 1, 142LL, 6},
    {117, 1, 141LL, 6},
    {118, 1, 139LL, 6},
    {119, 1, 138LL, 6},
    {120, 1, 137LL, 6},
    {121, 1, 136LL, 6},
    {122, 1, 135LL, 6},
    {123, 1, 134LL, 6},
    {124, 1, 133LL, 6},
    {125, 1, 132LL, 6},
    {126, 1, 131LL, 6},
    {127, 1, 130LL, 6},
    {128, 0, 0, 7},
    {129, 0, 0, 7},
    {130, 0, 0, 7},
    {131, 0, 0, 7},
    {132, 0, 0, 7},
    {133, 0, 0, 7},
    {134, 0, 0, 7},
    {135, 0, 0, 7},
    {136, 0, 0, 7},
    {137, 0, 0, 7},
    {138, 0, 0, 7},
    {139, 0, 0, 7},
    {140, 0, 0, 7},
    {141, 0, 0, 7},
    {142, 0, 0, 7},
    {143, 0, 0, 7},
    {144, 0, 0, 7},
    {145, 0, 0, 7},
    {146, 0, 0, 7},
    {147, 0, 0, 7},
    {148, 0, 0, 7},
    {149, 0, 0, 7},
    {150, 0, 0, 7},
    {151, 0, 0, 7},
    {152, 0, 0, 7},
    {153, 0, 0, 7},
    {154, 0, 0, 7},
    {155, 0, 0, 7},
    {156, 0, 0, 7},
    {157, 0, 0, 7},
    {158, 0, 0, 7},
    {159, 0, 0, 7},
    {160, 0, 0, 7},
    {161, 0, 0, 7},
    {162, 0, 0, 7},
    {163, 0, 0, 7},
    {164, 0, 0, 7},
    {165, 0, 0, 7},
    {166, 0, 0, 7},
    {167, 0, 0, 7},
    {168, 0, 0, 7},
    {169, 0, 0, 7},
    {170, 0, 0, 7},
    {171, 0, 0, 7},
    {172, 0, 0, 7},
    {173, 0, 0, 7},
    {174, 0, 0, 7},
    {175, 0, 0, 7},
    {176, 0, 0, 7},
    {177, 0, 0, 7},
    {178, 0, 0, 7},
    {179, 0, 0, 7},
    {180, 0, 0, 7},
    {181, 0, 0, 7},
    {182, 0, 0, 7},
    {183, 0, 0, 7},
    {184, 0, 0, 7},
    {185, 0, 0, 7},
    {186, 0, 0, 7},
    {187, 0, 0, 7},
    {188, 0, 0, 7},
    {189, 0, 0, 7},
    {190, 0, 0, 7},
    {191, 0, 0, 7},
    {192, 0, 0, 7},
    {193, 0, 0, 7},
    {194, 0, 0, 7},
    {195, 0, 0, 7},
    {196, 0, 0, 7},
    {197, 0, 0, 7},
    {198, 0, 0, 7},
    {199, 0, 0, 7},
    {200, 0, 0, 7},
    {201, 0, 0, 7},
    {202, 0, 0, 7},
    {203, 0, 0, 7},
    {204, 0, 0, 7},
    {205, 0, 0, 7},
    {206, 0, 0, 7},
    {207, 0, 0, 7},
    {208, 0, 0, 7},
    {209, 0, 0, 7},
    {210, 0, 0, 7},
    {211, 0, 0, 7},
    {212, 0, 0, 7},
    {213, 0, 0, 7},
    {214, 0, 0, 7},
    {215, 0, 0, 7},
    {216, 0, 0, 7},
    {217, 0, 0, 7},
    {218, 0, 0, 7},
    {219, 0, 0, 7},
    {220, 0, 0, 7},
    {221, 0, 0, 7},
    {222, 0, 0, 7},
    {223, 0, 0, 7},
    {224, 0, 0, 7},
    {225, 0, 0, 7},
    {226, 0, 0, 7},
    {227, 0, 0, 7},
    {228, 0, 0, 7},
    {229, 0, 0, 7},
    {230, 0, 0, 7},
    {231, 0, 0, 7},
    {232, 0, 0, 7},
    {233, 0, 0, 7},
    {234, 0, 0, 7},
    {235, 0, 0, 7},
    {236, 0, 0, 7},
    {237, 0, 0, 7},
    {238, 0, 0, 7},
    {239, 0, 0, 7},
    {240, 0, 0, 7},
    {241, 0, 0, 7},
    {242, 0, 0, 7},
    {243, 0, 0, 7},
    {244, 0, 0, 7},
    {245, 0, 0, 7},
    {246, 0, 0, 7},
    {247, 0, 0, 7},
    {248, 0, 0, 7},
    {249, 0, 0, 7},
    {250, 0, 0, 7},
    {251, 0, 0, 7},
    {252, 0, 0, 7},
    {253, 0, 0, 7},
    {254, 0, 0, 7},
    {255, 0, 0, 7},
};
const int64_t table_srz8[256][4] = {
    {256, 1, 129LL, 7},
    {1, 0, 0, 0},
    {2, 0, 0, 1},
    {3, 1, 171LL, 1},
    {4, 0, 0, 2},
    {5, 1, 205LL, 2},
    {6, 1, 171LL, 2},
    {7, 1, 147LL, 2},
    {8, 0, 0, 3},
    {9, 1, 228LL, 3},
    {10, 1, 205LL, 3},
    {11, 1, 187LL, 3},
    {12, 1, 171LL, 3},
    {13, 1, 158LL, 3},
    {14, 1, 147LL, 3},
    {15, 1, 137LL, 3},
    {16, 0, 0, 4},
    {17, 1, 241LL, 4},
    {18, 1, 228LL, 4},
    {19, 1, 216LL, 4},
    {20, 1, 205LL, 4},
    {21, 1, 196LL, 4},
    {22, 1, 187LL, 4},
    {23, 1, 179LL, 4},
    {24, 1, 171LL, 4},
    {25, 1, 164LL, 4},
    {26, 1, 158LL, 4},
    {27, 1, 152LL, 4},
    {28, 1, 147LL, 4},
    {29, 1, 142LL, 4},
    {30, 1, 137LL, 4},
    {31, 1, 133LL, 4},
    {32, 0, 0, 5},
    {33, 1, 249LL, 5},
    {34, 1, 241LL, 5},
    {35, 1, 235LL, 5},
    {36, 1, 228LL, 5},
    {37, 1, 222LL, 5},
    {38, 1, 216LL, 5},
    {39, 1, 211LL, 5},
    {40, 1, 205LL, 5},
    {41, 1, 200LL, 5},
    {42, 1, 196LL, 5},
    {43, 1, 191LL, 5},
    {44, 1, 187LL, 5},
    {45, 1, 183LL, 5},
    {46, 1, 179LL, 5},
    {47, 1, 175LL, 5},
    {48, 1, 171LL, 5},
    {49, 1, 168LL, 5},
    {50, 1, 164LL, 5},
    {51, 1, 161LL, 5},
    {52, 1, 158LL, 5},
    {53, 1, 155LL, 5},
    {54, 1, 152LL, 5},
    {55, 1, 149LL, 5},
    {56, 1, 147LL, 5},
    {57, 1, 144LL, 5},
    {58, 1, 142LL, 5},
    {59, 1, 139LL, 5},
    {60, 1, 137LL, 5},
    {61, 1, 135LL, 5},
    {62, 1, 133LL, 5},
    {63, 1, 131LL, 5},
    {64, 0, 0, 6},
    {65, 1, 253LL, 6},
    {66, 1, 249LL, 6},
    {67, 1, 245LL, 6},
    {68, 1, 241LL, 6},
    {69, 1, 238LL, 6},
    {70, 1, 235LL, 6},
    {71, 1, 231LL, 6},
    {72, 1, 228LL, 6},
    {73, 1, 225LL, 6},
    {74, 1, 222LL, 6},
    {75, 1, 219LL, 6},
    {76, 1, 216LL, 6},
    {77, 1, 213LL, 6},
    {78, 1, 211LL, 6},
    {79, 1, 208LL, 6},
    {80, 1, 205LL, 6},
    {81, 1, 203LL, 6},
    {82, 1, 200LL, 6},
    {83, 1, 198LL, 6},
    {84, 1, 196LL, 6},
    {85, 1, 193LL, 6},
    {86, 1, 191LL, 6},
    {87, 1, 189LL, 6},
    {88, 1, 187LL, 6},
    {89, 1, 185LL, 6},
    {90, 1, 183LL, 6},
    {91, 1, 181LL, 6},
    {92, 1, 179LL, 6},
    {93, 1, 177LL, 6},
    {94, 1, 175LL, 6},
    {95, 1, 173LL, 6},
    {96, 1, 171LL, 6},
    {97, 1, 169LL, 6},
    {98, 1, 168LL, 6},
    {99, 1, 166LL, 6},
    {100, 1, 164LL, 6},
    {101, 1, 163LL, 6},
    {102, 1, 161LL, 6},
    {103, 1, 160LL, 6},
    {104, 1, 158LL, 6},
    {105, 1, 157LL, 6},
    {106, 1, 155LL, 6},
    {107, 1, 154LL, 6},
    {108, 1, 152LL, 6},
    {109, 1, 151LL, 6},
    {110, 1, 149LL, 6},
    {111, 1, 148LL, 6},
    {112, 1, 147LL, 6},
    {113, 1, 145LL, 6},
    {114, 1, 144LL, 6},
    {115, 1, 143LL, 6},
    {116, 1, 142LL, 6},
    {117, 1, 141LL, 6},
    {118, 1, 139LL, 6},
    {119, 1, 138LL, 6},
    {120, 1, 137LL, 6},
    {121, 1, 136LL, 6},
    {122, 1, 135LL, 6},
    {123, 1, 134LL, 6},
    {124, 1, 133LL, 6},
    {125, 1, 132LL, 6},
    {126, 1, 131LL, 6},
    {127, 1, 130LL, 6},
    {128, 0, 0, 7},
    {129, 0, 0, 7},
    {130, 1, 253LL, 7},
    {131, 1, 251LL, 7},
    {132, 1, 249LL, 7},
    {133, 1, 247LL, 7},
    {134, 1, 245LL, 7},
    {135, 1, 243LL, 7},
    {136, 1, 241LL, 7},
    {137, 1, 240LL, 7},
    {138, 1, 238LL, 7},
    {139, 1, 236LL, 7},
    {140, 1, 235LL, 7},
    {141, 1, 233LL, 7},
    {142, 1, 231LL, 7},
    {143, 1, 230LL, 7},
    {144, 1, 228LL, 7},
    {145, 1, 226LL, 7},
    {146, 1, 225LL, 7},
    {147, 1, 223LL, 7},
    {148, 1, 222LL, 7},
    {149, 1, 220LL, 7},
    {150, 1, 219LL, 7},
    {151, 1, 218LL, 7},
    {152, 1, 216LL, 7},
    {153, 1, 215LL, 7},
    {154, 1, 213LL, 7},
    {155, 1, 212LL, 7},
    {156, 1, 211LL, 7},
    {157, 1, 209LL, 7},
    {158, 1, 208LL, 7},
    {159, 1, 207LL, 7},
    {160, 1, 205LL, 7},
    {161, 1, 204LL, 7},
    {162, 1, 203LL, 7},
    {163, 1, 202LL, 7},
    {164, 1, 200LL, 7},
    {165, 1, 199LL, 7},
    {166, 1, 198LL, 7},
    {167, 1, 197LL, 7},
    {168, 1, 196LL, 7},
    {169, 1, 194LL, 7},
    {170, 1, 193LL, 7},
    {171, 1, 192LL, 7},
    {172, 1, 191LL, 7},
    {173, 1, 190LL, 7},
    {174, 1, 189LL, 7},
    {175, 1, 188LL, 7},
    {176, 1, 187LL, 7},
    {177, 1, 186LL, 7},
    {178, 1, 185LL, 7},
    {179, 1, 184LL, 7},
    {180, 1, 183LL, 7},
    {181, 1, 182LL, 7},
    {182, 1, 181LL, 7},
    {183, 1, 180LL, 7},
    {184, 1, 179LL, 7},
    {185, 1, 178LL, 7},
    {186, 1, 177LL, 7},
    {187, 1, 176LL, 7},
    {188, 1, 175LL, 7},
    {189, 1, 174LL, 7},
    {190, 1, 173LL, 7},
    {191, 1, 172LL, 7},
    {192, 1, 171LL, 7},
    {193, 1, 170LL, 7},
    {194, 1, 169LL, 7},
    {195, 1, 169LL, 7},
    {196, 1, 168LL, 7},
    {197, 1, 167LL, 7},
    {198, 1, 166LL, 7},
    {199, 1, 165LL, 7},
    {200, 1, 164LL, 7},
    {201, 1, 164LL, 7},
    {202, 1, 163LL, 7},
    {203, 1, 162LL, 7},
    {204, 1, 161LL, 7},
    {205, 1, 160LL, 7},
    {206, 1, 160LL, 7},
    {207, 1, 159LL, 7},
    {208, 1, 158LL, 7},
    {209, 1, 157LL, 7},
    {210, 1, 157LL, 7},
    {211, 1, 156LL, 7},
    {212, 1, 155LL, 7},
    {213, 1, 154LL, 7},
    {214, 1, 154LL, 7},
    {215, 1, 153LL, 7},
    {216, 1, 152LL, 7},
    {217, 1, 152LL, 7},
    {218, 1, 151LL, 7},
    {219, 1, 150LL, 7},
    {220, 1, 149LL, 7},
    {221, 1, 149LL, 7},
    {222, 1, 148LL, 7},
    {223, 1, 147LL, 7},
    {224, 1, 147LL, 7},
    {225, 1, 146LL, 7},
    {226, 1, 145LL, 7},
    {227, 1, 145LL, 7},
    {228, 1, 144LL, 7},
    {229, 1, 144LL, 7},
    {230, 1, 143LL, 7},
    {231, 1, 142LL, 7},
    {232, 1, 142LL, 7},
    {233, 1, 141LL, 7},
    {234, 1, 141LL, 7},
    {235, 1, 140LL, 7},
    {236, 1, 139LL, 7},
    {237, 1, 139LL, 7},
    {238, 1, 138LL, 7},
    {239, 1, 138LL, 7},
    {240, 1, 137LL, 7},
    {241, 1, 136LL, 7},
    {242, 1, 136LL, 7},
    {243, 1, 135LL, 7},
    {244, 1, 135LL, 7},
    {245, 1, 134LL, 7},
    {246, 1, 134LL, 7},
    {247, 1, 133LL, 7},
    {248, 1, 133LL, 7},
    {249, 1, 132LL, 7},
    {250, 1, 132LL, 7},
    {251, 1, 131LL, 7},
    {252, 1, 131LL, 7},
    {253, 1, 130LL, 7},
    {254, 1, 130LL, 7},
    {255, 1, 129LL, 7},
};
const int64_t table_u16[256][4] = {
    {256, 0, 0, 8},
    {1, 0, 0, 0},
    {2, 0, 0, 1},
    {3, 1, 43691ULL, 1},
    {4, 0, 0, 2},
    {5, 1, 52429ULL, 2},
    {6, 1, 43691ULL, 2},
    {7, 3, 9362ULL, 2},
    {8, 0, 0, 3},
    {9, 1, 58255ULL, 3},
    {10, 1, 52429ULL, 3},
    {11, 1, 47663ULL, 3},
    {12, 1, 43691ULL, 3},
    {13, 1, 20165ULL, 2},
    {14, 3, 9362ULL, 3},
    {15, 1, 34953ULL, 3},
    {16, 0, 0, 4},
    {17, 1, 61681ULL, 4},
    {18, 1, 58255ULL, 4},
    {19, 1, 55189ULL, 4},
    {20, 1, 52429ULL, 4},
    {21, 3, 34328ULL, 4},
    {22, 1, 47663ULL, 4},
    {23, 3, 25644ULL, 4},
    {24, 1, 43691ULL, 4},
    {25, 3, 18350ULL, 4},
    {26, 1, 20165ULL, 3},
    {27, 3, 12136ULL, 4},
    {28, 3, 9362ULL, 4},
    {29, 1, 18079ULL, 3},
    {30, 1, 34953ULL, 4},
    {31, 3, 2114ULL, 4},
    {32, 0, 0, 5},
    {33, 1, 63551ULL, 5},
    {34, 1, 61681ULL, 5},
    {35, 1, 59919ULL, 5},
    {36, 1, 58255ULL, 5},
    {37, 1, 7085ULL, 2},
    {38, 1, 55189ULL, 5},
    {39, 3, 42010ULL, 5},
    {40, 1, 52429ULL, 5},
    {41, 3, 36764ULL, 5},
    {42, 3, 34328ULL, 5},
    {43, 1, 48771ULL, 5},
    {44, 1, 47663ULL, 5},
    {45, 1, 11651ULL, 3},
    {46, 3, 25644ULL, 5},
    {47, 3, 23704ULL, 5},
    {48, 1, 43691ULL, 5},
    {49, 3, 20062ULL, 5},
    {50, 3, 18350ULL, 5},
    {51, 1, 41121ULL, 5},
    {52, 1, 20165ULL, 4},
    {53, 1, 39569ULL, 5},
    {54, 3, 12136ULL, 5},
    {55, 3, 10724ULL, 5},
    {56, 3, 9362ULL, 5},
    {57, 3, 8048ULL, 5},
    {58, 1, 18079ULL, 4},
    {59, 1, 35545ULL, 5},
    {60, 1, 34953ULL, 5},
    {61, 1, 8595ULL, 3},
    {62, 3, 2114ULL, 5},
    {63, 3, 1040ULL, 5},
    {64, 0, 0, 6},
    {65, 1, 4033ULL, 2},
    {66, 1, 63551ULL, 6},
    {67, 1, 31301ULL, 5},
    {68, 1, 61681ULL, 6},
    {69, 3, 56038ULL, 6},
    {70, 1, 59919ULL, 6},
    {71, 1, 59075ULL, 6},
    {72, 1, 58255ULL, 6},
    {73, 1, 57457ULL, 6},
    {74, 1, 7085ULL, 3},
    {75, 3, 46312ULL, 6},
    {76, 1, 55189ULL, 6},
    {77, 1, 6809ULL, 3},
    {78, 3, 42010ULL, 6},
    {79, 1, 53093ULL, 6},
    {80, 1, 52429ULL, 6},
    {81, 1, 25891ULL, 5},
    {82, 3, 36764ULL, 6},
    {83, 1, 25267ULL, 5},
    {84, 3, 34328ULL, 6},
    {85, 1, 49345ULL, 6},
    {86, 1, 48771ULL, 6},
    {87, 1, 48211ULL, 6},
    {88, 1, 47663ULL, 6},
    {89, 3, 28718ULL, 6},
    {90, 1, 11651ULL, 4},
    {91, 3, 26646ULL, 6},
    {92, 3, 25644ULL, 6},
    {93, 3, 24664ULL, 6},
    {94, 3, 23704ULL, 6},
    {95, 1, 44151ULL, 6},
    {96, 1, 43691ULL, 6},
    {97, 3, 20944ULL, 6},
    {98, 3, 20062ULL, 6},
    {99, 1, 42367ULL, 6},
    {100, 3, 18350ULL, 6},
    {101, 1, 5191ULL, 3},
    {102, 1, 41121ULL, 6},
    {103, 1, 20361ULL, 5},
    {104, 1, 20165ULL, 5},
    {105, 1, 19973ULL, 5},
    {106, 1, 39569ULL, 6},
    {107, 3, 12862ULL, 6},
    {108, 3, 12136ULL, 6},
    {109, 1, 2405ULL, 2},
    {110, 3, 10724ULL, 6},
    {111, 1, 37787ULL, 6},
    {112, 3, 9362ULL, 6},
    {113, 1, 18559ULL, 5},
    {114, 3, 8048ULL, 6},
    {115, 3, 7408ULL, 6},
    {116, 1, 18079ULL, 5},
    {117, 1, 35849ULL, 6},
    {118, 1, 35545ULL, 6},
    {119, 3, 4956ULL, 6},
    {120, 1, 34953ULL, 6},
    {121, 1, 4333ULL, 3},
    {122, 1, 8595ULL, 4},
    {123, 3, 2664ULL, 6},
    {124, 3, 2114ULL, 6},
    {125, 3, 1572ULL, 6},
    {126, 3, 1040ULL, 6},
    {127, 3, 516ULL, 6},
    {128, 0, 0, 7},
    {129, 1, 16257ULL, 5},
    {130, 1, 4033ULL, 3},
    {131, 1, 16009ULL, 5},
    {132, 1, 63551ULL, 7},
    {133, 1, 63073ULL, 7},
    {134, 1, 31301ULL, 6},
    {135, 1, 31069ULL, 6},
    {136, 1, 61681ULL, 7},
    {137, 1, 61231ULL, 7},
    {138, 3, 56038ULL, 7},
    {139, 1, 30175ULL, 6},
    {140, 1, 59919ULL, 7},
    {141, 1, 29747ULL, 6},
    {142, 1, 59075ULL, 7},
    {143, 1, 29331ULL, 6},
    {144, 1, 58255ULL, 7},
    {145, 1, 57853ULL, 7},
    {146, 1, 57457ULL, 7},
    {147, 1, 28533ULL, 6},
    {148, 1, 7085ULL, 4},
    {149, 1, 14075ULL, 5},
    {150, 3, 46312ULL, 7},
    {151, 1, 27777ULL, 6},
    {152, 1, 55189ULL, 7},
    {153, 1, 13707ULL, 5},
    {154, 1, 6809ULL, 4},
    {155, 3, 42704ULL, 7},
    {156, 3, 42010ULL, 7},
    {157, 1, 53431ULL, 7},
    {158, 1, 53093ULL, 7},
    {159, 1, 52759ULL, 7},
    {160, 1, 52429ULL, 7},
    {161, 3, 38670ULL, 7},
    {162, 1, 25891ULL, 6},
    {163, 1, 6433ULL, 4},
    {164, 3, 36764ULL, 7},
    {165, 3, 36144ULL, 7},
    {166, 1, 25267ULL, 6},
    {167, 3, 34926ULL, 7},
    {168, 3, 34328ULL, 7},
    {169, 1, 49637ULL, 7},
    {170, 1, 49345ULL, 7},
    {171, 3, 32576ULL, 7},
    {172, 1, 48771ULL, 7},
    {173, 3, 31442ULL, 7},
    {174, 1, 48211ULL, 7},
    {175, 1, 47935ULL, 7},
    {176, 1, 47663ULL, 7},
    {177, 3, 29250ULL, 7},
    {178, 3, 28718ULL, 7},
    {179, 1, 2929ULL, 3},
    {180, 1, 11651ULL, 5},
    {181, 1, 23173ULL, 6},
    {182, 3, 26646ULL, 7},
    {183, 1, 2865ULL, 3},
    {184, 3, 25644ULL, 7},
    {185, 1, 1417ULL, 2},
    {186, 3, 24664ULL, 7},
    {187, 1, 44859ULL, 7},
    {188, 3, 23704ULL, 7},
    {189, 3, 23232ULL, 7},
    {190, 1, 44151ULL, 7},
    {191, 1, 2745ULL, 3},
    {192, 1, 43691ULL, 7},
    {193, 3, 21392ULL, 7},
    {194, 3, 20944ULL, 7},
    {195, 1, 43019ULL, 7},
    {196, 3, 20062ULL, 7},
    {197, 1, 21291ULL, 6},
    {198, 1, 42367ULL, 7},
    {199, 1, 21077ULL, 6},
    {200, 3, 18350ULL, 7},
    {201, 1, 41735ULL, 7},
    {202, 1, 5191ULL, 4},
    {203, 3, 17110ULL, 7},
    {204, 1, 41121ULL, 7},
    {205, 3, 16304ULL, 7},
    {206, 1, 20361ULL, 6},
    {207, 1, 40525ULL, 7},
    {208, 1, 20165ULL, 6},
    {209, 1, 40137ULL, 7},
    {210, 1, 19973ULL, 6},
    {211, 1, 39757ULL, 7},
    {212, 1, 39569ULL, 7},
    {213, 3, 13230ULL, 7},
    {214, 3, 12862ULL, 7},
    {215, 1, 39017ULL, 7},
    {216, 3, 12136ULL, 7},
    {217, 3, 11778ULL, 7},
    {218, 1, 2405ULL, 3},
    {219, 3, 11072ULL, 7},
    {220, 3, 10724ULL, 7},
    {221, 1, 18979ULL, 6},
    {222, 1, 37787ULL, 7},
    {223, 3, 9698ULL, 7},
    {224, 3, 9362ULL, 7},
    {225, 1, 37283ULL, 7},
    {226, 1, 18559ULL, 6},
    {227, 3, 8372ULL, 7},
    {228, 3, 8048ULL, 7},
    {229, 1, 4579ULL, 4},
    {230, 3, 7408ULL, 7},
    {231, 3, 7092ULL, 7},
    {232, 1, 18079ULL, 6},
    {233, 1, 36003ULL, 7},
    {234, 1, 35849ULL, 7},
    {235, 3, 5856ULL, 7},
    {236, 1, 35545ULL, 7},
    {237, 1, 35395ULL, 7},
    {238, 3, 4956ULL, 7},
    {239, 1, 35099ULL, 7},
    {240, 1, 34953ULL, 7},
    {241, 1, 4351ULL, 4},
    {242, 1, 4333ULL, 4},
    {243, 3, 3506ULL, 7},
    {244, 1, 8595ULL, 5},
    {245, 3, 2942ULL, 7},
    {246, 3, 2664ULL, 7},
    {247, 1, 16981ULL, 6},
    {248, 3, 2114ULL, 7},
    {249, 3, 1842ULL, 7},
    {250, 3, 1572ULL, 7},
    {251, 1, 33421ULL, 7},
    {252, 3, 1040ULL, 7},
    {253, 1, 33157ULL, 7},
    {254, 3, 516ULL, 7},
    {255, 1, 32897ULL, 7},
};
const int64_t table_s16[256][4] = {
    {256, 1, 32769LL, 7},
    {1, 0, 0, 0},
    {2, 0, 0, 1},
    {3, 1, 43691LL, 1},
    {4, 0, 0, 2},
    {5, 1, 52429LL, 2},
    {6, 1, 43691LL, 2},
    {7, 1, 37450LL, 2},
    {8, 0, 0, 3},
    {9, 1, 58255LL, 3},
    {10, 1, 52429LL, 3},
    {11, 1, 47663LL, 3},
    {12, 1, 43691LL, 3},
    {13, 1, 40330LL, 3},
    {14, 1, 37450LL, 3},
    {15, 1, 34953LL, 3},
    {16, 0, 0, 4},
    {17, 1, 61681LL, 4},
    {18, 1, 58255LL, 4},
    {19, 1, 55189LL, 4},
    {20, 1, 52429LL, 4},
    {21, 1, 49933LL, 4},
    {22, 1, 47663LL, 4},
    {23, 1, 45591LL, 4},
    {24, 1, 43691LL, 4},
    {25, 1, 41944LL, 4},
    {26, 1, 40330LL, 4},
    {27, 1, 38837LL, 4},
    {28, 1, 37450LL, 4},
    {29, 1, 36158LL, 4},
    {30, 1, 34953LL, 4},
    {31, 1, 33826LL, 4},
    {32, 0, 0, 5},
    {33, 1, 63551LL, 5},
    {34, 1, 61681LL, 5},
    {35, 1, 59919LL, 5},
    {36, 1, 58255LL, 5},
    {37, 1, 56680LL, 5},
    {38, 1, 55189LL, 5},
    {39, 1, 53774LL, 5},
    {40, 1, 52429LL, 5},
    {41, 1, 51151LL, 5},
    {42, 1, 49933LL, 5},
    {43, 1, 48771LL, 5},
    {44, 1, 47663LL, 5},
    {45, 1, 46604LL, 5},
    {46, 1, 45591LL, 5},
    {47, 1, 44621LL, 5},
    {48, 1, 43691LL, 5},
    {49, 1, 42800LL, 5},
    {50, 1, 41944LL, 5},
    {51, 1, 41121LL, 5},
    {52, 1, 40330LL, 5},
    {53, 1, 39569LL, 5},
    {54, 1, 38837LL, 5},
    {55, 1, 38131LL, 5},
    {56, 1, 37450LL, 5},
    {57, 1, 36793LL, 5},
    {58, 1, 36158LL, 5},
    {59, 1, 35545LL, 5},
    {60, 1, 34953LL, 5},
    {61, 1, 34380LL, 5},
    {62, 1, 33826LL, 5},
    {63, 1, 33289LL, 5},
    {64, 0, 0, 6},
    {65, 1, 64528LL, 6},
    {66, 1, 63551LL, 6},
    {67, 1, 62602LL, 6},
    {68, 1, 61681LL, 6},
    {69, 1, 60788LL, 6},
    {70, 1, 59919LL, 6},
    {71, 1, 59075LL, 6},
    {72, 1, 58255LL, 6},
    {73, 1, 57457LL, 6},
    {74, 1, 56680LL, 6},
    {75, 1, 55925LL, 6},
    {76, 1, 55189LL, 6},
    {77, 1, 54472LL, 6},
    {78, 1, 53774LL, 6},
    {79, 1, 53093LL, 6},
    {80, 1, 52429LL, 6},
    {81, 1, 51782LL, 6},
    {82, 1, 51151LL, 6},
    {83, 1, 50534LL, 6},
    {84, 1, 49933LL, 6},
    {85, 1, 49345LL, 6},
    {86, 1, 48771LL, 6},
    {87, 1, 48211LL, 6},
    {88, 1, 47663LL, 6},
    {89, 1, 47128LL, 6},
    {90, 1, 46604LL, 6},
    {91, 1, 46092LL, 6},
    {92, 1, 45591LL, 6},
    {93, 1, 45101LL, 6},
    {94, 1, 44621LL, 6},
    {95, 1, 44151LL, 6},
    {96, 1, 43691LL, 6},
    {97, 1, 43241LL, 6},
    {98, 1, 42800LL, 6},
    {99, 1, 42367LL, 6},
    {100, 1, 41944LL, 6},
    {101, 1, 41528LL, 6},
    {102, 1, 41121LL, 6},
    {103, 1, 40722LL, 6},
    {104, 1, 40330LL, 6},
    {105, 1, 39946LL, 6},
    {106, 1, 39569LL, 6},
    {107, 1, 39200LL, 6},
    {108, 1, 38837LL, 6},
    {109, 1, 38480LL, 6},
    {110, 1, 38131LL, 6},
    {111, 1, 37787LL, 6},
    {112, 1, 37450LL, 6},
    {113, 1, 37118LL, 6},
    {114, 1, 36793LL, 6},
    {115, 1, 36473LL, 6},
    {116, 1, 36158LL, 6},
    {117, 1, 35849LL, 6},
    {118, 1, 35545LL, 6},
    {119, 1, 35247LL, 6},
    {120, 1, 34953LL, 6},
    {121, 1, 34664LL, 6},
    {122, 1, 34380LL, 6},
    {123, 1, 34101LL, 6},
    {124, 1, 33826LL, 6},
    {125, 1, 33555LL, 6},
    {126, 1, 33289LL, 6},
    {127, 1, 33027LL, 6},
    {128, 0, 0, 7},
    {129, 1, 65028LL, 7},
    {130, 1, 64528LL, 7},
    {131, 1, 64036LL, 7},
    {132, 1, 63551LL, 7},
    {133, 1, 63073LL, 7},
    {134, 1, 62602LL, 7},
    {135, 1, 62138LL, 7},
    {136, 1, 61681LL, 7},
    {137, 1, 61231LL, 7},
    {138, 1, 60788LL, 7},
    {139, 1, 60350LL, 7},
    {140, 1, 59919LL, 7},
    {141, 1, 59494LL, 7},
    {142, 1, 59075LL, 7},
    {143, 1, 58662LL, 7},
    {144, 1, 58255LL, 7},
    {145, 1, 57853LL, 7},
    {146, 1, 57457LL, 7},
    {147, 1, 57066LL, 7},
    {148, 1, 56680LL, 7},
    {149, 1, 56300LL, 7},
    {150, 1, 55925LL, 7},
    {151, 1, 55554LL, 7},
    {152, 1, 55189LL, 7},
    {153, 1, 54828LL, 7},
    {154, 1, 54472LL, 7},
    {155, 1, 54121LL, 7},
    {156, 1, 53774LL, 7},
    {157, 1, 53431LL, 7},
    {158, 1, 53093LL, 7},
    {159, 1, 52759LL, 7},
    {160, 1, 52429LL, 7},
    {161, 1, 52104LL, 7},
    {162, 1, 51782LL, 7},
    {163, 1, 51464LL, 7},
    {164, 1, 51151LL, 7},
    {165, 1, 50841LL, 7},
    {166, 1, 50534LL, 7},
    {167, 1, 50232LL, 7},
    {168, 1, 49933LL, 7},
    {169, 1, 49637LL, 7},
    {170, 1, 49345LL, 7},
    {171, 1, 49057LL, 7},
    {172, 1, 48771LL, 7},
    {173, 1, 48490LL, 7},
    {174, 1, 48211LL, 7},
    {175, 1, 47935LL, 7},
    {176, 1, 47663LL, 7},
    {177, 1, 47394LL, 7},
    {178, 1, 47128LL, 7},
    {179, 1, 46864LL, 7},
    {180, 1, 46604LL, 7},
    {181, 1, 46346LL, 7},
    {182, 1, 46092LL, 7},
    {183, 1, 45840LL, 7},
    {184, 1, 45591LL, 7},
    {185, 1, 45344LL, 7},
    {186, 1, 45101LL, 7},
    {187, 1, 44859LL, 7},
    {188, 1, 44621LL, 7},
    {189, 1, 44385LL, 7},
    {190, 1, 44151LL, 7},
    {191, 1, 43920LL, 7},
    {192, 1, 43691LL, 7},
    {193, 1, 43465LL, 7},
    {194, 1, 43241LL, 7},
    {195, 1, 43019LL, 7},
    {196, 1, 42800LL, 7},
    {197, 1, 42582LL, 7},
    {198, 1, 42367LL, 7},
    {199, 1, 42154LL, 7},
    {200, 1, 41944LL, 7},
    {201, 1, 41735LL, 7},
    {202, 1, 41528LL, 7},
    {203, 1, 41324LL, 7},
    {204, 1, 41121LL, 7},
    {205, 1, 40921LL, 7},
    {206, 1, 40722LL, 7},
    {207, 1, 40525LL, 7},
    {208, 1, 40330LL, 7},
    {209, 1, 40137LL, 7},
    {210, 1, 39946LL, 7},
    {211, 1, 39757LL, 7},
    {212, 1, 39569LL, 7},
    {213, 1, 39384LL, 7},
    {214, 1, 39200LL, 7},
    {215, 1, 39017LL, 7},
    {216, 1, 38837LL, 7},
    {217, 1, 38658LL, 7},
    {218, 1, 38480LL, 7},
    {219, 1, 38305LL, 7},
    {220, 1, 38131LL, 7},
    {221, 1, 37958LL, 7},
    {222, 1, 37787LL, 7},
    {223, 1, 37618LL, 7},
    {224, 1, 37450LL, 7},
    {225, 1, 37283LL, 7},
    {226, 1, 37118LL, 7},
    {227, 1, 36955LL, 7},
    {228, 1, 36793LL, 7},
    {229, 1, 36632LL, 7},
    {230, 1, 36473LL, 7},
    {231, 1, 36315LL, 7},
    {232, 1, 36158LL, 7},
    {233, 1, 36003LL, 7},
    {234, 1, 35849LL, 7},
    {235, 1, 35697LL, 7},
    {236, 1, 35545LL, 7},
    {237, 1, 35395LL, 7},
    {238, 1, 35247LL, 7},
    {239, 1, 35099LL, 7},
    {240, 1, 34953LL, 7},
    {241, 1, 34808LL, 7},
    {242, 1, 34664LL, 7},
    {243, 1, 34522LL, 7},
    {244, 1, 34380LL, 7},
    {245, 1, 34240LL, 7},
    {246, 1, 34101LL, 7},
    {247, 1, 33962LL, 7},
    {248, 1, 33826LL, 7},
    {249, 1, 33690LL, 7},
    {250, 1, 33555LL, 7},
    {251, 1, 33421LL, 7},
    {252, 1, 33289LL, 7},
    {253, 1, 33157LL, 7},
    {254, 1, 33027LL, 7},
    {255, 1, 32897LL, 7},
};
const int64_t table_srz16[256][4] = {
    {256, 1, 32769LL, 7},
    {1, 0, 0, 0},
    {2, 0, 0, 1},
    {3, 1, 43691LL, 1},
    {4, 0, 0, 2},
    {5, 1, 52429LL, 2},
    {6, 1, 43691LL, 2},
    {7, 1, 37450LL, 2},
    {8, 0, 0, 3},
    {9, 1, 58255LL, 3},
    {10, 1, 52429LL, 3},
    {11, 1, 47663LL, 3},
    {12, 1, 43691LL, 3},
    {13, 1, 40330LL, 3},
    {14, 1, 37450LL, 3},
    {15, 1, 34953LL, 3},
    {16, 0, 0, 4},
    {17, 1, 61681LL, 4},
    {18, 1, 58255LL, 4},
    {19, 1, 55189LL, 4},
    {20, 1, 52429LL, 4},
    {21, 1, 49933LL, 4},
    {22, 1, 47663LL, 4},
    {23, 1, 45591LL, 4},
    {24, 1, 43691LL, 4},
    {25, 1, 41944LL, 4},
    {26, 1, 40330LL, 4},
    {27, 1, 38837LL, 4},
    {28, 1, 37450LL, 4},
    {29, 1, 36158LL, 4},
    {30, 1, 34953LL, 4},
    {31, 1, 33826LL, 4},
    {32, 0, 0, 5},
    {33, 1, 63551LL, 5},
    {34, 1, 61681LL, 5},
    {35, 1, 59919LL, 5},
    {36, 1, 58255LL, 5},
    {37, 1, 56680LL, 5},
    {38, 1, 55189LL, 5},
    {39, 1, 53774LL, 5},
    {40, 1, 52429LL, 5},
    {41, 1, 51151LL, 5},
    {42, 1, 49933LL, 5},
    {43, 1, 48771LL, 5},
    {44, 1, 47663LL, 5},
    {45, 1, 46604LL, 5},
    {46, 1, 45591LL, 5},
    {47, 1, 44621LL, 5},
    {48, 1, 43691LL, 5},
    {49, 1, 42800LL, 5},
    {50, 1, 41944LL, 5},
    {51, 1, 41121LL, 5},
    {52, 1, 40330LL, 5},
    {53, 1, 39569LL, 5},
    {54, 1, 38837LL, 5},
    {55, 1, 38131LL, 5},
    {56, 1, 37450LL, 5},
    {57, 1, 36793LL, 5},
    {58, 1, 36158LL, 5},
    {59, 1, 35545LL, 5},
    {60, 1, 34953LL, 5},
    {61, 1, 34380LL, 5},
    {62, 1, 33826LL, 5},
    {63, 1, 33289LL, 5},
    {64, 0, 0, 6},
    {65, 1, 64528LL, 6},
    {66, 1, 63551LL, 6},
    {67, 1, 62602LL, 6},
    {68, 1, 61681LL, 6},
    {69, 1, 60788LL, 6},
    {70, 1, 59919LL, 6},
    {71, 1, 59075LL, 6},
    {72, 1, 58255LL, 6},
    {73, 1, 57457LL, 6},
    {74, 1, 56680LL, 6},
    {75, 1, 55925LL, 6},
    {76, 1, 55189LL, 6},
    {77, 1, 54472LL, 6},
    {78, 1, 53774LL, 6},
    {79, 1, 53093LL, 6},
    {80, 1, 52429LL, 6},
    {81, 1, 51782LL, 6},
    {82, 1, 51151LL, 6},
    {83, 1, 50534LL, 6},
    {84, 1, 49933LL, 6},
    {85, 1, 49345LL, 6},
    {86, 1, 48771LL, 6},
    {87, 1, 48211LL, 6},
    {88, 1, 47663LL, 6},
    {89, 1, 47128LL, 6},
    {90, 1, 46604LL, 6},
    {91, 1, 46092LL, 6},
    {92, 1, 45591LL, 6},
    {93, 1, 45101LL, 6},
    {94, 1, 44621LL, 6},
    {95, 1, 44151LL, 6},
    {96, 1, 43691LL, 6},
    {97, 1, 43241LL, 6},
    {98, 1, 42800LL, 6},
    {99, 1, 42367LL, 6},
    {100, 1, 41944LL, 6},
    {101, 1, 41528LL, 6},
    {102, 1, 41121LL, 6},
    {103, 1, 40722LL, 6},
    {104, 1, 40330LL, 6},
    {105, 1, 39946LL, 6},
    {106, 1, 39569LL, 6},
    {107, 1, 39200LL, 6},
    {108, 1, 38837LL, 6},
    {109, 1, 38480LL, 6},
    {110, 1, 38131LL, 6},
    {111, 1, 37787LL, 6},
    {112, 1, 37450LL, 6},
    {113, 1, 37118LL, 6},
    {114, 1, 36793LL, 6},
    {115, 1, 36473LL, 6},
    {116, 1, 36158LL, 6},
    {117, 1, 35849LL, 6},
    {118, 1, 35545LL, 6},
    {119, 1, 35247LL, 6},
    {120, 1, 34953LL, 6},
    {121, 1, 34664LL, 6},
    {122, 1, 34380LL, 6},
    {123, 1, 34101LL, 6},
    {124, 1, 33826LL, 6},
    {125, 1, 33555LL, 6},
    {126, 1, 33289LL, 6},
    {127, 1, 33027LL, 6},
    {128, 0, 0, 7},
    {129, 1, 65028LL, 7},
    {130, 1, 64528LL, 7},
    {131, 1, 64036LL, 7},
    {132, 1, 63551LL, 7},
    {133, 1, 63073LL, 7},
    {134, 1, 62602LL, 7},
    {135, 1, 62138LL, 7},
    {136, 1, 61681LL, 7},
    {137, 1, 61231LL, 7},
    {138, 1, 60788LL, 7},
    {139, 1, 60350LL, 7},
    {140, 1, 59919LL, 7},
    {141, 1, 59494LL, 7},
    {142, 1, 59075LL, 7},
    {143, 1, 58662LL, 7},
    {144, 1, 58255LL, 7},
    {145, 1, 57853LL, 7},
    {146, 1, 57457LL, 7},
    {147, 1, 57066LL, 7},
    {148, 1, 56680LL, 7},
    {149, 1, 56300LL, 7},
    {150, 1, 55925LL, 7},
    {151, 1, 55554LL, 7},
    {152, 1, 55189LL, 7},
    {153, 1, 54828LL, 7},
    {154, 1, 54472LL, 7},
    {155, 1, 54121LL, 7},
    {156, 1, 53774LL, 7},
    {157, 1, 53431LL, 7},
    {158, 1, 53093LL, 7},
    {159, 1, 52759LL, 7},
    {160, 1, 52429LL, 7},
    {161, 1, 52104LL, 7},
    {162, 1, 51782LL, 7},
    {163, 1, 51464LL, 7},
    {164, 1, 51151LL, 7},
    {165, 1, 50841LL, 7},
    {166, 1, 50534LL, 7},
    {167, 1, 50232LL, 7},
    {168, 1, 49933LL, 7},
    {169, 1, 49637LL, 7},
    {170, 1, 49345LL, 7},
    {171, 1, 49057LL, 7},
    {172, 1, 48771LL, 7},
    {173, 1, 48490LL, 7},
    {174, 1, 48211LL, 7},
    {175, 1, 47935LL, 7},
    {176, 1, 47663LL, 7},
    {177, 1, 47394LL, 7},
    {178, 1, 47128LL, 7},
    {179, 1, 46864LL, 7},
    {180, 1, 46604LL, 7},
    {181, 1, 46346LL, 7},
    {182, 1, 46092LL, 7},
    {183, 1, 45840LL, 7},
    {184, 1, 45591LL, 7},
    {185, 1, 45344LL, 7},
    {186, 1, 45101LL, 7},
    {187, 1, 44859LL, 7},
    {188, 1, 44621LL, 7},
    {189, 1, 44385LL, 7},
    {190, 1, 44151LL, 7},
    {191, 1, 43920LL, 7},
    {192, 1, 43691LL, 7},
    {193, 1, 43465LL, 7},
    {194, 1, 43241LL, 7},
    {195, 1, 43019LL, 7},
    {196, 1, 42800LL, 7},
    {197, 1, 42582LL, 7},
    {198, 1, 42367LL, 7},
    {199, 1, 42154LL, 7},
    {200, 1, 41944LL, 7},
    {201, 1, 41735LL, 7},
    {202, 1, 41528LL, 7},
    {203, 1, 41324LL, 7},
    {204, 1, 41121LL, 7},
    {205, 1, 40921LL, 7},
    {206, 1, 40722LL, 7},
    {207, 1, 40525LL, 7},
    {208, 1, 40330LL, 7},
    {209, 1, 40137LL, 7},
    {210, 1, 39946LL, 7},
    {211, 1, 39757LL, 7},
    {212, 1, 39569LL, 7},
    {213, 1, 39384LL, 7},
    {214, 1, 39200LL, 7},
    {215, 1, 39017LL, 7},
    {216, 1, 38837LL, 7},
    {217, 1, 38658LL, 7},
    {218, 1, 38480LL, 7},
    {219, 1, 38305LL, 7},
    {220, 1, 38131LL, 7},
    {221, 1, 37958LL, 7},
    {222, 1, 37787LL, 7},
    {223, 1, 37618LL, 7},
    {224, 1, 37450LL, 7},
    {225, 1, 37283LL, 7},
    {226, 1, 37118LL, 7},
    {227, 1, 36955LL, 7},
    {228, 1, 36793LL, 7},
    {229, 1, 36632LL, 7},
    {230, 1, 36473LL, 7},
    {231, 1, 36315LL, 7},
    {232, 1, 36158LL, 7},
    {233, 1, 36003LL, 7},
    {234, 1, 35849LL, 7},
    {235, 1, 35697LL, 7},
    {236, 1, 35545LL, 7},
    {237, 1, 35395LL, 7},
    {238, 1, 35247LL, 7},
    {239, 1, 35099LL, 7},
    {240, 1, 34953LL, 7},
    {241, 1, 34808LL, 7},
    {242, 1, 34664LL, 7},
    {243, 1, 34522LL, 7},
    {244, 1, 34380LL, 7},
    {245, 1, 34240LL, 7},
    {246, 1, 34101LL, 7},
    {247, 1, 33962LL, 7},
    {248, 1, 33826LL, 7},
    {249, 1, 33690LL, 7},
    {250, 1, 33555LL, 7},
    {251, 1, 33421LL, 7},
    {252, 1, 33289LL, 7},
    {253, 1, 33157LL, 7},
    {254, 1, 33027LL, 7},
    {255, 1, 32897LL, 7},
};
const int64_t table_u32[256][4] = {
    {256, 0, 0, 8},
    {1, 0, 0, 0},
    {2, 0, 0, 1},
    {3, 1, 2863311531ULL, 1},
    {4, 0, 0, 2},
    {5, 1, 3435973837ULL, 2},
    {6, 1, 2863311531ULL, 2},
    {7, 3, 613566756ULL, 2},
    {8, 0, 0, 3},
    {9, 1, 954437177ULL, 1},
    {10, 1, 3435973837ULL, 3},
    {11, 1, 3123612579ULL, 3},
    {12, 1, 2863311531ULL, 3},
    {13, 1, 1321528399ULL, 2},
    {14, 3, 613566756ULL, 3},
    {15, 1, 2290649225ULL, 3},
    {16, 0, 0, 4},
    {17, 1, 4042322161ULL, 4},
    {18, 1, 954437177ULL, 2},
    {19, 3, 2938661834ULL, 4},
    {20, 1, 3435973837ULL, 4},
    {21, 3, 2249744774ULL, 4},
    {22, 1, 3123612579ULL, 4},
    {23, 1, 2987803337ULL, 4},
    {24, 1, 2863311531ULL, 4},
    {25, 1, 1374389535ULL, 3},
    {26, 1, 1321528399ULL, 3},
    {27, 3, 795364314ULL, 4},
    {28, 3, 613566756ULL, 4},
    {29, 1, 2369637129ULL, 4},
    {30, 1, 2290649225ULL, 4},
    {31, 3, 138547332ULL, 4},
    {32, 0, 0, 5},
    {33, 1, 1041204193ULL, 3},
    {34, 1, 4042322161ULL, 5},
    {35, 3, 3558687188ULL, 5},
    {36, 1, 954437177ULL, 3},
    {37, 3, 3134165324ULL, 5},
    {38, 3, 2938661834ULL, 5},
    {39, 3, 2753184164ULL, 5},
    {40, 1, 3435973837ULL, 5},
    {41, 1, 3352169597ULL, 5},
    {42, 3, 2249744774ULL, 5},
    {43, 1, 799063683ULL, 3},
    {44, 1, 3123612579ULL, 5},
    {45, 3, 1813430636ULL, 5},
    {46, 1, 2987803337ULL, 5},
    {47, 1, 2924233053ULL, 5},
    {48, 1, 2863311531ULL, 5},
    {49, 1, 1402438301ULL, 4},
    {50, 1, 1374389535ULL, 4},
    {51, 1, 2694881441ULL, 5},
    {52, 1, 1321528399ULL, 4},
    {53, 3, 891408306ULL, 5},
    {54, 3, 795364314ULL, 5},
    {55, 3, 702812830ULL, 5},
    {56, 3, 613566756ULL, 5},
    {57, 3, 527452124ULL, 5},
    {58, 1, 2369637129ULL, 5},
    {59, 1, 582368447ULL, 3},
    {60, 1, 2290649225ULL, 5},
    {61, 1, 1126548799ULL, 4},
    {62, 3, 138547332ULL, 5},
    {63, 3, 68174084ULL, 5},
    {64, 0, 0, 6},
    {65, 1, 4228890877ULL, 6},
    {66, 1, 1041204193ULL, 4},
    {67, 1, 128207979ULL, 1},
    {68, 1, 4042322161ULL, 6},
    {69, 1, 1991868891ULL, 5},
    {70, 3, 3558687188ULL, 6},
    {71, 1, 3871519817ULL, 6},
    {72, 1, 954437177ULL, 4},
    {73, 3, 3235934264ULL, 6},
    {74, 3, 3134165324ULL, 6},
    {75, 1, 458129845ULL, 3},
    {76, 3, 2938661834ULL, 6},
    {77, 1, 892460737ULL, 4},
    {78, 3, 2753184164ULL, 6},
    {79, 1, 3479467177ULL, 6},
    {80, 1, 3435973837ULL, 6},
    {81, 1, 3393554407ULL, 6},
    {82, 1, 3352169597ULL, 6},
    {83, 1, 827945503ULL, 4},
    {84, 3, 2249744774ULL, 6},
    {85, 1, 3233857729ULL, 6},
    {86, 1, 799063683ULL, 4},
    {87, 1, 789879043ULL, 4},
    {88, 1, 3123612579ULL, 6},
    {89, 1, 3088515809ULL, 6},
    {90, 3, 1813430636ULL, 6},
    {91, 3, 1746305384ULL, 6},
    {92, 1, 2987803337ULL, 6},
    {93, 1, 2955676419ULL, 6},
    {94, 1, 2924233053ULL, 6},
    {95, 3, 1491936008ULL, 6},
    {96, 1, 2863311531ULL, 6},
    {97, 3, 1372618414ULL, 6},
    {98, 1, 1402438301ULL, 5},
    {99, 1, 2776544515ULL, 6},
    {100, 1, 1374389535ULL, 5},
    {101, 3, 1148159574ULL, 6},
    {102, 1, 2694881441ULL, 6},
    {103, 3, 1042467790ULL, 6},
    {104, 1, 1321528399ULL, 5},
    {105, 3, 940802360ULL, 6},
    {106, 3, 891408306ULL, 6},
    {107, 3, 842937506ULL, 6},
    {108, 3, 795364314ULL, 6},
    {109, 3, 748664024ULL, 6},
    {110, 3, 702812830ULL, 6},
    {111, 3, 657787784ULL, 6},
    {112, 3, 613566756ULL, 6},
    {113, 3, 570128402ULL, 6},
    {114, 3, 527452124ULL, 6},
    {115, 3, 485518042ULL, 6},
    {116, 1, 2369637129ULL, 6},
    {117, 3, 403800344ULL, 6},
    {118, 1, 582368447ULL, 4},
    {119, 1, 1154949189ULL, 5},
    {120, 1, 2290649225ULL, 6},
    {121, 3, 248469182ULL, 6},
    {122, 1, 1126548799ULL, 5},
    {123, 3, 174592166ULL, 6},
    {124, 3, 138547332ULL, 6},
    {125, 1, 274877907ULL, 3},
    {126, 3, 68174084ULL, 6},
    {127, 3, 33818640ULL, 6},
    {128, 0, 0, 7},
    {129, 1, 266354561ULL, 3},
    {130, 1, 4228890877ULL, 7},
    {131, 1, 4196609267ULL, 7},
    {132, 1, 1041204193ULL, 5},
    {133, 1, 4133502361ULL, 7},
    {134, 1, 128207979ULL, 2},
    {135, 1, 4072265289ULL, 7},
    {136, 1, 4042322161ULL, 7},
    {137, 1, 125400505ULL, 2},
    {138, 1, 1991868891ULL, 6},
    {139, 1, 1977538899ULL, 6},
    {140, 3, 3558687188ULL, 7},
    {141, 1, 974744351ULL, 5},
    {142, 1, 3871519817ULL, 7},
    {143, 1, 3844446251ULL, 7},
    {144, 1, 954437177ULL, 5},
    {145, 1, 3791419407ULL, 7},
    {146, 3, 3235934264ULL, 7},
    {147, 1, 3739835469ULL, 7},
    {148, 3, 3134165324ULL, 7},
    {149, 1, 3689636335ULL, 7},
    {150, 1, 458129845ULL, 4},
    {151, 1, 910191745ULL, 5},
    {152, 3, 2938661834ULL, 7},
    {153, 1, 3593175255ULL, 7},
    {154, 1, 892460737ULL, 5},
    {155, 1, 3546811703ULL, 7},
    {156, 3, 2753184164ULL, 7},
    {157, 1, 875407347ULL, 5},
    {158, 1, 3479467177ULL, 7},
    {159, 3, 2620200174ULL, 7},
    {160, 1, 3435973837ULL, 7},
    {161, 1, 3414632385ULL, 7},
    {162, 1, 3393554407ULL, 7},
    {163, 1, 3372735055ULL, 7},
    {164, 1, 3352169597ULL, 7},
    {165, 1, 1665926709ULL, 6},
    {166, 1, 827945503ULL, 5},
    {167, 1, 1645975491ULL, 6},
    {168, 3, 2249744774ULL, 7},
    {169, 1, 1626496491ULL, 6},
    {170, 1, 3233857729ULL, 7},
    {171, 3, 2134925264ULL, 7},
    {172, 1, 799063683ULL, 5},
    {173, 3, 2060591246ULL, 7},
    {174, 1, 789879043ULL, 5},
    {175, 1, 1570730897ULL, 6},
    {176, 1, 3123612579ULL, 7},
    {177, 3, 1916962804ULL, 7},
    {178, 1, 3088515809ULL, 7},
    {179, 3, 1847555764ULL, 7},
    {180, 3, 1813430636ULL, 7},
    {181, 1, 3037324939ULL, 7},
    {182, 3, 1746305384ULL, 7},
    {183, 1, 3004130131ULL, 7},
    {184, 1, 2987803337ULL, 7},
    {185, 3, 1648338800ULL, 7},
    {186, 1, 2955676419ULL, 7},
    {187, 1, 2939870663ULL, 7},
    {188, 1, 2924233053ULL, 7},
    {189, 3, 1522554544ULL, 7},
    {190, 3, 1491936008ULL, 7},
    {191, 1, 2878302691ULL, 7},
    {192, 1, 2863311531ULL, 7},
    {193, 1, 356059465ULL, 4},
    {194, 3, 1372618414ULL, 7},
    {195, 3, 1343553872ULL, 7},
    {196, 1, 1402438301ULL, 6},
    {197, 3, 1286310002ULL, 7},
    {198, 1, 2776544515ULL, 7},
    {199, 1, 1381296015ULL, 6},
    {200, 1, 1374389535ULL, 6},
    {201, 1, 42735993ULL, 1},
    {202, 3, 1148159574ULL, 7},
    {203, 1, 2708156719ULL, 7},
    {204, 1, 2694881441ULL, 7},
    {205, 1, 1340867839ULL, 6},
    {206, 3, 1042467790ULL, 7},
    {207, 1, 663956297ULL, 5},
    {208, 1, 1321528399ULL, 6},
    {209, 1, 2630410593ULL, 7},
    {210, 3, 940802360ULL, 7},
    {211, 1, 2605477791ULL, 7},
    {212, 3, 891408306ULL, 7},
    {213, 1, 2581013211ULL, 7},
    {214, 3, 842937506ULL, 7},
    {215, 1, 1278501893ULL, 6},
    {216, 3, 795364314ULL, 7},
    {217, 3, 771906564ULL, 7},
    {218, 3, 748664024ULL, 7},
    {219, 3, 725633744ULL, 7},
    {220, 3, 702812830ULL, 7},
    {221, 3, 680198440ULL, 7},
    {222, 3, 657787784ULL, 7},
    {223, 3, 635578120ULL, 7},
    {224, 3, 613566756ULL, 7},
    {225, 1, 2443359173ULL, 7},
    {226, 3, 570128402ULL, 7},
    {227, 3, 548696262ULL, 7},
    {228, 3, 527452124ULL, 7},
    {229, 1, 1200340205ULL, 6},
    {230, 3, 485518042ULL, 7},
    {231, 3, 464823300ULL, 7},
    {232, 1, 2369637129ULL, 7},
    {233, 3, 423966728ULL, 7},
    {234, 3, 403800344ULL, 7},
    {235, 3, 383805588ULL, 7},
    {236, 1, 582368447ULL, 5},
    {237, 3, 344322272ULL, 7},
    {238, 1, 1154949189ULL, 6},
    {239, 1, 2300233531ULL, 7},
    {240, 1, 2290649225ULL, 7},
    {241, 1, 285143057ULL, 4},
    {242, 3, 248469182ULL, 7},
    {243, 1, 2262369605ULL, 7},
    {244, 1, 1126548799ULL, 6},
    {245, 3, 192835266ULL, 7},
    {246, 3, 174592166ULL, 7},
    {247, 3, 156496784ULL, 7},
    {248, 3, 138547332ULL, 7},
    {249, 3, 120742052ULL, 7},
    {250, 1, 274877907ULL, 4},
    {251, 1, 2190262207ULL, 7},
    {252, 3, 68174084ULL, 7},
    {253, 1, 2172947881ULL, 7},
    {254, 3, 33818640ULL, 7},
    {255, 1, 2155905153ULL, 7},
};
const int64_t table_s32[256][4] = {
    {256, 1, 2147483649LL, 7},
    {1, 0, 0, 0},
    {2, 0, 0, 1},
    {3, 1, 2863311531LL, 1},
    {4, 0, 0, 2},
    {5, 1, 3435973837LL, 2},
    {6, 1, 2863311531LL, 2},
    {7, 1, 2454267027LL, 2},
    {8, 0, 0, 3},
    {9, 1, 3817748708LL, 3},
    {10, 1, 3435973837LL, 3},
    {11, 1, 3123612579LL, 3},
    {12, 1, 2863311531LL, 3},
    {13, 1, 2643056798LL, 3},
    {14, 1, 2454267027LL, 3},
    {15, 1, 2290649225LL, 3},
    {16, 0, 0, 4},
    {17, 1, 4042322161LL, 4},
    {18, 1, 3817748708LL, 4},
    {19, 1, 3616814566LL, 4},
    {20, 1, 3435973837LL, 4},
    {21, 1, 3272356036LL, 4},
    {22, 1, 3123612579LL, 4},
    {23, 1, 2987803337LL, 4},
    {24, 1, 2863311531LL, 4},
    {25, 1, 2748779070LL, 4},
    {26, 1, 2643056798LL, 4},
    {27, 1, 2545165806LL, 4},
    {28, 1, 2454267027LL, 4},
    {29, 1, 2369637129LL, 4},
    {30, 1, 2290649225LL, 4},
    {31, 1, 2216757315LL, 4},
    {32, 0, 0, 5},
    {33, 1, 4164816772LL, 5},
    {34, 1, 4042322161LL, 5},
    {35, 1, 3926827243LL, 5},
    {36, 1, 3817748708LL, 5},
    {37, 1, 3714566311LL, 5},
    {38, 1, 3616814566LL, 5},
    {39, 1, 3524075731LL, 5},
    {40, 1, 3435973837LL, 5},
    {41, 1, 3352169597LL, 5},
    {42, 1, 3272356036LL, 5},
    {43, 1, 3196254732LL, 5},
    {44, 1, 3123612579LL, 5},
    {45, 1, 3054198967LL, 5},
    {46, 1, 2987803337LL, 5},
    {47, 1, 2924233053LL, 5},
    {48, 1, 2863311531LL, 5},
    {49, 1, 2804876602LL, 5},
    {50, 1, 2748779070LL, 5},
    {51, 1, 2694881441LL, 5},
    {52, 1, 2643056798LL, 5},
    {53, 1, 2593187802LL, 5},
    {54, 1, 2545165806LL, 5},
    {55, 1, 2498890064LL, 5},
    {56, 1, 2454267027LL, 5},
    {57, 1, 2411209711LL, 5},
    {58, 1, 2369637129LL, 5},
    {59, 1, 2329473788LL, 5},
    {60, 1, 2290649225LL, 5},
    {61, 1, 2253097598LL, 5},
    {62, 1, 2216757315LL, 5},
    {63, 1, 2181570691LL, 5},
    {64, 0, 0, 6},
    {65, 1, 4228890877LL, 6},
    {66, 1, 4164816772LL, 6},
    {67, 1, 4102655328LL, 6},
    {68, 1, 4042322161LL, 6},
    {69, 1, 3983737782LL, 6},
    {70, 1, 3926827243LL, 6},
    {71, 1, 3871519817LL, 6},
    {72, 1, 3817748708LL, 6},
    {73, 1, 3765450781LL, 6},
    {74, 1, 3714566311LL, 6},
    {75, 1, 3665038760LL, 6},
    {76, 1, 3616814566LL, 6},
    {77, 1, 3569842948LL, 6},
    {78, 1, 3524075731LL, 6},
    {79, 1, 3479467177LL, 6},
    {80, 1, 3435973837LL, 6},
    {81, 1, 3393554407LL, 6},
    {82, 1, 3352169597LL, 6},
    {83, 1, 3311782012LL, 6},
    {84, 1, 3272356036LL, 6},
    {85, 1, 3233857729LL, 6},
    {86, 1, 3196254732LL, 6},
    {87, 1, 3159516172LL, 6},
    {88, 1, 3123612579LL, 6},
    {89, 1, 3088515809LL, 6},
    {90, 1, 3054198967LL, 6},
    {91, 1, 3020636341LL, 6},
    {92, 1, 2987803337LL, 6},
    {93, 1, 2955676419LL, 6},
    {94, 1, 2924233053LL, 6},
    {95, 1, 2893451653LL, 6},
    {96, 1, 2863311531LL, 6},
    {97, 1, 2833792856LL, 6},
    {98, 1, 2804876602LL, 6},
    {99, 1, 2776544515LL, 6},
    {100, 1, 2748779070LL, 6},
    {101, 1, 2721563436LL, 6},
    {102, 1, 2694881441LL, 6},
    {103, 1, 2668717544LL, 6},
    {104, 1, 2643056798LL, 6},
    {105, 1, 2617884829LL, 6},
    {106, 1, 2593187802LL, 6},
    {107, 1, 2568952402LL, 6},
    {108, 1, 2545165806LL, 6},
    {109, 1, 2521815661LL, 6},
    {110, 1, 2498890064LL, 6},
    {111, 1, 2476377541LL, 6},
    {112, 1, 2454267027LL, 6},
    {113, 1, 2432547850LL, 6},
    {114, 1, 2411209711LL, 6},
    {115, 1, 2390242670LL, 6},
    {116, 1, 2369637129LL, 6},
    {117, 1, 2349383821LL, 6},
    {118, 1, 2329473788LL, 6},
    {119, 1, 2309898378LL, 6},
    {120, 1, 2290649225LL, 6},
    {121, 1, 2271718240LL, 6},
    {122, 1, 2253097598LL, 6},
    {123, 1, 2234779732LL, 6},
    {124, 1, 2216757315LL, 6},
    {125, 1, 2199023256LL, 6},
    {126, 1, 2181570691LL, 6},
    {127, 1, 2164392969LL, 6},
    {128, 0, 0, 7},
    {129, 1, 4261672976LL, 7},
    {130, 1, 4228890877LL, 7},
    {131, 1, 4196609267LL, 7},
    {132, 1, 4164816772LL, 7},
    {133, 1, 4133502361LL, 7},
    {134, 1, 4102655328LL, 7},
    {135, 1, 4072265289LL, 7},
    {136, 1, 4042322161LL, 7},
    {137, 1, 4012816160LL, 7},
    {138, 1, 3983737782LL, 7},
    {139, 1, 3955077798LL, 7},
    {140, 1, 3926827243LL, 7},
    {141, 1, 3898977404LL, 7},
    {142, 1, 3871519817LL, 7},
    {143, 1, 3844446251LL, 7},
    {144, 1, 3817748708LL, 7},
    {145, 1, 3791419407LL, 7},
    {146, 1, 3765450781LL, 7},
    {147, 1, 3739835469LL, 7},
    {148, 1, 3714566311LL, 7},
    {149, 1, 3689636335LL, 7},
    {150, 1, 3665038760LL, 7},
    {151, 1, 3640766980LL, 7},
    {152, 1, 3616814566LL, 7},
    {153, 1, 3593175255LL, 7},
    {154, 1, 3569842948LL, 7},
    {155, 1, 3546811703LL, 7},
    {156, 1, 3524075731LL, 7},
    {157, 1, 3501629388LL, 7},
    {158, 1, 3479467177LL, 7},
    {159, 1, 3457583736LL, 7},
    {160, 1, 3435973837LL, 7},
    {161, 1, 3414632385LL, 7},
    {162, 1, 3393554407LL, 7},
    {163, 1, 3372735055LL, 7},
    {164, 1, 3352169597LL, 7},
    {165, 1, 3331853418LL, 7},
    {166, 1, 3311782012LL, 7},
    {167, 1, 3291950982LL, 7},
    {168, 1, 3272356036LL, 7},
    {169, 1, 3252992982LL, 7},
    {170, 1, 3233857729LL, 7},
    {171, 1, 3214946281LL, 7},
    {172, 1, 3196254732LL, 7},
    {173, 1, 3177779272LL, 7},
    {174, 1, 3159516172LL, 7},
    {175, 1, 3141461794LL, 7},
    {176, 1, 3123612579LL, 7},
    {177, 1, 3105965051LL, 7},
    {178, 1, 3088515809LL, 7},
    {179, 1, 3071261531LL, 7},
    {180, 1, 3054198967LL, 7},
    {181, 1, 3037324939LL, 7},
    {182, 1, 3020636341LL, 7},
    {183, 1, 3004130131LL, 7},
    {184, 1, 2987803337LL, 7},
    {185, 1, 2971653049LL, 7},
    {186, 1, 2955676419LL, 7},
    {187, 1, 2939870663LL, 7},
    {188, 1, 2924233053LL, 7},
    {189, 1, 2908760921LL, 7},
    {190, 1, 2893451653LL, 7},
    {191, 1, 2878302691LL, 7},
    {192, 1, 2863311531LL, 7},
    {193, 1, 2848475720LL, 7},
    {194, 1, 2833792856LL, 7},
    {195, 1, 2819260585LL, 7},
    {196, 1, 2804876602LL, 7},
    {197, 1, 2790638650LL, 7},
    {198, 1, 2776544515LL, 7},
    {199, 1, 2762592030LL, 7},
    {200, 1, 2748779070LL, 7},
    {201, 1, 2735103552LL, 7},
    {202, 1, 2721563436LL, 7},
    {203, 1, 2708156719LL, 7},
    {204, 1, 2694881441LL, 7},
    {205, 1, 2681735678LL, 7},
    {206, 1, 2668717544LL, 7},
    {207, 1, 2655825188LL, 7},
    {208, 1, 2643056798LL, 7},
    {209, 1, 2630410593LL, 7},
    {210, 1, 2617884829LL, 7},
    {211, 1, 2605477791LL, 7},
    {212, 1, 2593187802LL, 7},
    {213, 1, 2581013211LL, 7},
    {214, 1, 2568952402LL, 7},
    {215, 1, 2557003786LL, 7},
    {216, 1, 2545165806LL, 7},
    {217, 1, 2533436931LL, 7},
    {218, 1, 2521815661LL, 7},
    {219, 1, 2510300521LL, 7},
    {220, 1, 2498890064LL, 7},
    {221, 1, 2487582869LL, 7},
    {222, 1, 2476377541LL, 7},
    {223, 1, 2465272709LL, 7},
    {224, 1, 2454267027LL, 7},
    {225, 1, 2443359173LL, 7},
    {226, 1, 2432547850LL, 7},
    {227, 1, 2421831780LL, 7},
    {228, 1, 2411209711LL, 7},
    {229, 1, 2400680410LL, 7},
    {230, 1, 2390242670LL, 7},
    {231, 1, 2379895299LL, 7},
    {232, 1, 2369637129LL, 7},
    {233, 1, 2359467013LL, 7},
    {234, 1, 2349383821LL, 7},
    {235, 1, 2339386443LL, 7},
    {236, 1, 2329473788LL, 7},
    {237, 1, 2319644785LL, 7},
    {238, 1, 2309898378LL, 7},
    {239, 1, 2300233531LL, 7},
    {240, 1, 2290649225LL, 7},
    {241, 1, 2281144456LL, 7},
    {242, 1, 2271718240LL, 7},
    {243, 1, 2262369605LL, 7},
    {244, 1, 2253097598LL, 7},
    {245, 1, 2243901282LL, 7},
    {246, 1, 2234779732LL, 7},
    {247, 1, 2225732041LL, 7},
    {248, 1, 2216757315LL, 7},
    {249, 1, 2207854675LL, 7},
    {250, 1, 2199023256LL, 7},
    {251, 1, 2190262207LL, 7},
    {252, 1, 2181570691LL, 7},
    {253, 1, 2172947881LL, 7},
    {254, 1, 2164392969LL, 7},
    {255, 1, 2155905153LL, 7},
};
const int64_t table_srz32[256][4] = {
    {256, 1, 2147483649LL, 7},
    {1, 0, 0, 0},
    {2, 0, 0, 1},
    {3, 1, 2863311531LL, 1},
    {4, 0, 0, 2},
    {5, 1, 3435973837LL, 2},
    {6, 1, 2863311531LL, 2},
    {7, 1, 2454267027LL, 2},
    {8, 0, 0, 3},
    {9, 1, 3817748708LL, 3},
    {10, 1, 3435973837LL, 3},
    {11, 1, 3123612579LL, 3},
    {12, 1, 2863311531LL, 3},
    {13, 1, 2643056798LL, 3},
    {14, 1, 2454267027LL, 3},
    {15, 1, 2290649225LL, 3},
    {16, 0, 0, 4},
    {17, 1, 4042322161LL, 4},
    {18, 1, 3817748708LL, 4},
    {19, 1, 3616814566LL, 4},
    {20, 1, 3435973837LL, 4},
    {21, 1, 3272356036LL, 4},
    {22, 1, 3123612579LL, 4},
    {23, 1, 2987803337LL, 4},
    {24, 1, 2863311531LL, 4},
    {25, 1, 2748779070LL, 4},
    {26, 1, 2643056798LL, 4},
    {27, 1, 2545165806LL, 4},
    {28, 1, 2454267027LL, 4},
    {29, 1, 2369637129LL, 4},
    {30, 1, 2290649225LL, 4},
    {31, 1, 2216757315LL, 4},
    {32, 0, 0, 5},
    {33, 1, 4164816772LL, 5},
    {34, 1, 4042322161LL, 5},
    {35, 1, 3926827243LL, 5},
    {36, 1, 3817748708LL, 5},
    {37, 1, 3714566311LL, 5},
    {38, 1, 3616814566LL, 5},
    {39, 1, 3524075731LL, 5},
    {40, 1, 3435973837LL, 5},
    {41, 1, 3352169597LL, 5},
    {42, 1, 3272356036LL, 5},
    {43, 1, 3196254732LL, 5},
    {44, 1, 3123612579LL, 5},
    {45, 1, 3054198967LL, 5},
    {46, 1, 2987803337LL, 5},
    {47, 1, 2924233053LL, 5},
    {48, 1, 2863311531LL, 5},
    {49, 1, 2804876602LL, 5},
    {50, 1, 2748779070LL, 5},
    {51, 1, 2694881441LL, 5},
    {52, 1, 2643056798LL, 5},
    {53, 1, 2593187802LL, 5},
    {54, 1, 2545165806LL, 5},
    {55, 1, 2498890064LL, 5},
    {56, 1, 2454267027LL, 5},
    {57, 1, 2411209711LL, 5},
    {58, 1, 2369637129LL, 5},
    {59, 1, 2329473788LL, 5},
    {60, 1, 2290649225LL, 5},
    {61, 1, 2253097598LL, 5},
    {62, 1, 2216757315LL, 5},
    {63, 1, 2181570691LL, 5},
    {64, 0, 0, 6},
    {65, 1, 4228890877LL, 6},
    {66, 1, 4164816772LL, 6},
    {67, 1, 4102655328LL, 6},
    {68, 1, 4042322161LL, 6},
    {69, 1, 3983737782LL, 6},
    {70, 1, 3926827243LL, 6},
    {71, 1, 3871519817LL, 6},
    {72, 1, 3817748708LL, 6},
    {73, 1, 3765450781LL, 6},
    {74, 1, 3714566311LL, 6},
    {75, 1, 3665038760LL, 6},
    {76, 1, 3616814566LL, 6},
    {77, 1, 3569842948LL, 6},
    {78, 1, 3524075731LL, 6},
    {79, 1, 3479467177LL, 6},
    {80, 1, 3435973837LL, 6},
    {81, 1, 3393554407LL, 6},
    {82, 1, 3352169597LL, 6},
    {83, 1, 3311782012LL, 6},
    {84, 1, 3272356036LL, 6},
    {85, 1, 3233857729LL, 6},
    {86, 1, 3196254732LL, 6},
    {87, 1, 3159516172LL, 6},
    {88, 1, 3123612579LL, 6},
    {89, 1, 3088515809LL, 6},
    {90, 1, 3054198967LL, 6},
    {91, 1, 3020636341LL, 6},
    {92, 1, 2987803337LL, 6},
    {93, 1, 2955676419LL, 6},
    {94, 1, 2924233053LL, 6},
    {95, 1, 2893451653LL, 6},
    {96, 1, 2863311531LL, 6},
    {97, 1, 2833792856LL, 6},
    {98, 1, 2804876602LL, 6},
    {99, 1, 2776544515LL, 6},
    {100, 1, 2748779070LL, 6},
    {101, 1, 2721563436LL, 6},
    {102, 1, 2694881441LL, 6},
    {103, 1, 2668717544LL, 6},
    {104, 1, 2643056798LL, 6},
    {105, 1, 2617884829LL, 6},
    {106, 1, 2593187802LL, 6},
    {107, 1, 2568952402LL, 6},
    {108, 1, 2545165806LL, 6},
    {109, 1, 2521815661LL, 6},
    {110, 1, 2498890064LL, 6},
    {111, 1, 2476377541LL, 6},
    {112, 1, 2454267027LL, 6},
    {113, 1, 2432547850LL, 6},
    {114, 1, 2411209711LL, 6},
    {115, 1, 2390242670LL, 6},
    {116, 1, 2369637129LL, 6},
    {117, 1, 2349383821LL, 6},
    {118, 1, 2329473788LL, 6},
    {119, 1, 2309898378LL, 6},
    {120, 1, 2290649225LL, 6},
    {121, 1, 2271718240LL, 6},
    {122, 1, 2253097598LL, 6},
    {123, 1, 2234779732LL, 6},
    {124, 1, 2216757315LL, 6},
    {125, 1, 2199023256LL, 6},
    {126, 1, 2181570691LL, 6},
    {127, 1, 2164392969LL, 6},
    {128, 0, 0, 7},
    {129, 1, 4261672976LL, 7},
    {130, 1, 4228890877LL, 7},
    {131, 1, 4196609267LL, 7},
    {132, 1, 4164816772LL, 7},
    {133, 1, 4133502361LL, 7},
    {134, 1, 4102655328LL, 7},
    {135, 1, 4072265289LL, 7},
    {136, 1, 4042322161LL, 7},
    {137, 1, 4012816160LL, 7},
    {138, 1, 3983737782LL, 7},
    {139, 1, 3955077798LL, 7},
    {140, 1, 3926827243LL, 7},
    {141, 1, 3898977404LL, 7},
    {142, 1, 3871519817LL, 7},
    {143, 1, 3844446251LL, 7},
    {144, 1, 3817748708LL, 7},
    {145, 1, 3791419407LL, 7},
    {146, 1, 3765450781LL, 7},
    {147, 1, 3739835469LL, 7},
    {148, 1, 3714566311LL, 7},
    {149, 1, 3689636335LL, 7},
    {150, 1, 3665038760LL, 7},
    {151, 1, 3640766980LL, 7},
    {152, 1, 3616814566LL, 7},
    {153, 1, 3593175255LL, 7},
    {154, 1, 3569842948LL, 7},
    {155, 1, 3546811703LL, 7},
    {156, 1, 3524075731LL, 7},
    {157, 1, 3501629388LL, 7},
    {158, 1, 3479467177LL, 7},
    {159, 1, 3457583736LL, 7},
    {160, 1, 3435973837LL, 7},
    {161, 1, 3414632385LL, 7},
    {162, 1, 3393554407LL, 7},
    {163, 1, 3372735055LL, 7},
    {164, 1, 3352169597LL, 7},
    {165, 1, 3331853418LL, 7},
    {166, 1, 3311782012LL, 7},
    {167, 1, 3291950982LL, 7},
    {168, 1, 3272356036LL, 7},
    {169, 1, 3252992982LL, 7},
    {170, 1, 3233857729LL, 7},
    {171, 1, 3214946281LL, 7},
    {172, 1, 3196254732LL, 7},
    {173, 1, 3177779272LL, 7},
    {174, 1, 3159516172LL, 7},
    {175, 1, 3141461794LL, 7},
    {176, 1, 3123612579LL, 7},
    {177, 1, 3105965051LL, 7},
    {178, 1, 3088515809LL, 7},
    {179, 1, 3071261531LL, 7},
    {180, 1, 3054198967LL, 7},
    {181, 1, 3037324939LL, 7},
    {182, 1, 3020636341LL, 7},
    {183, 1, 3004130131LL, 7},
    {184, 1, 2987803337LL, 7},
    {185, 1, 2971653049LL, 7},
    {186, 1, 2955676419LL, 7},
    {187, 1, 2939870663LL, 7},
    {188, 1, 2924233053LL, 7},
    {189, 1, 2908760921LL, 7},
    {190, 1, 2893451653LL, 7},
    {191, 1, 2878302691LL, 7},
    {192, 1, 2863311531LL, 7},
    {193, 1, 2848475720LL, 7},
    {194, 1, 2833792856LL, 7},
    {195, 1, 2819260585LL, 7},
    {196, 1, 2804876602LL, 7},
    {197, 1, 2790638650LL, 7},
    {198, 1, 2776544515LL, 7},
    {199, 1, 2762592030LL, 7},
    {200, 1, 2748779070LL, 7},
    {201, 1, 2735103552LL, 7},
    {202, 1, 2721563436LL, 7},
    {203, 1, 2708156719LL, 7},
    {204, 1, 2694881441LL, 7},
    {205, 1, 2681735678LL, 7},
    {206, 1, 2668717544LL, 7},
    {207, 1, 2655825188LL, 7},
    {208, 1, 2643056798LL, 7},
    {209, 1, 2630410593LL, 7},
    {210, 1, 2617884829LL, 7},
    {211, 1, 2605477791LL, 7},
    {212, 1, 2593187802LL, 7},
    {213, 1, 2581013211LL, 7},
    {214, 1, 2568952402LL, 7},
    {215, 1, 2557003786LL, 7},
    {216, 1, 2545165806LL, 7},
    {217, 1, 2533436931LL, 7},
    {218, 1, 2521815661LL, 7},
    {219, 1, 2510300521LL, 7},
    {220, 1, 2498890064LL, 7},
    {221, 1, 2487582869LL, 7},
    {222, 1, 2476377541LL, 7},
    {223, 1, 2465272709LL, 7},
    {224, 1, 2454267027LL, 7},
    {225, 1, 2443359173LL, 7},
    {226, 1, 2432547850LL, 7},
    {227, 1, 2421831780LL, 7},
    {228, 1, 2411209711LL, 7},
    {229, 1, 2400680410LL, 7},
    {230, 1, 2390242670LL, 7},
    {231, 1, 2379895299LL, 7},
    {232, 1, 2369637129LL, 7},
    {233, 1, 2359467013LL, 7},
    {234, 1, 2349383821LL, 7},
    {235, 1, 2339386443LL, 7},
    {236, 1, 2329473788LL, 7},
    {237, 1, 2319644785LL, 7},
    {238, 1, 2309898378LL, 7},
    {239, 1, 2300233531LL, 7},
    {240, 1, 2290649225LL, 7},
    {241, 1, 2281144456LL, 7},
    {242, 1, 2271718240LL, 7},
    {243, 1, 2262369605LL, 7},
    {244, 1, 2253097598LL, 7},
    {245, 1, 2243901282LL, 7},
    {246, 1, 2234779732LL, 7},
    {247, 1, 2225732041LL, 7},
    {248, 1, 2216757315LL, 7},
    {249, 1, 2207854675LL, 7},
    {250, 1, 2199023256LL, 7},
    {251, 1, 2190262207LL, 7},
    {252, 1, 2181570691LL, 7},
    {253, 1, 2172947881LL, 7},
    {254, 1, 2164392969LL, 7},
    {255, 1, 2155905153LL, 7},
};
const int64_t table_runtime_u8[256][4] = {
    {0, 0, 0, 0},  // unused
    {0, 0, 0, 0},  // unused
    {2, 2, 1ULL, 0},
    {3, 2, 86ULL, 1},
    {4, 2, 1ULL, 1},
    {5, 2, 154ULL, 2},
    {6, 2, 86ULL, 2},
    {7, 2, 37ULL, 2},
    {8, 2, 1ULL, 2},
    {9, 2, 200ULL, 3},
    {10, 2, 154ULL, 3},
    {11, 2, 117ULL, 3},
    {12, 2, 86ULL, 3},
    {13, 2, 60ULL, 3},
    {14, 2, 37ULL, 3},
    {15, 2, 18ULL, 3},
    {16, 2, 1ULL, 3},
    {17, 2, 226ULL, 4},
    {18, 2, 200ULL, 4},
    {19, 2, 176ULL, 4},
    {20, 2, 154ULL, 4},
    {21, 2, 135ULL, 4},
    {22, 2, 117ULL, 4},
    {23, 2, 101ULL, 4},
    {24, 2, 86ULL, 4},
    {25, 2, 72ULL, 4},
    {26, 2, 60ULL, 4},
    {27, 2, 48ULL, 4},
    {28, 2, 37ULL, 4},
    {29, 2, 27ULL, 4},
    {30, 2, 18ULL, 4},
    {31, 2, 9ULL, 4},
    {32, 2, 1ULL, 4},
    {33, 2, 241ULL, 5},
    {34, 2, 226ULL, 5},
    {35, 2, 213ULL, 5},
    {36, 2, 200ULL, 5},
    {37, 2, 187ULL, 5},
    {38, 2, 176ULL, 5},
    {39, 2, 165ULL, 5},
    {40, 2, 154ULL, 5},
    {41, 2, 144ULL, 5},
    {42, 2, 135ULL, 5},
    {43, 2, 126ULL, 5},
    {44, 2, 117ULL, 5},
    {45, 2, 109ULL, 5},
    {46, 2, 101ULL, 5},
    {47, 2, 93ULL, 5},
    {48, 2, 86ULL, 5},
    {49, 2, 79ULL, 5},
    {50, 2, 72ULL, 5},
    {51, 2, 66ULL, 5},
    {52, 2, 60ULL, 5},
    {53, 2, 54ULL, 5},
    {54, 2, 48ULL, 5},
    {55, 2, 42ULL, 5},
    {56, 2, 37ULL, 5},
    {57, 2, 32ULL, 5},
    {58, 2, 27ULL, 5},
    {59, 2, 22ULL, 5},
    {60, 2, 18ULL, 5},
    {61, 2, 13ULL, 5},
    {62, 2, 9ULL, 5},
    {63, 2, 5ULL, 5},
    {64, 2, 1ULL, 5},
    {65, 2, 249ULL, 6},
    {66, 2, 241ULL, 6},
    {67, 2, 234ULL, 6},
    {68, 2, 226ULL, 6},
    {69, 2, 219ULL, 6},
    {70, 2, 213ULL, 6},
    {71, 2, 206ULL, 6},
    {72, 2, 200ULL, 6},
    {73, 2, 193ULL, 6},
    {74, 2, 187ULL, 6},
    {75, 2, 181ULL, 6},
    {76, 2, 176ULL, 6},
    {77, 2, 170ULL, 6},
    {78, 2, 165ULL, 6},
    {79, 2, 159ULL, 6},
    {80, 2, 154ULL, 6},
    {81, 2, 149ULL, 6},
    {82, 2, 144ULL, 6},
    {83, 2, 139ULL, 6},
    {84, 2, 135ULL, 6},
    {85, 2, 130ULL, 6},
    {86, 2, 126ULL, 6},
    {87, 2, 121ULL, 6},
    {88, 2, 117ULL, 6},
    {89, 2, 113ULL, 6},
    {90, 2, 109ULL, 6},
    {91, 2, 105ULL, 6},
    {92, 2, 101ULL, 6},
    {93, 2, 97ULL, 6},
    {94, 2, 93ULL, 6},
    {95, 2, 89ULL, 6},
    {96, 2, 86ULL, 6},
    {97, 2, 82ULL, 6},
    {98, 2, 79ULL, 6},
    {99, 2, 75ULL, 6},
    {100, 2, 72ULL, 6},
    {101, 2, 69ULL, 6},
    {102, 2, 66ULL, 6},
    {103, 2, 63ULL, 6},
    {104, 2, 60ULL, 6},
    {105, 2, 57ULL, 6},
    {106, 2, 54ULL, 6},
    {107, 2, 51ULL, 6},
    {108, 2, 48ULL, 6},
    {109, 2, 45ULL, 6},
    {110, 2, 42ULL, 6},
    {111, 2, 40ULL, 6},
    {112, 2, 37ULL, 6},
    {113, 2, 34ULL, 6},
    {114, 2, 32ULL, 6},
    {115, 2, 29ULL, 6},
    {116, 2, 27ULL, 6},
    {117, 2, 25ULL, 6},
    {118, 2, 22ULL, 6},
    {119, 2, 20ULL, 6},
    {120, 2, 18ULL, 6},
    {121, 2, 15ULL, 6},
    {122, 2, 13ULL, 6},
    {123, 2, 11ULL, 6},
    {124, 2, 9ULL, 6},
    {125, 2, 7ULL, 6},
    {126, 2, 5ULL, 6},
    {127, 2, 3ULL, 6},
    {128, 2, 1ULL, 6},
    {129, 2, 253ULL, 7},
    {130, 2, 249ULL, 7},
    {131, 2, 245ULL, 7},
    {132, 2, 241ULL, 7},
    {133, 2, 237ULL, 7},
    {134, 2, 234ULL, 7},
    {135, 2, 230ULL, 7},
    {136, 2, 226ULL, 7},
    {137, 2, 223ULL, 7},
    {138, 2, 219ULL, 7},
    {139, 2, 216ULL, 7},
    {140, 2, 213ULL, 7},
    {141, 2, 209ULL, 7},
    {142, 2, 206ULL, 7},
    {143, 2, 203ULL, 7},
    {144, 2, 200ULL, 7},
    {145, 2, 196ULL, 7},
    {146, 2, 193ULL, 7},
    {147, 2, 190ULL, 7},
    {148, 2, 187ULL, 7},
    {149, 2, 184ULL, 7},
    {150, 2, 181ULL, 7},
    {151, 2, 179ULL, 7},
    {152, 2, 176ULL, 7},
    {153, 2, 173ULL, 7},
    {154, 2, 170ULL, 7},
    {155, 2, 167ULL, 7},
    {156, 2, 165ULL, 7},
    {157, 2, 162ULL, 7},
    {158, 2, 159ULL, 7},
    {159, 2, 157ULL, 7},
    {160, 2, 154ULL, 7},
    {161, 2, 152ULL, 7},
    {162, 2, 149ULL, 7},
    {163, 2, 147ULL, 7},
    {164, 2, 144ULL, 7},
    {165, 2, 142ULL, 7},
    {166, 2, 139ULL, 7},
    {167, 2, 137ULL, 7},
    {168, 2, 135ULL, 7},
    {169, 2, 132ULL, 7},
    {170, 2, 130ULL, 7},
    {171, 2, 128ULL, 7},
    {172, 2, 126ULL, 7},
    {173, 2, 123ULL, 7},
    {174, 2, 121ULL, 7},
    {175, 2, 119ULL, 7},
    {176, 2, 117ULL, 7},
    {177, 2, 115ULL, 7},
    {178, 2, 113ULL, 7},
    {179, 2, 111ULL, 7},
    {180, 2, 109ULL, 7},
    {181, 2, 107ULL, 7},
    {182, 2, 105ULL, 7},
    {183, 2, 103ULL, 7},
    {184, 2, 101ULL, 7},
    {185, 2, 99ULL, 7},
    {186, 2, 97ULL, 7},
    {187, 2, 95ULL, 7},
    {188, 2, 93ULL, 7},
    {189, 2, 91ULL, 7},
    {190, 2, 89ULL, 7},
    {191, 2, 88ULL, 7},
    {192, 2, 86ULL, 7},
    {193, 2, 84ULL, 7},
    {194, 2, 82ULL, 7},
    {195, 2, 81ULL, 7},
    {196, 2, 79ULL, 7},
    {197, 2, 77ULL, 7},
    {198, 2, 75ULL, 7},
    {199, 2, 74ULL, 7},
    {200, 2, 72ULL, 7},
    {201, 2, 71ULL, 7},
    {202, 2, 69ULL, 7},
    {203, 2, 67ULL, 7},
    {204, 2, 66ULL, 7},
    {205, 2, 64ULL, 7},
    {206, 2, 63ULL, 7},
    {207, 2, 61ULL, 7},
    {208, 2, 60ULL, 7},
    {209, 2, 58ULL, 7},
    {210, 2, 57ULL, 7},
    {211, 2, 55ULL, 7},
    {212, 2, 54ULL, 7},
    {213, 2, 52ULL, 7},
    {214, 2, 51ULL, 7},
    {215, 2, 49ULL, 7},
    {216, 2, 48ULL, 7},
    {217, 2, 47ULL, 7},
    {218, 2, 45ULL, 7},
    {219, 2, 44ULL, 7},
    {220, 2, 42ULL, 7},
    {221, 2, 41ULL, 7},
    {222, 2, 40ULL, 7},
    {223, 2, 38ULL, 7},
    {224, 2, 37ULL, 7},
    {225, 2, 36ULL, 7},
    {226, 2, 34ULL, 7},
    {227, 2, 33ULL, 7},
    {228, 2, 32ULL, 7},
    {229, 2, 31ULL, 7},
    {230, 2, 29ULL, 7},
    {231, 2, 28ULL, 7},
    {232, 2, 27ULL, 7},
    {233, 2, 26ULL, 7},
    {234, 2, 25ULL, 7},
    {235, 2, 23ULL, 7},
    {236, 2, 22ULL, 7},
    {237, 2, 21ULL, 7},
    {238, 2, 20ULL, 7},
    {239, 2, 19ULL, 7},
    {240, 2, 18ULL, 7},
    {241, 2, 16ULL, 7},
    {242, 2, 15ULL, 7},
    {243, 2, 14ULL, 7},
    {244, 2, 13ULL, 7},
    {245, 2, 12ULL, 7},
    {246, 2, 11ULL, 7},
    {247, 2, 10ULL, 7},
    {248, 2, 9ULL, 7},
    {249, 2, 8ULL, 7},
    {250, 2, 7ULL, 7},
    {251, 2, 6ULL, 7},
    {252, 2, 5ULL, 7},
    {253, 2, 4ULL, 7},
    {254, 2, 3ULL, 7},
    {255, 2, 2ULL, 7},
};
const int64_t table_runtime_s8[256][4] = {
    {0, 0, 0, 0},  // unused
    {0, 0, 0, 0},  // unused
    {2, 1, 129LL, 0},
    {3, 1, 171LL, 1},
    {4, 1, 129LL, 1},
    {5, 1, 205LL, 2},
    {6, 1, 171LL, 2},
    {7, 1, 147LL, 2},
    {8, 1, 129LL, 2},
    {9, 1, 228LL, 3},
    {10, 1, 205LL, 3},
    {11, 1, 187LL, 3},
    {12, 1, 171LL, 3},
    {13, 1, 158LL, 3},
    {14, 1, 147LL, 3},
    {15, 1, 137LL, 3},
    {16, 1, 129LL, 3},
    {17, 1, 241LL, 4},
    {18, 1, 228LL, 4},
    {19, 1, 216LL, 4},
    {20, 1, 205LL, 4},
    {21, 1, 196LL, 4},
    {22, 1, 187LL, 4},
    {23, 1, 179LL, 4},
    {24, 1, 171LL, 4},
    {25, 1, 164LL, 4},
    {26, 1, 158LL, 4},
    {27, 1, 152LL, 4},
    {28, 1, 147LL, 4},
    {29, 1, 142LL, 4},
    {30, 1, 137LL, 4},
    {31, 1, 133LL, 4},
    {32, 1, 129LL, 4},
    {33, 1, 249LL, 5},
    {34, 1, 241LL, 5},
    {35, 1, 235LL, 5},
    {36, 1, 228LL, 5},
    {37, 1, 222LL, 5},
    {38, 1, 216LL, 5},
    {39, 1, 211LL, 5},
    {40, 1, 205LL, 5},
    {41, 1, 200LL, 5},
    {42, 1, 196LL, 5},
    {43, 1, 191LL, 5},
    {44, 1, 187LL, 5},
    {45, 1, 183LL, 5},
    {46, 1, 179LL, 5},
    {47, 1, 175LL, 5},
    {48, 1, 171LL, 5},
    {49, 1, 168LL, 5},
    {50, 1, 164LL, 5},
    {51, 1, 161LL, 5},
    {52, 1, 158LL, 5},
    {53, 1, 155LL, 5},
    {54, 1, 152LL, 5},
    {55, 1, 149LL, 5},
    {56, 1, 147LL, 5},
    {57, 1, 144LL, 5},
    {58, 1, 142LL, 5},
    {59, 1, 139LL, 5},
    {60, 1, 137LL, 5},
    {61, 1, 135LL, 5},
    {62, 1, 133LL, 5},
    {63, 1, 131LL, 5},
    {64, 1, 129LL, 5},
    {65, 1, 253LL, 6},
    {66, 1, 249LL, 6},
    {67, 1, 245LL, 6},
    {68, 1, 241LL, 6},
    {69, 1, 238LL, 6},
    {70, 1, 235LL, 6},
    {71, 1, 231LL, 6},
    {72, 1, 228LL, 6},
    {73, 1, 225LL, 6},
    {74, 1, 222LL, 6},
    {75, 1, 219LL, 6},
    {76, 1, 216LL, 6},
    {77, 1, 213LL, 6},
    {78, 1, 211LL, 6},
    {79, 1, 208LL, 6},
    {80, 1, 205LL, 6},
    {81, 1, 203LL, 6},
    {82, 1, 200LL, 6},
    {83, 1, 198LL, 6},
    {84, 1, 196LL, 6},
    {85, 1, 193LL, 6},
    {86, 1, 191LL, 6},
    {87, 1, 189LL, 6},
    {88, 1, 187LL, 6},
    {89, 1, 185LL, 6},
    {90, 1, 183LL, 6},
    {91, 1, 181LL, 6},
    {92, 1, 179LL, 6},
    {93, 1, 177LL, 6},
    {94, 1, 175LL, 6},
    {95, 1, 173LL, 6},
    {96, 1, 171LL, 6},
    {97, 1, 169LL, 6},
    {98, 1, 168LL, 6},
    {99, 1, 166LL, 6},
    {100, 1, 164LL, 6},
    {101, 1, 163LL, 6},
    {102, 1, 161LL, 6},
    {103, 1, 160LL, 6},
    {104, 1, 158LL, 6},
    {105, 1, 157LL, 6},
    {106, 1, 155LL, 6},
    {107, 1, 154LL, 6},
    {108, 1, 152LL, 6},
    {109, 1, 151LL, 6},
    {110, 1, 149LL, 6},
    {111, 1, 148LL, 6},
    {112, 1, 147LL, 6},
    {113, 1, 145LL, 6},
    {114, 1, 144LL, 6},
    {115, 1, 143LL, 6},
    {116, 1, 142LL, 6},
    {117, 1, 141LL, 6},
    {118, 1, 139LL, 6},
    {119, 1, 138LL, 6},
    {120, 1, 137LL, 6},
    {121, 1, 136LL, 6},
    {122, 1, 135LL, 6},
    {123, 1, 134LL, 6},
    {124, 1, 133LL, 6},
    {125, 1, 132LL, 6},
    {126, 1, 131LL, 6},
    {127, 1, 130LL, 6},
    {128, 1, 129LL, 6},
    {129, 1, 255LL, 7},
    {130, 1, 253LL, 7},
    {131, 1, 251LL, 7},
    {132, 1, 249LL, 7},
    {133, 1, 247LL, 7},
    {134, 1, 245LL, 7},
    {135, 1, 243LL, 7},
    {136, 1, 241LL, 7},
    {137, 1, 240LL, 7},
    {138, 1, 238LL, 7},
    {139, 1, 236LL, 7},
    {140, 1, 235LL, 7},
    {141, 1, 233LL, 7},
    {142, 1, 231LL, 7},
    {143, 1, 230LL, 7},
    {144, 1, 228LL, 7},
    {145, 1, 226LL, 7},
    {146, 1, 225LL, 7},
    {147, 1, 223LL, 7},
    {148, 1, 222LL, 7},
    {149, 1, 220LL, 7},
    {150, 1, 219LL, 7},
    {151, 1, 218LL, 7},
    {152, 1, 216LL, 7},
    {153, 1, 215LL, 7},
    {154, 1, 213LL, 7},
    {155, 1, 212LL, 7},
    {156, 1, 211LL, 7},
    {157, 1, 209LL, 7},
    {158, 1, 208LL, 7},
    {159, 1, 207LL, 7},
    {160, 1, 205LL, 7},
    {161, 1, 204LL, 7},
    {162, 1, 203LL, 7},
    {163, 1, 202LL, 7},
    {164, 1, 200LL, 7},
    {165, 1, 199LL, 7},
    {166, 1, 198LL, 7},
    {167, 1, 197LL, 7},
    {168, 1, 196LL, 7},
    {169, 1, 194LL, 7},
    {170, 1, 193LL, 7},
    {171, 1, 192LL, 7},
    {172, 1, 191LL, 7},
    {173, 1, 190LL, 7},
    {174, 1, 189LL, 7},
    {175, 1, 188LL, 7},
    {176, 1, 187LL, 7},
    {177, 1, 186LL, 7},
    {178, 1, 185LL, 7},
    {179, 1, 184LL, 7},
    {180, 1, 183LL, 7},
    {181, 1, 182LL, 7},
    {182, 1, 181LL, 7},
    {183, 1, 180LL, 7},
    {184, 1, 179LL, 7},
    {185, 1, 178LL, 7},
    {186, 1, 177LL, 7},
    {187, 1, 176LL, 7},
    {188, 1, 175LL, 7},
    {189, 1, 174LL, 7},
    {190, 1, 173LL, 7},
    {191, 1, 172LL, 7},
    {192, 1, 171LL, 7},
    {193, 1, 170LL, 7},
    {194, 1, 169LL, 7},
    {195, 1, 169LL, 7},
    {196, 1, 168LL, 7},
    {197, 1, 167LL, 7},
    {198, 1, 166LL, 7},
    {199, 1, 165LL, 7},
    {200, 1, 164LL, 7},
    {201, 1, 164LL, 7},
    {202, 1, 163LL, 7},
    {203, 1, 162LL, 7},
    {204, 1, 161LL, 7},
    {205, 1, 160LL, 7},
    {206, 1, 160LL, 7},
    {207, 1, 159LL, 7},
    {208, 1, 158LL, 7},
    {209, 1, 157LL, 7},
    {210, 1, 157LL, 7},
    {211, 1, 156LL, 7},
    {212, 1, 155LL, 7},
    {213, 1, 154LL, 7},
    {214, 1, 154LL, 7},
    {215, 1, 153LL, 7},
    {216, 1, 152LL, 7},
    {217, 1, 152LL, 7},
    {218, 1, 151LL, 7},
    {219, 1, 150LL, 7},
    {220, 1, 149LL, 7},
    {221, 1, 149LL, 7},
    {222, 1, 148LL, 7},
    {223, 1, 147LL, 7},
    {224, 1, 147LL, 7},
    {225, 1, 146LL, 7},
    {226, 1, 145LL, 7},
    {227, 1, 145LL, 7},
    {228, 1, 144LL, 7},
    {229, 1, 144LL, 7},
    {230, 1, 143LL, 7},
    {231, 1, 142LL, 7},
    {232, 1, 142LL, 7},
    {233, 1, 141LL, 7},
    {234, 1, 141LL, 7},
    {235, 1, 140LL, 7},
    {236, 1, 139LL, 7},
    {237, 1, 139LL, 7},
    {238, 1, 138LL, 7},
    {239, 1, 138LL, 7},
    {240, 1, 137LL, 7},
    {241, 1, 136LL, 7},
    {242, 1, 136LL, 7},
    {243, 1, 135LL, 7},
    {244, 1, 135LL, 7},
    {245, 1, 134LL, 7},
    {246, 1, 134LL, 7},
    {247, 1, 133LL, 7},
    {248, 1, 133LL, 7},
    {249, 1, 132LL, 7},
    {250, 1, 132LL, 7},
    {251, 1, 131LL, 7},
    {252, 1, 131LL, 7},
    {253, 1, 130LL, 7},
    {254, 1, 130LL, 7},
    {255, 1, 129LL, 7},
};
const int64_t table_runtime_srz8[256][4] = {
    {0, 0, 0, 0},  // unused
    {0, 0, 0, 0},  // unused
    {2, 1, 129LL, 0},
    {3, 1, 171LL, 1},
    {4, 1, 129LL, 1},
    {5, 1, 205LL, 2},
    {6, 1, 171LL, 2},
    {7, 1, 147LL, 2},
    {8, 1, 129LL, 2},
    {9, 1, 228LL, 3},
    {10, 1, 205LL, 3},
    {11, 1, 187LL, 3},
    {12, 1, 171LL, 3},
    {13, 1, 158LL, 3},
    {14, 1, 147LL, 3},
    {15, 1, 137LL, 3},
    {16, 1, 129LL, 3},
    {17, 1, 241LL, 4},
    {18, 1, 228LL, 4},
    {19, 1, 216LL, 4},
    {20, 1, 205LL, 4},
    {21, 1, 196LL, 4},
    {22, 1, 187LL, 4},
    {23, 1, 179LL, 4},
    {24, 1, 171LL, 4},
    {25, 1, 164LL, 4},
    {26, 1, 158LL, 4},
    {27, 1, 152LL, 4},
    {28, 1, 147LL, 4},
    {29, 1, 142LL, 4},
    {30, 1, 137LL, 4},
    {31, 1, 133LL, 4},
    {32, 1, 129LL, 4},
    {33, 1, 249LL, 5},
    {34, 1, 241LL, 5},
    {35, 1, 235LL, 5},
    {36, 1, 228LL, 5},
    {37, 1, 222LL, 5},
    {38, 1, 216LL, 5},
    {39, 1, 211LL, 5},
    {40, 1, 205LL, 5},
    {41, 1, 200LL, 5},
    {42, 1, 196LL, 5},
    {43, 1, 191LL, 5},
    {44, 1, 187LL, 5},
    {45, 1, 183LL, 5},
    {46, 1, 179LL, 5},
    {47, 1, 175LL, 5},
    {48, 1, 171LL, 5},
    {49, 1, 168LL, 5},
    {50, 1, 164LL, 5},
    {51, 1, 161LL, 5},
    {52, 1, 158LL, 5},
    {53, 1, 155LL, 5},
    {54, 1, 152LL, 5},
    {55, 1, 149LL, 5},
    {56, 1, 147LL, 5},
    {57, 1, 144LL, 5},
    {58, 1, 142LL, 5},
    {59, 1, 139LL, 5},
    {60, 1, 137LL, 5},
    {61, 1, 135LL, 5},
    {62, 1, 133LL, 5},
    {63, 1, 131LL, 5},
    {64, 1, 129LL, 5},
    {65, 1, 253LL, 6},
    {66, 1, 249LL, 6},
    {67, 1, 245LL, 6},
    {68, 1, 241LL, 6},
    {69, 1, 238LL, 6},
    {70, 1, 235LL, 6},
    {71, 1, 231LL, 6},
    {72, 1, 228LL, 6},
    {73, 1, 225LL, 6},
    {74, 1, 222LL, 6},
    {75, 1, 219LL, 6},
    {76, 1, 216LL, 6},
    {77, 1, 213LL, 6},
    {78, 1, 211LL, 6},
    {79, 1, 208LL, 6},
    {80, 1, 205LL, 6},
    {81, 1, 203LL, 6},
    {82, 1, 200LL, 6},
    {83, 1, 198LL, 6},
    {84, 1, 196LL, 6},
    {85, 1, 193LL, 6},
    {86, 1, 191LL, 6},
    {87, 1, 189LL, 6},
    {88, 1, 187LL, 6},
    {89, 1, 185LL, 6},
    {90, 1, 183LL, 6},
    {91, 1, 181LL, 6},
    {92, 1, 179LL, 6},
    {93, 1, 177LL, 6},
    {94, 1, 175LL, 6},
    {95, 1, 173LL, 6},
    {96, 1, 171LL, 6},
    {97, 1, 169LL, 6},
    {98, 1, 168LL, 6},
    {99, 1, 166LL, 6},
    {100, 1, 164LL, 6},
    {101, 1, 163LL, 6},
    {102, 1, 161LL, 6},
    {103, 1, 160LL, 6},
    {104, 1, 158LL, 6},
    {105, 1, 157LL, 6},
    {106, 1, 155LL, 6},
    {107, 1, 154LL, 6},
    {108, 1, 152LL, 6},
    {109, 1, 151LL, 6},
    {110, 1, 149LL, 6},
    {111, 1, 148LL, 6},
    {112, 1, 147LL, 6},
    {113, 1, 145LL, 6},
    {114, 1, 144LL, 6},
    {115, 1, 143LL, 6},
    {116, 1, 142LL, 6},
    {117, 1, 141LL, 6},
    {118, 1, 139LL, 6},
    {119, 1, 138LL, 6},
    {120, 1, 137LL, 6},
    {121, 1, 136LL, 6},
    {122, 1, 135LL, 6},
    {123, 1, 134LL, 6},
    {124, 1, 133LL, 6},
    {125, 1, 132LL, 6},
    {126, 1, 131LL, 6},
    {127, 1, 130LL, 6},
    {128, 1, 129LL, 6},
    {129, 1, 255LL, 7},
    {130, 1, 253LL, 7},
    {131, 1, 251LL, 7},
    {132, 1, 249LL, 7},
    {133, 1, 247LL, 7},
    {134, 1, 245LL, 7},
    {135, 1, 243LL, 7},
    {136, 1, 241LL, 7},
    {137, 1, 240LL, 7},
    {138, 1, 238LL, 7},
    {139, 1, 236LL, 7},
    {140, 1, 235LL, 7},
    {141, 1, 233LL, 7},
    {142, 1, 231LL, 7},
    {143, 1, 230LL, 7},
    {144, 1, 228LL, 7},
    {145, 1, 226LL, 7},
    {146, 1, 225LL, 7},
    {147, 1, 223LL, 7},
    {148, 1, 222LL, 7},
    {149, 1, 220LL, 7},
    {150, 1, 219LL, 7},
    {151, 1, 218LL, 7},
    {152, 1, 216LL, 7},
    {153, 1, 215LL, 7},
    {154, 1, 213LL, 7},
    {155, 1, 212LL, 7},
    {156, 1, 211LL, 7},
    {157, 1, 209LL, 7},
    {158, 1, 208LL, 7},
    {159, 1, 207LL, 7},
    {160, 1, 205LL, 7},
    {161, 1, 204LL, 7},
    {162, 1, 203LL, 7},
    {163, 1, 202LL, 7},
    {164, 1, 200LL, 7},
    {165, 1, 199LL, 7},
    {166, 1, 198LL, 7},
    {167, 1, 197LL, 7},
    {168, 1, 196LL, 7},
    {169, 1, 194LL, 7},
    {170, 1, 193LL, 7},
    {171, 1, 192LL, 7},
    {172, 1, 191LL, 7},
    {173, 1, 190LL, 7},
    {174, 1, 189LL, 7},
    {175, 1, 188LL, 7},
    {176, 1, 187LL, 7},
    {177, 1, 186LL, 7},
    {178, 1, 185LL, 7},
    {179, 1, 184LL, 7},
    {180, 1, 183LL, 7},
    {181, 1, 182LL, 7},
    {182, 1, 181LL, 7},
    {183, 1, 180LL, 7},
    {184, 1, 179LL, 7},
    {185, 1, 178LL, 7},
    {186, 1, 177LL, 7},
    {187, 1, 176LL, 7},
    {188, 1, 175LL, 7},
    {189, 1, 174LL, 7},
    {190, 1, 173LL, 7},
    {191, 1, 172LL, 7},
    {192, 1, 171LL, 7},
    {193, 1, 170LL, 7},
    {194, 1, 169LL, 7},
    {195, 1, 169LL, 7},
    {196, 1, 168LL, 7},
    {197, 1, 167LL, 7},
    {198, 1, 166LL, 7},
    {199, 1, 165LL, 7},
    {200, 1, 164LL, 7},
    {201, 1, 164LL, 7},
    {202, 1, 163LL, 7},
    {203, 1, 162LL, 7},
    {204, 1, 161LL, 7},
    {205, 1, 160LL, 7},
    {206, 1, 160LL, 7},
    {207, 1, 159LL, 7},
    {208, 1, 158LL, 7},
    {209, 1, 157LL, 7},
    {210, 1, 157LL, 7},
    {211, 1, 156LL, 7},
    {212, 1, 155LL, 7},
    {213, 1, 154LL, 7},
    {214, 1, 154LL, 7},
    {215, 1, 153LL, 7},
    {216, 1, 152LL, 7},
    {217, 1, 152LL, 7},
    {218, 1, 151LL, 7},
    {219, 1, 150LL, 7},
    {220, 1, 149LL, 7},
    {221, 1, 149LL, 7},
    {222, 1, 148LL, 7},
    {223, 1, 147LL, 7},
    {224, 1, 147LL, 7},
    {225, 1, 146LL, 7},
    {226, 1, 145LL, 7},
    {227, 1, 145LL, 7},
    {228, 1, 144LL, 7},
    {229, 1, 144LL, 7},
    {230, 1, 143LL, 7},
    {231, 1, 142LL, 7},
    {232, 1, 142LL, 7},
    {233, 1, 141LL, 7},
    {234, 1, 141LL, 7},
    {235, 1, 140LL, 7},
    {236, 1, 139LL, 7},
    {237, 1, 139LL, 7},
    {238, 1, 138LL, 7},
    {239, 1, 138LL, 7},
    {240, 1, 137LL, 7},
    {241, 1, 136LL, 7},
    {242, 1, 136LL, 7},
    {243, 1, 135LL, 7},
    {244, 1, 135LL, 7},
    {245, 1, 134LL, 7},
    {246, 1, 134LL, 7},
    {247, 1, 133LL, 7},
    {248, 1, 133LL, 7},
    {249, 1, 132LL, 7},
    {250, 1, 132LL, 7},
    {251, 1, 131LL, 7},
    {252, 1, 131LL, 7},
    {253, 1, 130LL, 7},
    {254, 1, 130LL, 7},
    {255, 1, 129LL, 7},
};
const int64_t table_runtime_u16[256][4] = {
    {0, 0, 0, 0},  // unused
    {0, 0, 0, 0},  // unused
    {2, 2, 1ULL, 0},
    {3, 2, 21846ULL, 1},
    {4, 2, 1ULL, 1},
    {5, 2, 39322ULL, 2},
    {6, 2, 21846ULL, 2},
    {7, 2, 9363ULL, 2},
    {8, 2, 1ULL, 2},
    {9, 2, 50973ULL, 3},
    {10, 2, 39322ULL, 3},
    {11, 2, 29790ULL, 3},
    {12, 2, 21846ULL, 3},
    {13, 2, 15124ULL, 3},
    {14, 2, 9363ULL, 3},
    {15, 2, 4370ULL, 3},
    {16, 2, 1ULL, 3},
    {17, 2, 57826ULL, 4},
    {18, 2, 50973ULL, 4},
    {19, 2, 44841ULL, 4},
    {20, 2, 39322ULL, 4},
    {21, 2, 34329ULL, 4},
    {22, 2, 29790ULL, 4},
    {23, 2, 25645ULL, 4},
    {24, 2, 21846ULL, 4},
    {25, 2, 18351ULL, 4},
    {26, 2, 15124ULL, 4},
    {27, 2, 12137ULL, 4},
    {28, 2, 9363ULL, 4},
    {29, 2, 6780ULL, 4},
    {30, 2, 4370ULL, 4},
    {31, 2, 2115ULL, 4},
    {32, 2, 1ULL, 4},
    {33, 2, 61565ULL, 5},
    {34, 2, 57826ULL, 5},
    {35, 2, 54302ULL, 5},
    {36, 2, 50973ULL, 5},
    {37, 2, 47824ULL, 5},
    {38, 2, 44841ULL, 5},
    {39, 2, 42011ULL, 5},
    {40, 2, 39322ULL, 5},
    {41, 2, 36765ULL, 5},
    {42, 2, 34329ULL, 5},
    {43, 2, 32006ULL, 5},
    {44, 2, 29790ULL, 5},
    {45, 2, 27671ULL, 5},
    {46, 2, 25645ULL, 5},
    {47, 2, 23705ULL, 5},
    {48, 2, 21846ULL, 5},
    {49, 2, 20063ULL, 5},
    {50, 2, 18351ULL, 5},
    {51, 2, 16706ULL, 5},
    {52, 2, 15124ULL, 5},
    {53, 2, 13602ULL, 5},
    {54, 2, 12137ULL, 5},
    {55, 2, 10725ULL, 5},
    {56, 2, 9363ULL, 5},
    {57, 2, 8049ULL, 5},
    {58, 2, 6780ULL, 5},
    {59, 2, 5554ULL, 5},
    {60, 2, 4370ULL, 5},
    {61, 2, 3224ULL, 5},
    {62, 2, 2115ULL, 5},
    {63, 2, 1041ULL, 5},
    {64, 2, 1ULL, 5},
    {65, 2, 63520ULL, 6},
    {66, 2, 61565ULL, 6},
    {67, 2, 59668ULL, 6},
    {68, 2, 57826ULL, 6},
    {69, 2, 56039ULL, 6},
    {70, 2, 54302ULL, 6},
    {71, 2, 52614ULL, 6},
    {72, 2, 50973ULL, 6},
    {73, 2, 49377ULL, 6},
    {74, 2, 47824ULL, 6},
    {75, 2, 46313ULL, 6},
    {76, 2, 44841ULL, 6},
    {77, 2, 43407ULL, 6},
    {78, 2, 42011ULL, 6},
    {79, 2, 40649ULL, 6},
    {80, 2, 39322ULL, 6},
    {81, 2, 38028ULL, 6},
    {82, 2, 36765ULL, 6},
    {83, 2, 35532ULL, 6},
    {84, 2, 34329ULL, 6},
    {85, 2, 33154ULL, 6},
    {86, 2, 32006ULL, 6},
    {87, 2, 30885ULL, 6},
    {88, 2, 29790ULL, 6},
    {89, 2, 28719ULL, 6},
    {90, 2, 27671ULL, 6},
    {91, 2, 26647ULL, 6},
    {92, 2, 25645ULL, 6},
    {93, 2, 24665ULL, 6},
    {94, 2, 23705ULL, 6},
    {95, 2, 22766ULL, 6},
    {96, 2, 21846ULL, 6},
    {97, 2, 20945ULL, 6},
    {98, 2, 20063ULL, 6},
    {99, 2, 19198ULL, 6},
    {100, 2, 18351ULL, 6},
    {101, 2, 17520ULL, 6},
    {102, 2, 16706ULL, 6},
    {103, 2, 15907ULL, 6},
    {104, 2, 15124ULL, 6},
    {105, 2, 14356ULL, 6},
    {106, 2, 13602ULL, 6},
    {107, 2, 12863ULL, 6},
    {108, 2, 12137ULL, 6},
    {109, 2, 11424ULL, 6},
    {110, 2, 10725ULL, 6},
    {111, 2, 10038ULL, 6},
    {112, 2, 9363ULL, 6},
    {113, 2, 8700ULL, 6},
    {114, 2, 8049ULL, 6},
    {115, 2, 7409ULL, 6},
    {116, 2, 6780ULL, 6},
    {117, 2, 6162ULL, 6},
    {118, 2, 5554ULL, 6},
    {119, 2, 4957ULL, 6},
    {120, 2, 4370ULL, 6},
    {121, 2, 3792ULL, 6},
    {122, 2, 3224ULL, 6},
    {123, 2, 2665ULL, 6},
    {124, 2, 2115ULL, 6},
    {125, 2, 1573ULL, 6},
    {126, 2, 1041ULL, 6},
    {127, 2, 517ULL, 6},
    {128, 2, 1ULL, 6},
    {129, 2, 64520ULL, 7},
    {130, 2, 63520ULL, 7},
    {131, 2, 62535ULL, 7},
    {132, 2, 61565ULL, 7},
    {133, 2, 60609ULL, 7},
    {134, 2, 59668ULL, 7},
    {135, 2, 58740ULL, 7},
    {136, 2, 57826ULL, 7},
    {137, 2, 56926ULL, 7},
    {138, 2, 56039ULL, 7},
    {139, 2, 55164ULL, 7},
    {140, 2, 54302ULL, 7},
    {141, 2, 53452ULL, 7},
    {142, 2, 52614ULL, 7},
    {143, 2, 51788ULL, 7},
    {144, 2, 50973ULL, 7},
    {145, 2, 50169ULL, 7},
    {146, 2, 49377ULL, 7},
    {147, 2, 48595ULL, 7},
    {148, 2, 47824ULL, 7},
    {149, 2, 47063ULL, 7},
    {150, 2, 46313ULL, 7},
    {151, 2, 45572ULL, 7},
    {152, 2, 44841ULL, 7},
    {153, 2, 44120ULL, 7},
    {154, 2, 43407ULL, 7},
    {155, 2, 42705ULL, 7},
    {156, 2, 42011ULL, 7},
    {157, 2, 41326ULL, 7},
    {158, 2, 40649ULL, 7},
    {159, 2, 39982ULL, 7},
    {160, 2, 39322ULL, 7},
    {161, 2, 38671ULL, 7},
    {162, 2, 38028ULL, 7},
    {163, 2, 37392ULL, 7},
    {164, 2, 36765ULL, 7},
    {165, 2, 36145ULL, 7},
    {166, 2, 35532ULL, 7},
    {167, 2, 34927ULL, 7},
    {168, 2, 34329ULL, 7},
    {169, 2, 33738ULL, 7},
    {170, 2, 33154ULL, 7},
    {171, 2, 32577ULL, 7},
    {172, 2, 32006ULL, 7},
    {173, 2, 31443ULL, 7},
    {174, 2, 30885ULL, 7},
    {175, 2, 30334ULL, 7},
    {176, 2, 29790ULL, 7},
    {177, 2, 29251ULL, 7},
    {178, 2, 28719ULL, 7},
    {179, 2, 28192ULL, 7},
    {180, 2, 27671ULL, 7},
    {181, 2, 27156ULL, 7},
    {182, 2, 26647ULL, 7},
    {183, 2, 26143ULL, 7},
    {184, 2, 25645ULL, 7},
    {185, 2, 25152ULL, 7},
    {186, 2, 24665ULL, 7},
    {187, 2, 24182ULL, 7},
    {188, 2, 23705ULL, 7},
    {189, 2, 23233ULL, 7},
    {190, 2, 22766ULL, 7},
    {191, 2, 22303ULL, 7},
    {192, 2, 21846ULL, 7},
    {193, 2, 21393ULL, 7},
    {194, 2, 20945ULL, 7},
    {195, 2, 20502ULL, 7},
    {196, 2, 20063ULL, 7},
    {197, 2, 19628ULL, 7},
    {198, 2, 19198ULL, 7},
    {199, 2, 18772ULL, 7},
    {200, 2, 18351ULL, 7},
    {201, 2, 17933ULL, 7},
    {202, 2, 17520ULL, 7},
    {203, 2, 17111ULL, 7},
    {204, 2, 16706ULL, 7},
    {205, 2, 16305ULL, 7},
    {206, 2, 15907ULL, 7},
    {207, 2, 15514ULL, 7},
    {208, 2, 15124ULL, 7},
    {209, 2, 14738ULL, 7},
    {210, 2, 14356ULL, 7},
    {211, 2, 13977ULL, 7},
    {212, 2, 13602ULL, 7},
    {213, 2, 13231ULL, 7},
    {214, 2, 12863ULL, 7},
    {215, 2, 12498ULL, 7},
    {216, 2, 12137ULL, 7},
    {217, 2, 11779ULL, 7},
    {218, 2, 11424ULL, 7},
    {219, 2, 11073ULL, 7},
    {220, 2, 10725ULL, 7},
    {221, 2, 10380ULL, 7},
    {222, 2, 10038ULL, 7},
    {223, 2, 9699ULL, 7},
    {224, 2, 9363ULL, 7},
    {225, 2, 9030ULL, 7},
    {226, 2, 8700ULL, 7},
    {227, 2, 8373ULL, 7},
    {228, 2, 8049ULL, 7},
    {229, 2, 7727ULL, 7},
    {230, 2, 7409ULL, 7},
    {231, 2, 7093ULL, 7},
    {232, 2, 6780ULL, 7},
    {233, 2, 6470ULL, 7},
    {234, 2, 6162ULL, 7},
    {235, 2, 5857ULL, 7},
    {236, 2, 5554ULL, 7},
    {237, 2, 5254ULL, 7},
    {238, 2, 4957ULL, 7},
    {239, 2, 4662ULL, 7},
    {240, 2, 4370ULL, 7},
    {241, 2, 4080ULL, 7},
    {242, 2, 3792ULL, 7},
    {243, 2, 3507ULL, 7},
    {244, 2, 3224ULL, 7},
    {245, 2, 2943ULL, 7},
    {246, 2, 2665ULL, 7},
    {247, 2, 2388ULL, 7},
    {248, 2, 2115ULL, 7},
    {249, 2, 1843ULL, 7},
    {250, 2, 1573ULL, 7},
    {251, 2, 1306ULL, 7},
    {252, 2, 1041ULL, 7},
    {253, 2, 778ULL, 7},
    {254, 2, 517ULL, 7},
    {255, 2, 258ULL, 7},
};
const int64_t table_runtime_s16[256][4] = {
    {0, 0, 0, 0},  // unused
    {0, 0, 0, 0},  // unused
    {2, 1, 32769LL, 0},
    {3, 1, 43691LL, 1},
    {4, 1, 32769LL, 1},
    {5, 1, 52429LL, 2},
    {6, 1, 43691LL, 2},
    {7, 1, 37450LL, 2},
    {8, 1, 32769LL, 2},
    {9, 1, 58255LL, 3},
    {10, 1, 52429LL, 3},
    {11, 1, 47663LL, 3},
    {12, 1, 43691LL, 3},
    {13, 1, 40330LL, 3},
    {14, 1, 37450LL, 3},
    {15, 1, 34953LL, 3},
    {16, 1, 32769LL, 3},
    {17, 1, 61681LL, 4},
    {18, 1, 58255LL, 4},
    {19, 1, 55189LL, 4},
    {20, 1, 52429LL, 4},
    {21, 1, 49933LL, 4},
    {22, 1, 47663LL, 4},
    {23, 1, 45591LL, 4},
    {24, 1, 43691LL, 4},
    {25, 1, 41944LL, 4},
    {26, 1, 40330LL, 4},
    {27, 1, 38837LL, 4},
    {28, 1, 37450LL, 4},
    {29, 1, 36158LL, 4},
    {30, 1, 34953LL, 4},
    {31, 1, 33826LL, 4},
    {32, 1, 32769LL, 4},
    {33, 1, 63551LL, 5},
    {34, 1, 61681LL, 5},
    {35, 1, 59919LL, 5},
    {36, 1, 58255LL, 5},
    {37, 1, 56680LL, 5},
    {38, 1, 55189LL, 5},
    {39, 1, 53774LL, 5},
    {40, 1, 52429LL, 5},
    {41, 1, 51151LL, 5},
    {42, 1, 49933LL, 5},
    {43, 1, 48771LL, 5},
    {44, 1, 47663LL, 5},
    {45, 1, 46604LL, 5},
    {46, 1, 45591LL, 5},
    {47, 1, 44621LL, 5},
    {48, 1, 43691LL, 5},
    {49, 1, 42800LL, 5},
    {50, 1, 41944LL, 5},
    {51, 1, 41121LL, 5},
    {52, 1, 40330LL, 5},
    {53, 1, 39569LL, 5},
    {54, 1, 38837LL, 5},
    {55, 1, 38131LL, 5},
    {56, 1, 37450LL, 5},
    {57, 1, 36793LL, 5},
    {58, 1, 36158LL, 5},
    {59, 1, 35545LL, 5},
    {60, 1, 34953LL, 5},
    {61, 1, 34380LL, 5},
    {62, 1, 33826LL, 5},
    {63, 1, 33289LL, 5},
    {64, 1, 32769LL, 5},
    {65, 1, 64528LL, 6},
    {66, 1, 63551LL, 6},
    {67, 1, 62602LL, 6},
    {68, 1, 61681LL, 6},
    {69, 1, 60788LL, 6},
    {70, 1, 59919LL, 6},
    {71, 1, 59075LL, 6},
    {72, 1, 58255LL, 6},
    {73, 1, 57457LL, 6},
    {74, 1, 56680LL, 6},
    {75, 1, 55925LL, 6},
    {76, 1, 55189LL, 6},
    {77, 1, 54472LL, 6},
    {78, 1, 53774LL, 6},
    {79, 1, 53093LL, 6},
    {80, 1, 52429LL, 6},
    {81, 1, 51782LL, 6},
    {82, 1, 51151LL, 6},
    {83, 1, 50534LL, 6},
    {84, 1, 49933LL, 6},
    {85, 1, 49345LL, 6},
    {86, 1, 48771LL, 6},
    {87, 1, 48211LL, 6},
    {88, 1, 47663LL, 6},
    {89, 1, 47128LL, 6},
    {90, 1, 46604LL, 6},
    {91, 1, 46092LL, 6},
    {92, 1, 45591LL, 6},
    {93, 1, 45101LL, 6},
    {94, 1, 44621LL, 6},
    {95, 1, 44151LL, 6},
    {96, 1, 43691LL, 6},
    {97, 1, 43241LL, 6},
    {98, 1, 42800LL, 6},
    {99, 1, 42367LL, 6},
    {100, 1, 41944LL, 6},
    {101, 1, 41528LL, 6},
    {102, 1, 41121LL, 6},
    {103, 1, 40722LL, 6},
    {104, 1, 40330LL, 6},
    {105, 1, 39946LL, 6},
    {106, 1, 39569LL, 6},
    {107, 1, 39200LL, 6},
    {108, 1, 38837LL, 6},
    {109, 1, 38480LL, 6},
    {110, 1, 38131LL, 6},
    {111, 1, 37787LL, 6},
    {112, 1, 37450LL, 6},
    {113, 1, 37118LL, 6},
    {114, 1, 36793LL, 6},
    {115, 1, 36473LL, 6},
    {116, 1, 36158LL, 6},
    {117, 1, 35849LL, 6},
    {118, 1, 35545LL, 6},
    {119, 1, 35247LL, 6},
    {120, 1, 34953LL, 6},
    {121, 1, 34664LL, 6},
    {122, 1, 34380LL, 6},
    {123, 1, 34101LL, 6},
    {124, 1, 33826LL, 6},
    {125, 1, 33555LL, 6},
    {126, 1, 33289LL, 6},
    {127, 1, 33027LL, 6},
    {128, 1, 32769LL, 6},
    {129, 1, 65028LL, 7},
    {130, 1, 64528LL, 7},
    {131, 1, 64036LL, 7},
    {132, 1, 63551LL, 7},
    {133, 1, 63073LL, 7},
    {134, 1, 62602LL, 7},
    {135, 1, 62138LL, 7},
    {136, 1, 61681LL, 7},
    {137, 1, 61231LL, 7},
    {138, 1, 60788LL, 7},
    {139, 1, 60350LL, 7},
    {140, 1, 59919LL, 7},
    {141, 1, 59494LL, 7},
    {142, 1, 59075LL, 7},
    {143, 1, 58662LL, 7},
    {144, 1, 58255LL, 7},
    {145, 1, 57853LL, 7},
    {146, 1, 57457LL, 7},
    {147, 1, 57066LL, 7},
    {148, 1, 56680LL, 7},
    {149, 1, 56300LL, 7},
    {150, 1, 55925LL, 7},
    {151, 1, 55554LL, 7},
    {152, 1, 55189LL, 7},
    {153, 1, 54828LL, 7},
    {154, 1, 54472LL, 7},
    {155, 1, 54121LL, 7},
    {156, 1, 53774LL, 7},
    {157, 1, 53431LL, 7},
    {158, 1, 53093LL, 7},
    {159, 1, 52759LL, 7},
    {160, 1, 52429LL, 7},
    {161, 1, 52104LL, 7},
    {162, 1, 51782LL, 7},
    {163, 1, 51464LL, 7},
    {164, 1, 51151LL, 7},
    {165, 1, 50841LL, 7},
    {166, 1, 50534LL, 7},
    {167, 1, 50232LL, 7},
    {168, 1, 49933LL, 7},
    {169, 1, 49637LL, 7},
    {170, 1, 49345LL, 7},
    {171, 1, 49057LL, 7},
    {172, 1, 48771LL, 7},
    {173, 1, 48490LL, 7},
    {174, 1, 48211LL, 7},
    {175, 1, 47935LL, 7},
    {176, 1, 47663LL, 7},
    {177, 1, 47394LL, 7},
    {178, 1, 47128LL, 7},
    {179, 1, 46864LL, 7},
    {180, 1, 46604LL, 7},
    {181, 1, 46346LL, 7},
    {182, 1, 46092LL, 7},
    {183, 1, 45840LL, 7},
    {184, 1, 45591LL, 7},
    {185, 1, 45344LL, 7},
    {186, 1, 45101LL, 7},
    {187, 1, 44859LL, 7},
    {188, 1, 44621LL, 7},
    {189, 1, 44385LL, 7},
    {190, 1, 44151LL, 7},
    {191, 1, 43920LL, 7},
    {192, 1, 43691LL, 7},
    {193, 1, 43465LL, 7},
    {194, 1, 43241LL, 7},
    {195, 1, 43019LL, 7},
    {196, 1, 42800LL, 7},
    {197, 1, 42582LL, 7},
    {198, 1, 42367LL, 7},
    {199, 1, 42154LL, 7},
    {200, 1, 41944LL, 7},
    {201, 1, 41735LL, 7},
    {202, 1, 41528LL, 7},
    {203, 1, 41324LL, 7},
    {204, 1, 41121LL, 7},
    {205, 1, 40921LL, 7},
    {206, 1, 40722LL, 7},
    {207, 1, 40525LL, 7},
    {208, 1, 40330LL, 7},
    {209, 1, 40137LL, 7},
    {210, 1, 39946LL, 7},
    {211, 1, 39757LL, 7},
    {212, 1, 39569LL, 7},
    {213, 1, 39384LL, 7},
    {214, 1, 39200LL, 7},
    {215, 1, 39017LL, 7},
    {216, 1, 38837LL, 7},
    {217, 1, 38658LL, 7},
    {218, 1, 38480LL, 7},
    {219, 1, 38305LL, 7},
    {220, 1, 38131LL, 7},
    {221, 1, 37958LL, 7},
    {222, 1, 37787LL, 7},
    {223, 1, 37618LL, 7},
    {224, 1, 37450LL, 7},
    {225, 1, 37283LL, 7},
    {226, 1, 37118LL, 7},
    {227, 1, 36955LL, 7},
    {228, 1, 36793LL, 7},
    {229, 1, 36632LL, 7},
    {230, 1, 36473LL, 7},
    {231, 1, 36315LL, 7},
    {232, 1, 36158LL, 7},
    {233, 1, 36003LL, 7},
    {234, 1, 35849LL, 7},
    {235, 1, 35697LL, 7},
    {236, 1, 35545LL, 7},
    {237, 1, 35395LL, 7},
    {238, 1, 35247LL, 7},
    {239, 1, 35099LL, 7},
    {240, 1, 34953LL, 7},
    {241, 1, 34808LL, 7},
    {242, 1, 34664LL, 7},
    {243, 1, 34522LL, 7},
    {244, 1, 34380LL, 7},
    {245, 1, 34240LL, 7},
    {246, 1, 34101LL, 7},
    {247, 1, 33962LL, 7},
    {248, 1, 33826LL, 7},
    {249, 1, 33690LL, 7},
    {250, 1, 33555LL, 7},
    {251, 1, 33421LL, 7},
    {252, 1, 33289LL, 7},
    {253, 1, 33157LL, 7},
    {254, 1, 33027LL, 7},
    {255, 1, 32897LL, 7},
};
const int64_t table_runtime_srz16[256][4] = {
    {0, 0, 0, 0},  // unused
    {0, 0, 0, 0},  // unused
    {2, 1, 32769LL, 0},
    {3, 1, 43691LL, 1},
    {4, 1, 32769LL, 1},
    {5, 1, 52429LL, 2},
    {6, 1, 43691LL, 2},
    {7, 1, 37450LL, 2},
    {8, 1, 32769LL, 2},
    {9, 1, 58255LL, 3},
    {10, 1, 52429LL, 3},
    {11, 1, 47663LL, 3},
    {12, 1, 43691LL, 3},
    {13, 1, 40330LL, 3},
    {14, 1, 37450LL, 3},
    {15, 1, 34953LL, 3},
    {16, 1, 32769LL, 3},
    {17, 1, 61681LL, 4},
    {18, 1, 58255LL, 4},
    {19, 1, 55189LL, 4},
    {20, 1, 52429LL, 4},
    {21, 1, 49933LL, 4},
    {22, 1, 47663LL, 4},
    {23, 1, 45591LL, 4},
    {24, 1, 43691LL, 4},
    {25, 1, 41944LL, 4},
    {26, 1, 40330LL, 4},
    {27, 1, 38837LL, 4},
    {28, 1, 37450LL, 4},
    {29, 1, 36158LL, 4},
    {30, 1, 34953LL, 4},
    {31, 1, 33826LL, 4},
    {32, 1, 32769LL, 4},
    {33, 1, 63551LL, 5},
    {34, 1, 61681LL, 5},
    {35, 1, 59919LL, 5},
    {36, 1, 58255LL, 5},
    {37, 1, 56680LL, 5},
    {38, 1, 55189LL, 5},
    {39, 1, 53774LL, 5},
    {40, 1, 52429LL, 5},
    {41, 1, 51151LL, 5},
    {42, 1, 49933LL, 5},
    {43, 1, 48771LL, 5},
    {44, 1, 47663LL, 5},
    {45, 1, 46604LL, 5},
    {46, 1, 45591LL, 5},
    {47, 1, 44621LL, 5},
    {48, 1, 43691LL, 5},
    {49, 1, 42800LL, 5},
    {50, 1, 41944LL, 5},
    {51, 1, 41121LL, 5},
    {52, 1, 40330LL, 5},
    {53, 1, 39569LL, 5},
    {54, 1, 38837LL, 5},
    {55, 1, 38131LL, 5},
    {56, 1, 37450LL, 5},
    {57, 1, 36793LL, 5},
    {58, 1, 36158LL, 5},
    {59, 1, 35545LL, 5},
    {60, 1, 34953LL, 5},
    {61, 1, 34380LL, 5},
    {62, 1, 33826LL, 5},
    {63, 1, 33289LL, 5},
    {64, 1, 32769LL, 5},
    {65, 1, 64528LL, 6},
    {66, 1, 63551LL, 6},
    {67, 1, 62602LL, 6},
    {68, 1, 61681LL, 6},
    {69, 1, 60788LL, 6},
    {70, 1, 59919LL, 6},
    {71, 1, 59075LL, 6},
    {72, 1, 58255LL, 6},
    {73, 1, 57457LL, 6},
    {74, 1, 56680LL, 6},
    {75, 1, 55925LL, 6},
    {76, 1, 55189LL, 6},
    {77, 1, 54472LL, 6},
    {78, 1, 53774LL, 6},
    {79, 1, 53093LL, 6},
    {80, 1, 52429LL, 6},
    {81, 1, 51782LL, 6},
    {82, 1, 51151LL, 6},
    {83, 1, 50534LL, 6},
    {84, 1, 49933LL, 6},
    {85, 1, 49345LL, 6},
    {86, 1, 48771LL, 6},
    {87, 1, 48211LL, 6},
    {88, 1, 47663LL, 6},
    {89, 1, 47128LL, 6},
    {90, 1, 46604LL, 6},
    {91, 1, 46092LL, 6},
    {92, 1, 45591LL, 6},
    {93, 1, 45101LL, 6},
    {94, 1, 44621LL, 6},
    {95, 1, 44151LL, 6},
    {96, 1, 43691LL, 6},
    {97, 1, 43241LL, 6},
    {98, 1, 42800LL, 6},
    {99, 1, 42367LL, 6},
    {100, 1, 41944LL, 6},
    {101, 1, 41528LL, 6},
    {102, 1, 41121LL, 6},
    {103, 1, 40722LL, 6},
    {104, 1, 40330LL, 6},
    {105, 1, 39946LL, 6},
    {106, 1, 39569LL, 6},
    {107, 1, 39200LL, 6},
    {108, 1, 38837LL, 6},
    {109, 1, 38480LL, 6},
    {110, 1, 38131LL, 6},
    {111, 1, 37787LL, 6},
    {112, 1, 37450LL, 6},
    {113, 1, 37118LL, 6},
    {114, 1, 36793LL, 6},
    {115, 1, 36473LL, 6},
    {116, 1, 36158LL, 6},
    {117, 1, 35849LL, 6},
    {118, 1, 35545LL, 6},
    {119, 1, 35247LL, 6},
    {120, 1, 34953LL, 6},
    {121, 1, 34664LL, 6},
    {122, 1, 34380LL, 6},
    {123, 1, 34101LL, 6},
    {124, 1, 33826LL, 6},
    {125, 1, 33555LL, 6},
    {126, 1, 33289LL, 6},
    {127, 1, 33027LL, 6},
    {128, 1, 32769LL, 6},
    {129, 1, 65028LL, 7},
    {130, 1, 64528LL, 7},
    {131, 1, 64036LL, 7},
    {132, 1, 63551LL, 7},
    {133, 1, 63073LL, 7},
    {134, 1, 62602LL, 7},
    {135, 1, 62138LL, 7},
    {136, 1, 61681LL, 7},
    {137, 1, 61231LL, 7},
    {138, 1, 60788LL, 7},
    {139, 1, 60350LL, 7},
    {140, 1, 59919LL, 7},
    {141, 1, 59494LL, 7},
    {142, 1, 59075LL, 7},
    {143, 1, 58662LL, 7},
    {144, 1, 58255LL, 7},
    {145, 1, 57853LL, 7},
    {146, 1, 57457LL, 7},
    {147, 1, 57066LL, 7},
    {148, 1, 56680LL, 7},
    {149, 1, 56300LL, 7},
    {150, 1, 55925LL, 7},
    {151, 1, 55554LL, 7},
    {152, 1, 55189LL, 7},
    {153, 1, 54828LL, 7},
    {154, 1, 54472LL, 7},
    {155, 1, 54121LL, 7},
    {156, 1, 53774LL, 7},
    {157, 1, 53431LL, 7},
    {158, 1, 53093LL, 7},
    {159, 1, 52759LL, 7},
    {160, 1, 52429LL, 7},
    {161, 1, 52104LL, 7},
    {162, 1, 51782LL, 7},
    {163, 1, 51464LL, 7},
    {164, 1, 51151LL, 7},
    {165, 1, 50841LL, 7},
    {166, 1, 50534LL, 7},
    {167, 1, 50232LL, 7},
    {168, 1, 49933LL, 7},
    {169, 1, 49637LL, 7},
    {170, 1, 49345LL, 7},
    {171, 1, 49057LL, 7},
    {172, 1, 48771LL, 7},
    {173, 1, 48490LL, 7},
    {174, 1, 48211LL, 7},
    {175, 1, 47935LL, 7},
    {176, 1, 47663LL, 7},
    {177, 1, 47394LL, 7},
    {178, 1, 47128LL, 7},
    {179, 1, 46864LL, 7},
    {180, 1, 46604LL, 7},
    {181, 1, 46346LL, 7},
    {182, 1, 46092LL, 7},
    {183, 1, 45840LL, 7},
    {184, 1, 45591LL, 7},
    {185, 1, 45344LL, 7},
    {186, 1, 45101LL, 7},
    {187, 1, 44859LL, 7},
    {188, 1, 44621LL, 7},
    {189, 1, 44385LL, 7},
    {190, 1, 44151LL, 7},
    {191, 1, 43920LL, 7},
    {192, 1, 43691LL, 7},
    {193, 1, 43465LL, 7},
    {194, 1, 43241LL, 7},
    {195, 1, 43019LL, 7},
    {196, 1, 42800LL, 7},
    {197, 1, 42582LL, 7},
    {198, 1, 42367LL, 7},
    {199, 1, 42154LL, 7},
    {200, 1, 41944LL, 7},
    {201, 1, 41735LL, 7},
    {202, 1, 41528LL, 7},
    {203, 1, 41324LL, 7},
    {204, 1, 41121LL, 7},
    {205, 1, 40921LL, 7},
    {206, 1, 40722LL, 7},
    {207, 1, 40525LL, 7},
    {208, 1, 40330LL, 7},
    {209, 1, 40137LL, 7},
    {210, 1, 39946LL, 7},
    {211, 1, 39757LL, 7},
    {212, 1, 39569LL, 7},
    {213, 1, 39384LL, 7},
    {214, 1, 39200LL, 7},
    {215, 1, 39017LL, 7},
    {216, 1, 38837LL, 7},
    {217, 1, 38658LL, 7},
    {218, 1, 38480LL, 7},
    {219, 1, 38305LL, 7},
    {220, 1, 38131LL, 7},
    {221, 1, 37958LL, 7},
    {222, 1, 37787LL, 7},
    {223, 1, 37618LL, 7},
    {224, 1, 37450LL, 7},
    {225, 1, 37283LL, 7},
    {226, 1, 37118LL, 7},
    {227, 1, 36955LL, 7},
    {228, 1, 36793LL, 7},
    {229, 1, 36632LL, 7},
    {230, 1, 36473LL, 7},
    {231, 1, 36315LL, 7},
    {232, 1, 36158LL, 7},
    {233, 1, 36003LL, 7},
    {234, 1, 35849LL, 7},
    {235, 1, 35697LL, 7},
    {236, 1, 35545LL, 7},
    {237, 1, 35395LL, 7},
    {238, 1, 35247LL, 7},
    {239, 1, 35099LL, 7},
    {240, 1, 34953LL, 7},
    {241, 1, 34808LL, 7},
    {242, 1, 34664LL, 7},
    {243, 1, 34522LL, 7},
    {244, 1, 34380LL, 7},
    {245, 1, 34240LL, 7},
    {246, 1, 34101LL, 7},
    {247, 1, 33962LL, 7},
    {248, 1, 33826LL, 7},
    {249, 1, 33690LL, 7},
    {250, 1, 33555LL, 7},
    {251, 1, 33421LL, 7},
    {252, 1, 33289LL, 7},
    {253, 1, 33157LL, 7},
    {254, 1, 33027LL, 7},
    {255, 1, 32897LL, 7},
};
const int64_t table_runtime_u32[256][4] = {
    {0, 0, 0, 0},  // unused
    {0, 0, 0, 0},  // unused
    {2, 2, 1ULL, 0},
    {3, 2, 1431655766ULL, 1},
    {4, 2, 1ULL, 1},
    {5, 2, 2576980378ULL, 2},
    {6, 2, 1431655766ULL, 2},
    {7, 2, 613566757ULL, 2},
    {8, 2, 1ULL, 2},
    {9, 2, 3340530120ULL, 3},
    {10, 2, 2576980378ULL, 3},
    {11, 2, 1952257862ULL, 3},
    {12, 2, 1431655766ULL, 3},
    {13, 2, 991146300ULL, 3},
    {14, 2, 613566757ULL, 3},
    {15, 2, 286331154ULL, 3},
    {16, 2, 1ULL, 3},
    {17, 2, 3789677026ULL, 4},
    {18, 2, 3340530120ULL, 4},
    {19, 2, 2938661835ULL, 4},
    {20, 2, 2576980378ULL, 4},
    {21, 2, 2249744775ULL, 4},
    {22, 2, 1952257862ULL, 4},
    {23, 2, 1680639377ULL, 4},
    {24, 2, 1431655766ULL, 4},
    {25, 2, 1202590843ULL, 4},
    {26, 2, 991146300ULL, 4},
    {27, 2, 795364315ULL, 4},
    {28, 2, 613566757ULL, 4},
    {29, 2, 444306962ULL, 4},
    {30, 2, 286331154ULL, 4},
    {31, 2, 138547333ULL, 4},
    {32, 2, 1ULL, 4},
    {33, 2, 4034666248ULL, 5},
    {34, 2, 3789677026ULL, 5},
    {35, 2, 3558687189ULL, 5},
    {36, 2, 3340530120ULL, 5},
    {37, 2, 3134165325ULL, 5},
    {38, 2, 2938661835ULL, 5},
    {39, 2, 2753184165ULL, 5},
    {40, 2, 2576980378ULL, 5},
    {41, 2, 2409371898ULL, 5},
    {42, 2, 2249744775ULL, 5},
    {43, 2, 2097542168ULL, 5},
    {44, 2, 1952257862ULL, 5},
    {45, 2, 1813430637ULL, 5},
    {46, 2, 1680639377ULL, 5},
    {47, 2, 1553498810ULL, 5},
    {48, 2, 1431655766ULL, 5},
    {49, 2, 1314785907ULL, 5},
    {50, 2, 1202590843ULL, 5},
    {51, 2, 1094795586ULL, 5},
    {52, 2, 991146300ULL, 5},
    {53, 2, 891408307ULL, 5},
    {54, 2, 795364315ULL, 5},
    {55, 2, 702812831ULL, 5},
    {56, 2, 613566757ULL, 5},
    {57, 2, 527452125ULL, 5},
    {58, 2, 444306962ULL, 5},
    {59, 2, 363980280ULL, 5},
    {60, 2, 286331154ULL, 5},
    {61, 2, 211227900ULL, 5},
    {62, 2, 138547333ULL, 5},
    {63, 2, 68174085ULL, 5},
    {64, 2, 1ULL, 5},
    {65, 2, 4162814457ULL, 6},
    {66, 2, 4034666248ULL, 6},
    {67, 2, 3910343360ULL, 6},
    {68, 2, 3789677026ULL, 6},
    {69, 2, 3672508268ULL, 6},
    {70, 2, 3558687189ULL, 6},
    {71, 2, 3448072337ULL, 6},
    {72, 2, 3340530120ULL, 6},
    {73, 2, 3235934265ULL, 6},
    {74, 2, 3134165325ULL, 6},
    {75, 2, 3035110223ULL, 6},
    {76, 2, 2938661835ULL, 6},
    {77, 2, 2844718599ULL, 6},
    {78, 2, 2753184165ULL, 6},
    {79, 2, 2663967058ULL, 6},
    {80, 2, 2576980378ULL, 6},
    {81, 2, 2492141518ULL, 6},
    {82, 2, 2409371898ULL, 6},
    {83, 2, 2328596727ULL, 6},
    {84, 2, 2249744775ULL, 6},
    {85, 2, 2172748162ULL, 6},
    {86, 2, 2097542168ULL, 6},
    {87, 2, 2024065048ULL, 6},
    {88, 2, 1952257862ULL, 6},
    {89, 2, 1882064321ULL, 6},
    {90, 2, 1813430637ULL, 6},
    {91, 2, 1746305385ULL, 6},
    {92, 2, 1680639377ULL, 6},
    {93, 2, 1616385542ULL, 6},
    {94, 2, 1553498810ULL, 6},
    {95, 2, 1491936009ULL, 6},
    {96, 2, 1431655766ULL, 6},
    {97, 2, 1372618415ULL, 6},
    {98, 2, 1314785907ULL, 6},
    {99, 2, 1258121734ULL, 6},
    {100, 2, 1202590843ULL, 6},
    {101, 2, 1148159575ULL, 6},
    {102, 2, 1094795586ULL, 6},
    {103, 2, 1042467791ULL, 6},
    {104, 2, 991146300ULL, 6},
    {105, 2, 940802361ULL, 6},
    {106, 2, 891408307ULL, 6},
    {107, 2, 842937507ULL, 6},
    {108, 2, 795364315ULL, 6},
    {109, 2, 748664025ULL, 6},
    {110, 2, 702812831ULL, 6},
    {111, 2, 657787785ULL, 6},
    {112, 2, 613566757ULL, 6},
    {113, 2, 570128403ULL, 6},
    {114, 2, 527452125ULL, 6},
    {115, 2, 485518043ULL, 6},
    {116, 2, 444306962ULL, 6},
    {117, 2, 403800345ULL, 6},
    {118, 2, 363980280ULL, 6},
    {119, 2, 324829460ULL, 6},
    {120, 2, 286331154ULL, 6},
    {121, 2, 248469183ULL, 6},
    {122, 2, 211227900ULL, 6},
    {123, 2, 174592167ULL, 6},
    {124, 2, 138547333ULL, 6},
    {125, 2, 103079216ULL, 6},
    {126, 2, 68174085ULL, 6},
    {127, 2, 33818641ULL, 6},
    {128, 2, 1ULL, 6},
    {129, 2, 4228378656ULL, 7},
    {130, 2, 4162814457ULL, 7},
    {131, 2, 4098251237ULL, 7},
    {132, 2, 4034666248ULL, 7},
    {133, 2, 3972037425ULL, 7},
    {134, 2, 3910343360ULL, 7},
    {135, 2, 3849563281ULL, 7},
    {136, 2, 3789677026ULL, 7},
    {137, 2, 3730665024ULL, 7},
    {138, 2, 3672508268ULL, 7},
    {139, 2, 3615188300ULL, 7},
    {140, 2, 3558687189ULL, 7},
    {141, 2, 3502987511ULL, 7},
    {142, 2, 3448072337ULL, 7},
    {143, 2, 3393925206ULL, 7},
    {144, 2, 3340530120ULL, 7},
    {145, 2, 3287871517ULL, 7},
    {146, 2, 3235934265ULL, 7},
    {147, 2, 3184703642ULL, 7},
    {148, 2, 3134165325ULL, 7},
    {149, 2, 3084305374ULL, 7},
    {150, 2, 3035110223ULL, 7},
    {151, 2, 2986566663ULL, 7},
    {152, 2, 2938661835ULL, 7},
    {153, 2, 2891383213ULL, 7},
    {154, 2, 2844718599ULL, 7},
    {155, 2, 2798656110ULL, 7},
    {156, 2, 2753184165ULL, 7},
    {157, 2, 2708291480ULL, 7},
    {158, 2, 2663967058ULL, 7},
    {159, 2, 2620200175ULL, 7},
    {160, 2, 2576980378ULL, 7},
    {161, 2, 2534297473ULL, 7},
    {162, 2, 2492141518ULL, 7},
    {163, 2, 2450502814ULL, 7},
    {164, 2, 2409371898ULL, 7},
    {165, 2, 2368739540ULL, 7},
    {166, 2, 2328596727ULL, 7},
    {167, 2, 2288934667ULL, 7},
    {168, 2, 2249744775ULL, 7},
    {169, 2, 2211018668ULL, 7},
    {170, 2, 2172748162ULL, 7},
    {171, 2, 2134925265ULL, 7},
    {172, 2, 2097542168ULL, 7},
    {173, 2, 2060591247ULL, 7},
    {174, 2, 2024065048ULL, 7},
    {175, 2, 1987956292ULL, 7},
    {176, 2, 1952257862ULL, 7},
    {177, 2, 1916962805ULL, 7},
    {178, 2, 1882064321ULL, 7},
    {179, 2, 1847555765ULL, 7},
    {180, 2, 1813430637ULL, 7},
    {181, 2, 1779682582ULL, 7},
    {182, 2, 1746305385ULL, 7},
    {183, 2, 1713292966ULL, 7},
    {184, 2, 1680639377ULL, 7},
    {185, 2, 1648338801ULL, 7},
    {186, 2, 1616385542ULL, 7},
    {187, 2, 1584774030ULL, 7},
    {188, 2, 1553498810ULL, 7},
    {189, 2, 1522554545ULL, 7},
    {190, 2, 1491936009ULL, 7},
    {191, 2, 1461638086ULL, 7},
    {192, 2, 1431655766ULL, 7},
    {193, 2, 1401984144ULL, 7},
    {194, 2, 1372618415ULL, 7},
    {195, 2, 1343553873ULL, 7},
    {196, 2, 1314785907ULL, 7},
    {197, 2, 1286310003ULL, 7},
    {198, 2, 1258121734ULL, 7},
    {199, 2, 1230216764ULL, 7},
    {200, 2, 1202590843ULL, 7},
    {201, 2, 1175239808ULL, 7},
    {202, 2, 1148159575ULL, 7},
    {203, 2, 1121346142ULL, 7},
    {204, 2, 1094795586ULL, 7},
    {205, 2, 1068504060ULL, 7},
    {206, 2, 1042467791ULL, 7},
    {207, 2, 1016683080ULL, 7},
    {208, 2, 991146300ULL, 7},
    {209, 2, 965853890ULL, 7},
    {210, 2, 940802361ULL, 7},
    {211, 2, 915988286ULL, 7},
    {212, 2, 891408307ULL, 7},
    {213, 2, 867059126ULL, 7},
    {214, 2, 842937507ULL, 7},
    {215, 2, 819040276ULL, 7},
    {216, 2, 795364315ULL, 7},
    {217, 2, 771906565ULL, 7},
    {218, 2, 748664025ULL, 7},
    {219, 2, 725633745ULL, 7},
    {220, 2, 702812831ULL, 7},
    {221, 2, 680198441ULL, 7},
    {222, 2, 657787785ULL, 7},
    {223, 2, 635578121ULL, 7},
    {224, 2, 613566757ULL, 7},
    {225, 2, 591751050ULL, 7},
    {226, 2, 570128403ULL, 7},
    {227, 2, 548696263ULL, 7},
    {228, 2, 527452125ULL, 7},
    {229, 2, 506393524ULL, 7},
    {230, 2, 485518043ULL, 7},
    {231, 2, 464823301ULL, 7},
    {232, 2, 444306962ULL, 7},
    {233, 2, 423966729ULL, 7},
    {234, 2, 403800345ULL, 7},
    {235, 2, 383805589ULL, 7},
    {236, 2, 363980280ULL, 7},
    {237, 2, 344322273ULL, 7},
    {238, 2, 324829460ULL, 7},
    {239, 2, 305499766ULL, 7},
    {240, 2, 286331154ULL, 7},
    {241, 2, 267321616ULL, 7},
    {242, 2, 248469183ULL, 7},
    {243, 2, 229771913ULL, 7},
    {244, 2, 211227900ULL, 7},
    {245, 2, 192835267ULL, 7},
    {246, 2, 174592167ULL, 7},
    {247, 2, 156496785ULL, 7},
    {248, 2, 138547333ULL, 7},
    {249, 2, 120742053ULL, 7},
    {250, 2, 103079216ULL, 7},
    {251, 2, 85557118ULL, 7},
    {252, 2, 68174085ULL, 7},
    {253, 2, 50928466ULL, 7},
    {254, 2, 33818641ULL, 7},
    {255, 2, 16843010ULL, 7},
};
const int64_t table_runtime_s32[256][4] = {
    {0, 0, 0, 0},  // unused
    {0, 0, 0, 0},  // unused
    {2, 1, 2147483649LL, 0},
    {3, 1, 2863311531LL, 1},
    {4, 1, 2147483649LL, 1},
    {5, 1, 3435973837LL, 2},
    {6, 1, 2863311531LL, 2},
    {7, 1, 2454267027LL, 2},
    {8, 1, 2147483649LL, 2},
    {9, 1, 3817748708LL, 3},
    {10, 1, 3435973837LL, 3},
    {11, 1, 3123612579LL, 3},
    {12, 1, 2863311531LL, 3},
    {13, 1, 2643056798LL, 3},
    {14, 1, 2454267027LL, 3},
    {15, 1, 2290649225LL, 3},
    {16, 1, 2147483649LL, 3},
    {17, 1, 4042322161LL, 4},
    {18, 1, 3817748708LL, 4},
    {19, 1, 3616814566LL, 4},
    {20, 1, 3435973837LL, 4},
    {21, 1, 3272356036LL, 4},
    {22, 1, 3123612579LL, 4},
    {23, 1, 2987803337LL, 4},
    {24, 1, 2863311531LL, 4},
    {25, 1, 2748779070LL, 4},
    {26, 1, 2643056798LL, 4},
    {27, 1, 2545165806LL, 4},
    {28, 1, 2454267027LL, 4},
    {29, 1, 2369637129LL, 4},
    {30, 1, 2290649225LL, 4},
    {31, 1, 2216757315LL, 4},
    {32, 1, 2147483649LL, 4},
    {33, 1, 4164816772LL, 5},
    {34, 1, 4042322161LL, 5},
    {35, 1, 3926827243LL, 5},
    {36, 1, 3817748708LL, 5},
    {37, 1, 3714566311LL, 5},
    {38, 1, 3616814566LL, 5},
    {39, 1, 3524075731LL, 5},
    {40, 1, 3435973837LL, 5},
    {41, 1, 3352169597LL, 5},
    {42, 1, 3272356036LL, 5},
    {43, 1, 3196254732LL, 5},
    {44, 1, 3123612579LL, 5},
    {45, 1, 3054198967LL, 5},
    {46, 1, 2987803337LL, 5},
    {47, 1, 2924233053LL, 5},
    {48, 1, 2863311531LL, 5},
    {49, 1, 2804876602LL, 5},
    {50, 1, 2748779070LL, 5},
    {51, 1, 2694881441LL, 5},
    {52, 1, 2643056798LL, 5},
    {53, 1, 2593187802LL, 5},
    {54, 1, 2545165806LL, 5},
    {55, 1, 2498890064LL, 5},
    {56, 1, 2454267027LL, 5},
    {57, 1, 2411209711LL, 5},
    {58, 1, 2369637129LL, 5},
    {59, 1, 2329473788LL, 5},
    {60, 1, 2290649225LL, 5},
    {61, 1, 2253097598LL, 5},
    {62, 1, 2216757315LL, 5},
    {63, 1, 2181570691LL, 5},
    {64, 1, 2147483649LL, 5},
    {65, 1, 4228890877LL, 6},
    {66, 1, 4164816772LL, 6},
    {67, 1, 4102655328LL, 6},
    {68, 1, 4042322161LL, 6},
    {69, 1, 3983737782LL, 6},
    {70, 1, 3926827243LL, 6},
    {71, 1, 3871519817LL, 6},
    {72, 1, 3817748708LL, 6},
    {73, 1, 3765450781LL, 6},
    {74, 1, 3714566311LL, 6},
    {75, 1, 3665038760LL, 6},
    {76, 1, 3616814566LL, 6},
    {77, 1, 3569842948LL, 6},
    {78, 1, 3524075731LL, 6},
    {79, 1, 3479467177LL, 6},
    {80, 1, 3435973837LL, 6},
    {81, 1, 3393554407LL, 6},
    {82, 1, 3352169597LL, 6},
    {83, 1, 3311782012LL, 6},
    {84, 1, 3272356036LL, 6},
    {85, 1, 3233857729LL, 6},
    {86, 1, 3196254732LL, 6},
    {87, 1, 3159516172LL, 6},
    {88, 1, 3123612579LL, 6},
    {89, 1, 3088515809LL, 6},
    {90, 1, 3054198967LL, 6},
    {91, 1, 3020636341LL, 6},
    {92, 1, 2987803337LL, 6},
    {93, 1, 2955676419LL, 6},
    {94, 1, 2924233053LL, 6},
    {95, 1, 2893451653LL, 6},
    {96, 1, 2863311531LL, 6},
    {97, 1, 2833792856LL, 6},
    {98, 1, 2804876602LL, 6},
    {99, 1, 2776544515LL, 6},
    {100, 1, 2748779070LL, 6},
    {101, 1, 2721563436LL, 6},
    {102, 1, 2694881441LL, 6},
    {103, 1, 2668717544LL, 6},
    {104, 1, 2643056798LL, 6},
    {105, 1, 2617884829LL, 6},
    {106, 1, 2593187802LL, 6},
    {107, 1, 2568952402LL, 6},
    {108, 1, 2545165806LL, 6},
    {109, 1, 2521815661LL, 6},
    {110, 1, 2498890064LL, 6},
    {111, 1, 2476377541LL, 6},
    {112, 1, 2454267027LL, 6},
    {113, 1, 2432547850LL, 6},
    {114, 1, 2411209711LL, 6},
    {115, 1, 2390242670LL, 6},
    {116, 1, 2369637129LL, 6},
    {117, 1, 2349383821LL, 6},
    {118, 1, 2329473788LL, 6},
    {119, 1, 2309898378LL, 6},
    {120, 1, 2290649225LL, 6},
    {121, 1, 2271718240LL, 6},
    {122, 1, 2253097598LL, 6},
    {123, 1, 2234779732LL, 6},
    {124, 1, 2216757315LL, 6},
    {125, 1, 2199023256LL, 6},
    {126, 1, 2181570691LL, 6},
    {127, 1, 2164392969LL, 6},
    {128, 1, 2147483649LL, 6},
    {129, 1, 4261672976LL, 7},
    {130, 1, 4228890877LL, 7},
    {131, 1, 4196609267LL, 7},
    {132, 1, 4164816772LL, 7},
    {133, 1, 4133502361LL, 7},
    {134, 1, 4102655328LL, 7},
    {135, 1, 4072265289LL, 7},
    {136, 1, 4042322161LL, 7},
    {137, 1, 4012816160LL, 7},
    {138, 1, 3983737782LL, 7},
    {139, 1, 3955077798LL, 7},
    {140, 1, 3926827243LL, 7},
    {141, 1, 3898977404LL, 7},
    {142, 1, 3871519817LL, 7},
    {143, 1, 3844446251LL, 7},
    {144, 1, 3817748708LL, 7},
    {145, 1, 3791419407LL, 7},
    {146, 1, 3765450781LL, 7},
    {147, 1, 3739835469LL, 7},
    {148, 1, 3714566311LL, 7},
    {149, 1, 3689636335LL, 7},
    {150, 1, 3665038760LL, 7},
    {151, 1, 3640766980LL, 7},
    {152, 1, 3616814566LL, 7},
    {153, 1, 3593175255LL, 7},
    {154, 1, 3569842948LL, 7},
    {155, 1, 3546811703LL, 7},
    {156, 1, 3524075731LL, 7},
    {157, 1, 3501629388LL, 7},
    {158, 1, 3479467177LL, 7},
    {159, 1, 3457583736LL, 7},
    {160, 1, 3435973837LL, 7},
    {161, 1, 3414632385LL, 7},
    {162, 1, 3393554407LL, 7},
    {163, 1, 3372735055LL, 7},
    {164, 1, 3352169597LL, 7},
    {165, 1, 3331853418LL, 7},
    {166, 1, 3311782012LL, 7},
    {167, 1, 3291950982LL, 7},
    {168, 1, 3272356036LL, 7},
    {169, 1, 3252992982LL, 7},
    {170, 1, 3233857729LL, 7},
    {171, 1, 3214946281LL, 7},
    {172, 1, 3196254732LL, 7},
    {173, 1, 3177779272LL, 7},
    {174, 1, 3159516172LL, 7},
    {175, 1, 3141461794LL, 7},
    {176, 1, 3123612579LL, 7},
    {177, 1, 3105965051LL, 7},
    {178, 1, 3088515809LL, 7},
    {179, 1, 3071261531LL, 7},
    {180, 1, 3054198967LL, 7},
    {181, 1, 3037324939LL, 7},
    {182, 1, 3020636341LL, 7},
    {183, 1, 3004130131LL, 7},
    {184, 1, 2987803337LL, 7},
    {185, 1, 2971653049LL, 7},
    {186, 1, 2955676419LL, 7},
    {187, 1, 2939870663LL, 7},
    {188, 1, 2924233053LL, 7},
    {189, 1, 2908760921LL, 7},
    {190, 1, 2893451653LL, 7},
    {191, 1, 2878302691LL, 7},
    {192, 1, 2863311531LL, 7},
    {193, 1, 2848475720LL, 7},
    {194, 1, 2833792856LL, 7},
    {195, 1, 2819260585LL, 7},
    {196, 1, 2804876602LL, 7},
    {197, 1, 2790638650LL, 7},
    {198, 1, 2776544515LL, 7},
    {199, 1, 2762592030LL, 7},
    {200, 1, 2748779070LL, 7},
    {201, 1, 2735103552LL, 7},
    {202, 1, 2721563436LL, 7},
    {203, 1, 2708156719LL, 7},
    {204, 1, 2694881441LL, 7},
    {205, 1, 2681735678LL, 7},
    {206, 1, 2668717544LL, 7},
    {207, 1, 2655825188LL, 7},
    {208, 1, 2643056798LL, 7},
    {209, 1, 2630410593LL, 7},
    {210, 1, 2617884829LL, 7},
    {211, 1, 2605477791LL, 7},
    {212, 1, 2593187802LL, 7},
    {213, 1, 2581013211LL, 7},
    {214, 1, 2568952402LL, 7},
    {215, 1, 2557003786LL, 7},
    {216, 1, 2545165806LL, 7},
    {217, 1, 2533436931LL, 7},
    {218, 1, 2521815661LL, 7},
    {219, 1, 2510300521LL, 7},
    {220, 1, 2498890064LL, 7},
    {221, 1, 2487582869LL, 7},
    {222, 1, 2476377541LL, 7},
    {223, 1, 2465272709LL, 7},
    {224, 1, 2454267027LL, 7},
    {225, 1, 2443359173LL, 7},
    {226, 1, 2432547850LL, 7},
    {227, 1, 2421831780LL, 7},
    {228, 1, 2411209711LL, 7},
    {229, 1, 2400680410LL, 7},
    {230, 1, 2390242670LL, 7},
    {231, 1, 2379895299LL, 7},
    {232, 1, 2369637129LL, 7},
    {233, 1, 2359467013LL, 7},
    {234, 1, 2349383821LL, 7},
    {235, 1, 2339386443LL, 7},
    {236, 1, 2329473788LL, 7},
    {237, 1, 2319644785LL, 7},
    {238, 1, 2309898378LL, 7},
    {239, 1, 2300233531LL, 7},
    {240, 1, 2290649225LL, 7},
    {241, 1, 2281144456LL, 7},
    {242, 1, 2271718240LL, 7},
    {243, 1, 2262369605LL, 7},
    {244, 1, 2253097598LL, 7},
    {245, 1, 2243901282LL, 7},
    {246, 1, 2234779732LL, 7},
    {247, 1, 2225732041LL, 7},
    {248, 1, 2216757315LL, 7},
    {249, 1, 2207854675LL, 7},
    {250, 1, 2199023256LL, 7},
    {251, 1, 2190262207LL, 7},
    {252, 1, 2181570691LL, 7},
    {253, 1, 2172947881LL, 7},
    {254, 1, 2164392969LL, 7},
    {255, 1, 2155905153LL, 7},
};
const int64_t table_runtime_srz32[256][4] = {
    {0, 0, 0, 0},  // unused
    {0, 0, 0, 0},  // unused
    {2, 1, 2147483649LL, 0},
    {3, 1, 2863311531LL, 1},
    {4, 1, 2147483649LL, 1},
    {5, 1, 3435973837LL, 2},
    {6, 1, 2863311531LL, 2},
    {7, 1, 2454267027LL, 2},
    {8, 1, 2147483649LL, 2},
    {9, 1, 3817748708LL, 3},
    {10, 1, 3435973837LL, 3},
    {11, 1, 3123612579LL, 3},
    {12, 1, 2863311531LL, 3},
    {13, 1, 2643056798LL, 3},
    {14, 1, 2454267027LL, 3},
    {15, 1, 2290649225LL, 3},
    {16, 1, 2147483649LL, 3},
    {17, 1, 4042322161LL, 4},
    {18, 1, 3817748708LL, 4},
    {19, 1, 3616814566LL, 4},
    {20, 1, 3435973837LL, 4},
    {21, 1, 3272356036LL, 4},
    {22, 1, 3123612579LL, 4},
    {23, 1, 2987803337LL, 4},
    {24, 1, 2863311531LL, 4},
    {25, 1, 2748779070LL, 4},
    {26, 1, 2643056798LL, 4},
    {27, 1, 2545165806LL, 4},
    {28, 1, 2454267027LL, 4},
    {29, 1, 2369637129LL, 4},
    {30, 1, 2290649225LL, 4},
    {31, 1, 2216757315LL, 4},
    {32, 1, 2147483649LL, 4},
    {33, 1, 4164816772LL, 5},
    {34, 1, 4042322161LL, 5},
    {35, 1, 3926827243LL, 5},
    {36, 1, 3817748708LL, 5},
    {37, 1, 3714566311LL, 5},
    {38, 1, 3616814566LL, 5},
    {39, 1, 3524075731LL, 5},
    {40, 1, 3435973837LL, 5},
    {41, 1, 3352169597LL, 5},
    {42, 1, 3272356036LL, 5},
    {43, 1, 3196254732LL, 5},
    {44, 1, 3123612579LL, 5},
    {45, 1, 3054198967LL, 5},
    {46, 1, 2987803337LL, 5},
    {47, 1, 2924233053LL, 5},
    {48, 1, 2863311531LL, 5},
    {49, 1, 2804876602LL, 5},
    {50, 1, 2748779070LL, 5},
    {51, 1, 2694881441LL, 5},
    {52, 1, 2643056798LL, 5},
    {53, 1, 2593187802LL, 5},
    {54, 1, 2545165806LL, 5},
    {55, 1, 2498890064LL, 5},
    {56, 1, 2454267027LL, 5},
    {57, 1, 2411209711LL, 5},
    {58, 1, 2369637129LL, 5},
    {59, 1, 2329473788LL, 5},
    {60, 1, 2290649225LL, 5},
    {61, 1, 2253097598LL, 5},
    {62, 1, 2216757315LL, 5},
    {63, 1, 2181570691LL, 5},
    {64, 1, 2147483649LL, 5},
    {65, 1, 4228890877LL, 6},
    {66, 1, 4164816772LL, 6},
    {67, 1, 4102655328LL, 6},
    {68, 1, 4042322161LL, 6},
    {69, 1, 3983737782LL, 6},
    {70, 1, 3926827243LL, 6},
    {71, 1, 3871519817LL, 6},
    {72, 1, 3817748708LL, 6},
    {73, 1, 3765450781LL, 6},
    {74, 1, 3714566311LL, 6},
    {75, 1, 3665038760LL, 6},
    {76, 1, 3616814566LL, 6},
    {77, 1, 3569842948LL, 6},
    {78, 1, 3524075731LL, 6},
    {79, 1, 3479467177LL, 6},
    {80, 1, 3435973837LL, 6},
    {81, 1, 3393554407LL, 6},
    {82, 1, 3352169597LL, 6},
    {83, 1, 3311782012LL, 6},
    {84, 1, 3272356036LL, 6},
    {85, 1, 3233857729LL, 6},
    {86, 1, 3196254732LL, 6},
    {87, 1, 3159516172LL, 6},
    {88, 1, 3123612579LL, 6},
    {89, 1, 3088515809LL, 6},
    {90, 1, 3054198967LL, 6},
    {91, 1, 3020636341LL, 6},
    {92, 1, 2987803337LL, 6},
    {93, 1, 2955676419LL, 6},
    {94, 1, 2924233053LL, 6},
    {95, 1, 2893451653LL, 6},
    {96, 1, 2863311531LL, 6},
    {97, 1, 2833792856LL, 6},
    {98, 1, 2804876602LL, 6},
    {99, 1, 2776544515LL, 6},
    {100, 1, 2748779070LL, 6},
    {101, 1, 2721563436LL, 6},
    {102, 1, 2694881441LL, 6},
    {103, 1, 2668717544LL, 6},
    {104, 1, 2643056798LL, 6},
    {105, 1, 2617884829LL, 6},
    {106, 1, 2593187802LL, 6},
    {107, 1, 2568952402LL, 6},
    {108, 1, 2545165806LL, 6},
    {109, 1, 2521815661LL, 6},
    {110, 1, 2498890064LL, 6},
    {111, 1, 2476377541LL, 6},
    {112, 1, 2454267027LL, 6},
    {113, 1, 2432547850LL, 6},
    {114, 1, 2411209711LL, 6},
    {115, 1, 2390242670LL, 6},
    {116, 1, 2369637129LL, 6},
    {117, 1, 2349383821LL, 6},
    {118, 1, 2329473788LL, 6},
    {119, 1, 2309898378LL, 6},
    {120, 1, 2290649225LL, 6},
    {121, 1, 2271718240LL, 6},
    {122, 1, 2253097598LL, 6},
    {123, 1, 2234779732LL, 6},
    {124, 1, 2216757315LL, 6},
    {125, 1, 2199023256LL, 6},
    {126, 1, 2181570691LL, 6},
    {127, 1, 2164392969LL, 6},
    {128, 1, 2147483649LL, 6},
    {129, 1, 4261672976LL, 7},
    {130, 1, 4228890877LL, 7},
    {131, 1, 4196609267LL, 7},
    {132, 1, 4164816772LL, 7},
    {133, 1, 4133502361LL, 7},
    {134, 1, 4102655328LL, 7},
    {135, 1, 4072265289LL, 7},
    {136, 1, 4042322161LL, 7},
    {137, 1, 4012816160LL, 7},
    {138, 1, 3983737782LL, 7},
    {139, 1, 3955077798LL, 7},
    {140, 1, 3926827243LL, 7},
    {141, 1, 3898977404LL, 7},
    {142, 1, 3871519817LL, 7},
    {143, 1, 3844446251LL, 7},
    {144, 1, 3817748708LL, 7},
    {145, 1, 3791419407LL, 7},
    {146, 1, 3765450781LL, 7},
    {147, 1, 3739835469LL, 7},
    {148, 1, 3714566311LL, 7},
    {149, 1, 3689636335LL, 7},
    {150, 1, 3665038760LL, 7},
    {151, 1, 3640766980LL, 7},
    {152, 1, 3616814566LL, 7},
    {153, 1, 3593175255LL, 7},
    {154, 1, 3569842948LL, 7},
    {155, 1, 3546811703LL, 7},
    {156, 1, 3524075731LL, 7},
    {157, 1, 3501629388LL, 7},
    {158, 1, 3479467177LL, 7},
    {159, 1, 3457583736LL, 7},
    {160, 1, 3435973837LL, 7},
    {161, 1, 3414632385LL, 7},
    {162, 1, 3393554407LL, 7},
    {163, 1, 3372735055LL, 7},
    {164, 1, 3352169597LL, 7},
    {165, 1, 3331853418LL, 7},
    {166, 1, 3311782012LL, 7},
    {167, 1, 3291950982LL, 7},
    {168, 1, 3272356036LL, 7},
    {169, 1, 3252992982LL, 7},
    {170, 1, 3233857729LL, 7},
    {171, 1, 3214946281LL, 7},
    {172, 1, 3196254732LL, 7},
    {173, 1, 3177779272LL, 7},
    {174, 1, 3159516172LL, 7},
    {175, 1, 3141461794LL, 7},
    {176, 1, 3123612579LL, 7},
    {177, 1, 3105965051LL, 7},
    {178, 1, 3088515809LL, 7},
    {179, 1, 3071261531LL, 7},
    {180, 1, 3054198967LL, 7},
    {181, 1, 3037324939LL, 7},
    {182, 1, 3020636341LL, 7},
    {183, 1, 3004130131LL, 7},
    {184, 1, 2987803337LL, 7},
    {185, 1, 2971653049LL, 7},
    {186, 1, 2955676419LL, 7},
    {187, 1, 2939870663LL, 7},
    {188, 1, 2924233053LL, 7},
    {189, 1, 2908760921LL, 7},
    {190, 1, 2893451653LL, 7},
    {191, 1, 2878302691LL, 7},
    {192, 1, 2863311531LL, 7},
    {193, 1, 2848475720LL, 7},
    {194, 1, 2833792856LL, 7},
    {195, 1, 2819260585LL, 7},
    {196, 1, 2804876602LL, 7},
    {197, 1, 2790638650LL, 7},
    {198, 1, 2776544515LL, 7},
    {199, 1, 2762592030LL, 7},
    {200, 1, 2748779070LL, 7},
    {201, 1, 2735103552LL, 7},
    {202, 1, 2721563436LL, 7},
    {203, 1, 2708156719LL, 7},
    {204, 1, 2694881441LL, 7},
    {205, 1, 2681735678LL, 7},
    {206, 1, 2668717544LL, 7},
    {207, 1, 2655825188LL, 7},
    {208, 1, 2643056798LL, 7},
    {209, 1, 2630410593LL, 7},
    {210, 1, 2617884829LL, 7},
    {211, 1, 2605477791LL, 7},
    {212, 1, 2593187802LL, 7},
    {213, 1, 2581013211LL, 7},
    {214, 1, 2568952402LL, 7},
    {215, 1, 2557003786LL, 7},
    {216, 1, 2545165806LL, 7},
    {217, 1, 2533436931LL, 7},
    {218, 1, 2521815661LL, 7},
    {219, 1, 2510300521LL, 7},
    {220, 1, 2498890064LL, 7},
    {221, 1, 2487582869LL, 7},
    {222, 1, 2476377541LL, 7},
    {223, 1, 2465272709LL, 7},
    {224, 1, 2454267027LL, 7},
    {225, 1, 2443359173LL, 7},
    {226, 1, 2432547850LL, 7},
    {227, 1, 2421831780LL, 7},
    {228, 1, 2411209711LL, 7},
    {229, 1, 2400680410LL, 7},
    {230, 1, 2390242670LL, 7},
    {231, 1, 2379895299LL, 7},
    {232, 1, 2369637129LL, 7},
    {233, 1, 2359467013LL, 7},
    {234, 1, 2349383821LL, 7},
    {235, 1, 2339386443LL, 7},
    {236, 1, 2329473788LL, 7},
    {237, 1, 2319644785LL, 7},
    {238, 1, 2309898378LL, 7},
    {239, 1, 2300233531LL, 7},
    {240, 1, 2290649225LL, 7},
    {241, 1, 2281144456LL, 7},
    {242, 1, 2271718240LL, 7},
    {243, 1, 2262369605LL, 7},
    {244, 1, 2253097598LL, 7},
    {245, 1, 2243901282LL, 7},
    {246, 1, 2234779732LL, 7},
    {247, 1, 2225732041LL, 7},
    {248, 1, 2216757315LL, 7},
    {249, 1, 2207854675LL, 7},
    {250, 1, 2199023256LL, 7},
    {251, 1, 2190262207LL, 7},
    {252, 1, 2181570691LL, 7},
    {253, 1, 2172947881LL, 7},
    {254, 1, 2164392969LL, 7},
    {255, 1, 2155905153LL, 7},
};
}  // namespace IntegerDivision
}  // namespace Internal
}  // namespace Halide
